/************************************************************************************/

/*                                                                                  */
/*            Parser SPICE -> MBK : TRICHES Laurent le 20/08/92                     */
/*                                                                                  */
/************************************************************************************/
#include MUT_H 
#include MLO_H
#include MLU_H
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "fonc.h"
#include "max.h"
#include "global.h"
#include "erreur.h"

void spiceloadlofig(ptgif,name,mode)
lofig_list *ptgif;
char *name;
char mode;
{
char		tmp_name[80];
char 		tmp_mv[80];
char 		file_name[80];
char		ligne[ MAXLIG + 1 ];
char            *str ;
short		dicogdt = 0 ;
register int	dans_subckt = 0, go_dico = 0;
register int	eldo, cadence, vti, dax;
losig_list	*ptsig;

	str = getenv("MBK_SPI_TN");
	if (str != NULL) 
		strcpy(modn, namealloc(str));
	str = getenv("MBK_SPI_TP");
	if (str != NULL) 
		strcpy(modp, namealloc(str));
	str = getenv("MBK_SPI_MAXSIGINDEX");
	if (str != NULL) 
		MAXSIGINDEX= atoi(str);

	if (!(infile =mbkfopen(name,"spi",READ_TEXT)))
	{
		fprintf(stderr, "*** mbk error *** can't open file %s\n", name);
		EXIT(-1);
	}

	yy_figname = name;
	spi_init_hash();
	
	numlig = 1;
	eldo = cadence = vti = dax = flag_dico = 0;

	while ( fgets(ligne, MAXLIG, infile) != (char *)0)
	{
		formater_ligne(ligne);
		trouver_plus(ligne);


		if (dico_cadence(ligne))
		{
			go_dico = flag_dico;
			if (dax | vti | eldo)
				mbkspice_erreur(DEUX_DICOS);
			traite_dico_cadence(ligne);
			cadence = 1;
		}
		else
		if (dico_dax(ligne))
		{
			go_dico = flag_dico;
			if (cadence | vti | eldo)
				mbkspice_erreur(DEUX_DICOS);
			traite_dico_dax(ligne);
			dax = 1;
		}
		else
		if (dico_vti(ligne))
		{
			go_dico = flag_dico;
			if (dax | cadence | eldo)
				mbkspice_erreur(DEUX_DICOS);
			traite_dico_vti(ligne);
			vti = 1;
		}
		else
		if (dico_eldo(ligne))
		{
			go_dico = flag_dico;
			if (dax | vti | cadence)
				mbkspice_erreur(DEUX_DICOS);
			traite_dico_eldo(ligne);
			eldo = 1;
		}
		else
		/*---------------------------------------------------*/
		/* particularite du format GDT: le dico est a LA FIN */
		/* de chaque subckt.                                 */
		/*---------------------------------------------------*/
		if (dico_gdt(ligne))
		{
			dicogdt = 1 ;
		}
		else
		if (debut_subckt(ligne))
		{
			if(spi_main_gdt == 1)
			{
				spi_main_gdt = 0 ;
				spi_clear_hash();
				spi_index = 2;
			}

			if (dans_subckt)
				mbkspice_erreur(MANQUE_FIN_SUBCKT);
			traite_debut_subckt(ptgif,ligne);
			dans_subckt = 1;
		}
		else
		if (transistor(ligne))
		{
			if ((dans_subckt) || (spi_main_gdt))
			{
				if (fig_loaded)
				{
					enleve_blancs_egal(ligne);
					traite_transistor(ligne);
				}
			}
			else
				mbkspice_erreur(TRANSISTOR_EXT_SUBCKT);
		}
		else
		if (capacite(ligne))
		{
			if (dans_subckt || spi_main_gdt)
				if (fig_loaded)
					traite_capacite(ligne);
			else
				mbkspice_erreur(CAPACITE_EXT_SUBCKT);
		}
		else
		if (instance(ligne))
		{
			if (dans_subckt || spi_main_gdt)
				if (fig_loaded)
					traite_instance(ligne);
			else
				mbkspice_erreur(INSTANCE_EXT_SUBCKT);
		}
		else
		if (fin_subckt(ligne))
		{
			if (!dans_subckt)
				mbkspice_erreur(MANQUE_DEBUT_SUBCKT);
			traite_fin_subckt(ligne);
			dans_subckt = 0;
		}
		else
		if (!dans_subckt)
		if (main_gdt(ptgif,ligne) != 0)
		{
			spi_main_gdt = 1 ;
		}
        ++numlig ;
	}
	
	fclose(infile);

	spi_clear_hash();
	spi_index = 2;

	/* parcours du dico pour les signaux */

	if(ptdic != NULL) traite_dicos_2(ptgif);

}
