/*******************************************************************************
* mlo     : constantes, externs, and data-structures                           *
*                                                                              *
* version : 4.03                                                               *
* date    : 05/08/93                                                           *
*******************************************************************************/
#ifndef MLO
#define MLO

/* transistor type */
#define TRANSN      4
#define TRANSP      8

/* connector & signal direction */
#define INTERNAL    'I' /* instance connector or signal on instances only */
#define EXTERNAL    'E' /* figure connector or signal on figure and instances */

/* connector direction */
#define IN          'I'
#define OUT         'O'
#define INOUT       'B'
#define UNKNOWN     'X'
#define TRISTATE    'Z'
#define TRANSCV     'T'

/*******************************************************************************
* netlist structures types                                                     *
*******************************************************************************/
typedef struct lofig                          /* logical figure               */
{
struct lofig  *NEXT;                          /* next figure                  */
struct chain  *MODELCHAIN;                    /* list of models               */
struct locon  *LOCON;                         /* connector list head          */
struct losig  *LOSIG;                         /* signal list head             */
struct ptype  *BKSIG;                         /* signal block list head       */
struct loins  *LOINS;                         /* instance list head           */
struct lotrs  *LOTRS;                         /* transistor list head         */
char          *NAME;                          /* figure name (unique)         */
char          MODE;                           /* if 'A' all , else perif only */
struct ptype  *USER;                          /* Application specific         */
}
lofig_list;

typedef struct lotrs                           /* logical transistor          */
{
struct lotrs  *NEXT;                           /* next transistor             */
struct locon  *DRAIN;                          /* drain connector             */
struct locon  *GRID;                           /* grid connector              */
struct locon  *SOURCE;                         /* source connector            */
unsigned short WIDTH,LENGTH;                   /* transistor width & length   */
unsigned short PS, PD;                         /* source & drain perimeters   */
unsigned short XS, XD;                         /* values for area computation */
long           X,Y;                            /* transistor coordinates      */
char           TYPE;                           /* transistor type             */
struct ptype  *USER;                           /* application specific        */
}
lotrs_list;

typedef struct loins                           /* logical instance            */
{
struct loins  *NEXT;                           /* next figure                 */
struct locon  *LOCON;                          /* connector list head         */
char          *INSNAME;                        /* instance name               */
char          *FIGNAME;                        /* model name                  */
struct ptype  *USER;                           /* Application specific        */
}
loins_list;

typedef struct locon                           /* logical connector           */
{
struct locon  *NEXT;                           /* next connector              */
char          *NAME;                           /* connector name (unique)     */
struct losig  *SIG;                            /* pointer on signal           */
void          *ROOT;                           /* pointer on figure/instance  */
char          DIRECTION;                       /* see defines for information */
char          TYPE;                            /* instance I  / figure E      */
struct ptype  *USER;                           /* Application specific        */
}
locon_list;

typedef struct losig                           /* logical signal              */
{
struct losig  *NEXT;                           /* next signal                 */
struct chain  *NAMECHAIN;                      /* list of alias name          */
float         CAPA;                            /* capacitance                 */
long          INDEX;                           /* signal index (unique)       */
char          TYPE;                            /* internal I  / external E    */
struct ptype  *USER;                           /* Application specific        */
}
losig_list;

/*******************************************************************************
* externals for mbk netlist view                                               *
*******************************************************************************/
extern lofig_list *HEAD_LOFIG;                 /* physical figure list head   */
extern lofig_list *addlofig();
extern lofig_list *addlomodel();
extern loins_list *addloins();
extern lotrs_list *addlotrs();
extern locon_list *addlocon();
extern losig_list *addlosig();
extern void addcapa();
extern int dellofig();
extern void freelomodel();
extern int dellosig();
extern int delloins();
extern int dellotrs();
extern int dellocon();
extern lofig_list *getlofig();
extern lofig_list *getlomodel();
extern loins_list *getloins();
extern locon_list *getlocon();
extern losig_list *getlosig();
extern char *getsigname();
extern void lofigchain();
extern void viewlo();
#endif /* !MLO */
