/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     : scp_time.c                                                  */
/*     Contents : timing gunctions                                            */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Xavier Picat                       Date : 02/07/1993     */
/*                                                                            */
/******************************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/times.h>
#include "scp_time.h"

#define HZ	50
/*---------------------------------------------------------\
					Les variables locales
\---------------------------------------------------------*/
static struct tms start_time;

/*---------------------------------------------------------\
					set_time
\---------------------------------------------------------*/
void set_time ()
{
	times (&start_time);
} /* fin de set_time */

/*---------------------------------------------------------\
					get_time
\---------------------------------------------------------*/
float get_time ()
{
	struct tms end_time;

	times (&end_time);
	return ((float) (end_time.tms_utime - start_time.tms_utime)/(float) HZ
	      + (float) (end_time.tms_stime - start_time.tms_stime)/(float) HZ);
} /* fin de get_time */
