/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  graal.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

# ident "@(#)GRAAL ver 1.1 August 1993"

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RUT_H
# include GSB_H
# include GRM_H
# include GMX_H

# include "graal.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                           present                           |
|                                                             |
\------------------------------------------------------------*/

  void GraalPresent()
  {
    fprintf( stdout, "\n" );
    fprintf( stdout, "\n                @@@@ @                                @@@@  " );
    fprintf( stdout, "\n              @@    @@                                  @@  " );
    fprintf( stdout, "\n             @@      @                                  @@  " );
    fprintf( stdout, "\n            @@           @@@ @@@    @@@@      @@@@      @@  " );
    fprintf( stdout, "\n            @@            @@@  @@  @@   @    @@   @     @@  " );
    fprintf( stdout, "\n            @@     @@@@@  @@   @@  @@   @@   @@   @@    @@  " );
    fprintf( stdout, "\n            @@     @ @@   @@         @@@@@     @@@@@    @@  " );
    fprintf( stdout, "\n            @@    @  @@   @@       @@   @@   @@   @@    @@  " );
    fprintf( stdout, "\n             @@      @@   @@      @@    @@  @@    @@    @@  " );
    fprintf( stdout, "\n              @@    @@    @@      @@   @@@  @@   @@@    @@  " );
    fprintf( stdout, "\n                @@@@     @@@@      @@@@  @@  @@@@  @@ @@@@@@" );
    fprintf( stdout, "\n" );
    fprintf( stdout, "\n                          Graphic layout editor" );
    fprintf( stdout, "\n" );
    fprintf( stdout, "\n                 Alliance CAD System Graal,   graal 1.05" );
    fprintf( stdout, "\n                 Copyright (c) 1994, MASI, CAO-VLSI Team" );
    fprintf( stdout, "\n                 E-mail support:    cao-vlsi@masi.ibp.fr" );
    fprintf( stdout, "\n\n" );
  }

/*------------------------------------------------------------\
|                                                             |
|                            main                             |
|                                                             |
\------------------------------------------------------------*/

  int main( argc, argv )

      int   argc;
      char *argv[];
  {
    char *FileName   = (char *)NULL;
    char  WindowInfo = 0;
    int   Index;
 
    GraalPresent();

    mbkenv();
    rdsenv();
    loadrdsparam();
    GraalLoadParameters();

    for ( Index = 1;
          Index < argc;
          Index++ )
    {
      if ( ! strcmp( argv[ Index ], "-l" ) )
      {
        if ( ( Index + 1 ) < argc )
        {
          Index    = Index + 1;
          FileName = argv[ Index ];
        }
      }
      else
      if ( ! strcmp( argv[ Index ], "-w" ) )
      {
        WindowInfo = 1;
      }
    }

    GraalInitializeRessources( &argc, argv );
    GraalInitializeWindow();

    if ( WindowInfo )
    {
      fprintf( stdout, "\nGraal window\n" );
      fprintf( stdout, "\n  XMIN : %d"  , GraalWindowXmin / RDS_LAMBDA );
      fprintf( stdout, "\n  XMAX : %d"  , GraalWindowXmax / RDS_LAMBDA );
      fprintf( stdout, "\n  YMIN : %d"  , GraalWindowYmin / RDS_LAMBDA );
      fprintf( stdout, "\n  YMAX : %d"  , GraalWindowYmax / RDS_LAMBDA );
      fprintf( stdout, "\n  SIDE : %d"  , GraalWindowSide / RDS_LAMBDA );
      fprintf( stdout, "\n  DX   : %d"  , GraalWindowDx                );
      fprintf( stdout, "\n  DY   : %d"  , GraalWindowDy                );
      fprintf( stdout, "\n  SIZE : %d\n", GraalWindowSize              );
    }

    GraalInitializeCutCxTable();
    GraalInitializeErrorMessage();

    if ( FileName != (char *)NULL )
    {
      GraalFigureMbk = Graalgetphfig( FileName, 'A' );
    }

    XtAppMainLoop( GraalApplication ); 
  }
