/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  GSB101.h                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef GRAAL_GSB 
# define GRAAL_GSB 

# define GRAAL_TRUE   1
# define GRAAL_FALSE  0

# define GRAAL_ERROR  1
# define GRAAL_OK     0

# define GRAAL_NORTH        0
# define GRAAL_SOUTH        1
# define GRAAL_EAST         2
# define GRAAL_WEST         3

# define GRAAL_NORTH_MASK   1
# define GRAAL_SOUTH_MASK   2
# define GRAAL_WEST_MASK    4
# define GRAAL_EAST_MASK    8

# define GRAAL_DEFAULT_FIGURE_NAME      "NONAME"

/*------------------------------------------------------------\
|                                                             |
|                           Edit Mode                         |
|                                                             |
\------------------------------------------------------------*/

# define GRAAL_EDIT_MEASURE           (char)0x00
# define GRAAL_CREATE_SEGMENT         (char)0x01
# define GRAAL_CREATE_SEGMENT_WIRE    (char)0x02
# define GRAAL_CREATE_VIA             (char)0x03
# define GRAAL_CREATE_TRANSISTOR      (char)0x04
# define GRAAL_CREATE_TRANSISTOR_WIRE (char)0x05
# define GRAAL_CREATE_CONNECTOR       (char)0x06
# define GRAAL_CREATE_INSTANCE        (char)0x07
# define GRAAL_CREATE_REFERENCE       (char)0x08
# define GRAAL_CREATE_ABUTMENTBOX     (char)0x09
# define GRAAL_SELECT_POINT_IDENTIFY  (char)0x0A
# define GRAAL_SELECT_POINT_COPY      (char)0x0B
# define GRAAL_SELECT_POINT_MOVE      (char)0x0C
# define GRAAL_SELECT_POINT_DELETE    (char)0x0D
# define GRAAL_SELECT_POINT_STRETCH   (char)0x0E
# define GRAAL_SELECT_POINT_MODIFY    (char)0x0F
# define GRAAL_SELECT_WINDOW_COPY     (char)0x10
# define GRAAL_SELECT_WINDOW_MOVE     (char)0x11
# define GRAAL_SELECT_WINDOW_DELETE   (char)0x12
# define GRAAL_SELECT_WINDOW_MODIFY   (char)0x13
# define GRAAL_SELECT_WINDOW_IDENTIFY (char)0x14
# define GRAAL_EDIT_COPY_POINT        (char)0x15
# define GRAAL_EDIT_COPY_WINDOW       (char)0x16
# define GRAAL_EDIT_MOVE_POINT        (char)0x17
# define GRAAL_EDIT_MOVE_WINDOW       (char)0x18
# define GRAAL_EDIT_STRETCH_POINT     (char)0x19
# define GRAAL_TOOLS_EQUI             (char)0x1A
# define GRAAL_TOOLS_FLATTEN          (char)0x1B
# define GRAAL_TOOLS_UNFLATTEN        (char)0x1C
# define GRAAL_TOOLS_PEEK             (char)0x1D
# define GRAAL_TOOLS_DRUC             (char)0x1E

# define GRAAL_ZOOM_CENTER            (char)0x80
# define GRAAL_ZOOM_IN                (char)0x81
# define GRAAL_ZOOM_PAN               (char)0x82

# define GRAAL_ZOOM_MARK              (char)0x80

/*------------------------------------------------------------\
|                                                             |
|                           Input Mode                        |
|                                                             |
\------------------------------------------------------------*/

# define GRAAL_INPUT_POINT     0
# define GRAAL_INPUT_ORTHO     1
# define GRAAL_INPUT_LINE      2
# define GRAAL_INPUT_LSTRING   3
# define GRAAL_INPUT_BOX       4
# define GRAAL_INPUT_SORTHO    5
# define GRAAL_INPUT_HALF_BOX  6

/*------------------------------------------------------------\
|                                                             |
|                           Active Name                       |
|                                                             |
\------------------------------------------------------------*/

# define GRAAL_FIGURE_NAME                 0
# define GRAAL_INSTANCE_NAME               1
# define GRAAL_FIGURE_CONNECTOR_NAME       2
# define GRAAL_INSTANCE_CONNECTOR_NAME     3
# define GRAAL_FIGURE_SEGMENT_NAME         4
# define GRAAL_INSTANCE_SEGMENT_NAME       5
# define GRAAL_FIGURE_REFERENCE_NAME       6
# define GRAAL_INSTANCE_REFERENCE_NAME     7

# define GRAAL_MAX_ACTIVE_NAME             8

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  extern char  *GRAAL_SEGMENT_NAME_TABLE[ MBK_MAX_LAYER ][ 3 ];
  extern char  *GRAAL_CONNECTOR_NAME_TABLE[ MBK_MAX_LAYER ][ 3 ];
  extern long   GRAAL_SEGMENT_VALUE_TABLE[ MBK_MAX_LAYER ][ 2 ];
  extern char  *GRAAL_VIA_NAME_TABLE[ MBK_MAX_VIA ][ 3 ];
  extern char  *GRAAL_REFERENCE_NAME_TABLE[ MBK_MAX_REFERENCE ][ 3 ];
  extern char  *GRAAL_ORIENT_NAME_TABLE[ MBK_MAX_ORIENT ][ 3 ];
  extern char  *GRAAL_SYMMETRY_NAME_TABLE[ MBK_MAX_SYMMETRY ][ 3 ];
  extern char  *GRAAL_RDS_LAYER_NAME_TABLE[ RDS_MAX_LAYER ][ 3 ];
  extern long   GRAAL_PEEK_BOUND;
  extern float  GRAAL_LOWER_GRID_STEP;
  extern float  GRAAL_LOWER_FIGURE_STEP;
  extern float  GRAAL_LOWER_INSTANCE_STEP;
  extern float  GRAAL_LOWER_REFERENCE_STEP;
  extern float  GRAAL_LOWER_SEGMENT_STEP;
  extern float  GRAAL_LOWER_CONNECTOR_STEP;

  extern char   GRAAL_RDS_ACTIVE_LAYER_TABLE[ RDS_MAX_LAYER ];
  extern char   GRAAL_RDS_ACTIVE_NAME_TABLE[ GRAAL_MAX_ACTIVE_NAME ];
  extern long   GRAAL_CUT_C_X_N_TABLE [ 16 ][ 4 ][ 4 ];
  extern long   GRAAL_CUT_C_X_P_TABLE [ 16 ][ 4 ][ 4 ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern char *GraalPostTreatString();
  extern void GraalLoadParameters();
  extern void GraalViewParameters();
  extern void GraalInitializeCutCxTable();

# endif
