/*------------------------------------------------------------\
|                                                             |
| File    :                  Search.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GSB_H
# include "GRM_search.h"

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  graalsearch *GraalHeadSearch = (graalsearch *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       Alloc Functions                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        GraalAllocSearch                     |
|                                                             |
\------------------------------------------------------------*/

   graalsearch *GraalAllocSearch()
   {
     return((graalsearch *)rdsalloc(sizeof(graalsearch), 1));
   }

/*------------------------------------------------------------\
|                                                             |
|                        Free Functions                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         GraalFreeSearch                     |
|                                                             |
\------------------------------------------------------------*/
  
  void GraalFreeSearch( FreeSearch )

     graalsearch *FreeSearch;
  {
    rdsfree((char *)FreeSearch, sizeof(graalsearch));
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalAddSearch                        |
|                                                             |
\------------------------------------------------------------*/

  void GraalAddSearch( Rectangle )

     rdsrec_list *Rectangle;
  {
    graalsearch *Search;

    Search = GraalAllocSearch();

    Search->RECTANGLE = Rectangle;
    Search->NEXT      = GraalHeadSearch;
    GraalHeadSearch   = Search;
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalDelSearch                        |
|                                                             |
\------------------------------------------------------------*/

  void GraalDelSearch()

  {
    graalsearch *Search;

    while ( GraalHeadSearch != (graalsearch *)NULL )
    {
      Search          = GraalHeadSearch;
      GraalHeadSearch = GraalHeadSearch->NEXT;

      GraalFreeSearch( Search );
    }
  }
