/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Druc.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GSB_H
# include DRC_H
# include "GRM_window.h"
# include "GRM_druc.h"

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       GraalAddDruc                          |
|                                                             |
\------------------------------------------------------------*/

   rdsrec_list *GraalAddDruc( DrucRec )

      rdsrec_list *DrucRec;
   {
     rdsrec_list *ScanDrucRec;
     rdsrec_list *ScanRec;
     rdsrec_list *First;
     rdsrec_list *Link;

     First = (rdsrec_list *)NULL;

     if ( ! IsGraalDruc( DrucRec ) )
     {
       ScanDrucRec = DrucRec;

       do
       {
         ScanRec = 
      
           addrdsfigrec( GraalFigureRds, ScanDrucRec->NAME, 
                         GetRdsLayer( ScanDrucRec ),
                         ScanDrucRec->X, ScanDrucRec->Y,
                         ScanDrucRec->DX, ScanDrucRec->DY );

         SetGraalDruc( ScanRec );
         SetGraalDruc( ScanDrucRec );

         if ( ScanRec->NEXT != (rdsrec_list *)NULL )
         {
           GRAAL_PREVIOUS( ScanRec->NEXT ) = &ScanRec->NEXT;
         }

         GRAAL_PREVIOUS( ScanRec ) = 

           &GraalFigureRds->LAYERTAB[ GetRdsLayer( ScanRec ) ];

         GraalInsertRectangle( ScanRec );

         if ( First == (rdsrec_list *)NULL )
         {
           First = ScanRec;
           Link  = ScanRec;
         }
         else
         {
           Link->USER = (void *)ScanRec;
           Link       = ScanRec;
         }

         ScanDrucRec = MACRO_NEXT_EQUI( ScanDrucRec );
       }
       while ( ScanDrucRec != DrucRec );

       Link->USER = (void *)First;
     }

     return( First );
   }

/*------------------------------------------------------------\
|                                                             |
|                       GraalDelDruc                          |
|                                                             |
\------------------------------------------------------------*/

  void GraalDelDruc( Rectangle )

    rdsrec_list *Rectangle;
  {
    rdsrec_list *ScanRec;
    rdsrec_list *DelRec;

    ScanRec = Rectangle;

    do
    {
      DelRec  = ScanRec;
      ScanRec = (rdsrec_list *)(ScanRec->USER);

      *(GRAAL_PREVIOUS( DelRec )) = DelRec->NEXT;

      if ( DelRec->NEXT != (rdsrec_list *)NULL )
      {
        GRAAL_PREVIOUS( DelRec->NEXT ) = GRAAL_PREVIOUS( DelRec );
      }

      GraalEraseRectangle( DelRec );

      freerdsrec( DelRec, GRAAL_SIZE );
    }
    while ( ScanRec != Rectangle );
  }
