/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Colors.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
 
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RDS_H
# include GSB_H
# include GMX_H
# include "GMX_color.h" 

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  GC   GraalLayerFillGC   [ RDS_MAX_LAYER ];
  GC   GraalLayerDrawGC   [ RDS_MAX_LAYER ];
  GC   GraalLayerAcceptGC [ RDS_MAX_LAYER ];
  GC   GraalLayerEquiGC   [ RDS_MAX_LAYER ];
  GC   GraalLayerDrucGC   [ RDS_MAX_LAYER ];
  GC   GraalAcceptDrawGC;
  GC   GraalDrucDrawGC;
  GC   GraalEquiDrawGC;
  GC   GraalBackgroundGC;
  GC   GraalGridGC;
  GC   GraalSmallTextGC;
  GC   GraalMediumTextGC;
  GC   GraalLargeTextGC;
  GC   GraalXorGC;

  XFontStruct *GraalLargeTextFont;
  XFontStruct *GraalMediumTextFont;
  XFontStruct *GraalSmallTextFont;

/*------------------------------------------------------------\
|                                                             |
|                      Layer Color Define                     |
|                                                             |
\------------------------------------------------------------*/

  static char GraalLayerPatternDefine[ RDS_MAX_LAYER ] =

  {  
        0, /* NWELL  */
        0, /* PWELL  */
        0, /* NIMP   */
        0, /* PIMP   */
        0, /* ACTIV  */
        1, /* NDIF   */
        1, /* PDIF   */
        1, /* NTIE   */
        1, /* PTIE   */
        3, /* POLY   */
        2, /* GATE   */
        3, /* TPOLY  */
        5, /* CONT   */
        4, /* ALU1   */
        4, /* TALU1  */
        5, /* VIA1   */
        6, /* ALU2   */
        6, /* TALU2  */
        5, /* VIA2   */
        8, /* ALU3   */
        8, /* TALU3  */
        5, /* VIA3   */
        9, /* ALU4   */
        7, /* CPAS   */
        7, /* REF    */
        0, /* USER0  */
        0, /* USER1  */
        0, /* USER2  */
        0, /* ABOX   */
  };


  static char GraalPatternBits[ GRAAL_MAX_PATTERN ][ GRAAL_PATTERN_SQUARE ] =

  {                             /* FOR SUBST */
    { 
      0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
    }
    ,                           /* FOR DIF   */
    { 
      0x77, 0x77, 0xbb, 0xbb, 0xdd, 0xdd, 0xee, 0xee, 0x77, 0x77, 0xbb, 0xbb,
      0xdd, 0xdd, 0xee, 0xee, 0x77, 0x77, 0xbb, 0xbb, 0xdd, 0xdd, 0xee, 0xee,
      0x77, 0x77, 0xbb, 0xbb, 0xdd, 0xdd, 0xee, 0xee
    }
    ,                           /* FOR GATE  */
    {
      0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
      0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
      0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55
    }
    ,                           /* FOR POLY  */
    { 
      0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
      0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
      0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa
    }
    ,                           /* FOR ALU1  */
    { 
      0x88, 0x88, 0x44, 0x44, 0x22, 0x22, 0x11, 0x11, 0x88, 0x88, 0x44, 0x44,
      0x22, 0x22, 0x11, 0x11, 0x88, 0x88, 0x44, 0x44, 0x22, 0x22, 0x11, 0x11,
      0x88, 0x88, 0x44, 0x44, 0x22, 0x22, 0x11, 0x11
    }
    ,                           /* FOR CONT  */
    { 
      0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff,
      0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff,
      0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff
    }
    ,                           /* FOR ALU2  */
    { 
      0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00,
      0x44, 0x44, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
      0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00
    }
    ,                           /* FOR REF   */
    { 
      0xaa, 0xaa, 0x11, 0x11, 0xaa, 0xaa, 0x44, 0x44, 0xaa, 0xaa, 0x11, 0x11,
      0xaa, 0xaa, 0x44, 0x44, 0xaa, 0xaa, 0x11, 0x11, 0xaa, 0xaa, 0x44, 0x44,
      0xaa, 0xaa, 0x11, 0x11, 0xaa, 0xaa, 0x44, 0x44
    }
    ,                           /* FOR ALU3  */
    {
      0x44, 0x44, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
      0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00,
      0x44, 0x44, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00
    } 
    ,                           /* FOR ALU4  */
    { 
      0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00
    }
  };

  static Pixmap GraalPattern[ GRAAL_MAX_PATTERN ];

  static char  *GraalColorName[ 6 ] =

  {
    GRAAL_BLACK_COLOR,
    GRAAL_WHITE_COLOR,
    GRAAL_TEXT_COLOR ,
    GRAAL_ACCEPT_COLOR,
    GRAAL_EQUI_COLOR,
    GRAAL_DRUC_COLOR
  };

  static int GraalColor[ GRAAL_MAX_COLOR ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     GraalInitializeColors                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeColors()

  {
    XColor   ForgetIt;
    XColor   GetIt;
    Window   Root;
    int      Counter;
    Colormap ColorMap;
    char     Error;
    char    *ColorName;

    ColorMap  = DefaultColormapOfScreen ( XtScreen ( GraalGraphicWindow ) );
    Error     = False;

    for ( Counter = 0; Counter < GRAAL_MAX_COLOR; Counter++ )
    {
      if ( Counter >= 6 )
      {
        ColorName = GRAAL_RDS_LAYER_NAME_TABLE[ Counter - 6 ][ 1 ];
      }
      else
      {
        ColorName = GraalColorName[ Counter ];
      }

      if ( ColorName != (char *)NULL )
      {
        if ( ! XAllocNamedColor( XtDisplay( GraalGraphicWindow ), 
                                 ColorMap, ColorName, 
                                &GetIt, &ForgetIt ) ) 
        {
          fprintf ( stderr, "\nGmx101: Color name '%s' is not in X11 database !\n",
                            ColorName );

          Error = True;
        }

        GraalColor[ Counter ] = GetIt.pixel;
      }
      else 
      {
        GraalColor[ Counter ] = GraalColor[ 0 ];
      }
    }

    if ( Error == True ) exit( 1 );

    Root = RootWindowOfScreen ( XtScreen ( GraalGraphicWindow ) );

    for ( Counter = 0; Counter < GRAAL_MAX_PATTERN; Counter++ )
    {
      GraalPattern[ Counter ]  =

        XCreateBitmapFromData( XtDisplay( GraalGraphicWindow ),
                               Root,
                               GraalPatternBits[ Counter ],
                               GRAAL_PATTERN_WIDTH,
                               GRAAL_PATTERN_HEIGHT );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                 GraalInitializeGraphicContext               |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeGraphicContext()

  {
    XGCValues GraphicValue;
    int       Counter;
    Window    Root;
    char      Pattern;

    GraalLargeTextFont = XLoadQueryFont( XtDisplay( GraalGraphicWindow ),
                                         GRAAL_LARGE_TEXT_FONT_NAME );

    GraalMediumTextFont = XLoadQueryFont( XtDisplay( GraalGraphicWindow ),
                                          GRAAL_MEDIUM_TEXT_FONT_NAME );

    GraalSmallTextFont = XLoadQueryFont( XtDisplay( GraalGraphicWindow ),
                                         GRAAL_SMALL_TEXT_FONT_NAME );

    GraphicValue.foreground = GraalColor[ 0 ];  /* Black */
    GraphicValue.background = GraalColor[ 0 ];
    GraphicValue.plane_mask = AllPlanes;

    Root = RootWindowOfScreen ( XtScreen ( GraalGraphicWindow ) ),

    GraalBackgroundGC = XCreateGC ( XtDisplay( GraalGraphicWindow ), 
                                    Root,
                                    ( GCForeground |
                                      GCBackground |
                                      GCPlaneMask ),
                                      &GraphicValue );

    GraphicValue.foreground = GraalColor[ 1 ];  /* White */

    GraalGridGC = XCreateGC ( XtDisplay( GraalGraphicWindow ), 
                              Root,
                              ( GCForeground |
                                GCBackground |
                                GCPlaneMask ),
                                &GraphicValue );

    GraphicValue.foreground = GraalColor[ 3 ];
 
    GraalAcceptDrawGC = XCreateGC ( XtDisplay( GraalGraphicWindow ),
                                   Root,
                                   ( GCForeground |
                                     GCBackground |
                                     GCPlaneMask ),
                                    &GraphicValue );

    GraphicValue.foreground = GraalColor[ 4 ];

    GraalEquiDrawGC = XCreateGC ( XtDisplay( GraalGraphicWindow ),
                                  Root,
                                  ( GCForeground |
                                    GCBackground |
                                    GCPlaneMask ),
                                   &GraphicValue );

    GraphicValue.foreground = GraalColor[ 5 ];

    GraalDrucDrawGC = XCreateGC ( XtDisplay( GraalGraphicWindow ),
                                  Root,
                                  ( GCForeground |
                                    GCBackground |
                                    GCPlaneMask ),
                                   &GraphicValue );

    GraphicValue.foreground = GraalColor[ 2 ];  /* Text  */

    GraalSmallTextGC = XCreateGC ( XtDisplay( GraalGraphicWindow ), 
                                   Root,
                                   ( GCForeground |
                                     GCBackground |
                                     GCPlaneMask ),
                                     &GraphicValue );

    GraalMediumTextGC = XCreateGC ( XtDisplay( GraalGraphicWindow ), 
                                    Root,
                                    ( GCForeground |
                                      GCBackground |
                                      GCPlaneMask ),
                                     &GraphicValue );

    GraalLargeTextGC = XCreateGC ( XtDisplay( GraalGraphicWindow ), 
                                   Root,
                                   ( GCForeground |
                                     GCBackground |
                                     GCPlaneMask ),
                                    &GraphicValue );

    XSetFont( XtDisplay( GraalGraphicWindow ),
              GraalSmallTextGC, GraalSmallTextFont->fid );

    XSetFont( XtDisplay( GraalGraphicWindow ),
              GraalMediumTextGC, GraalMediumTextFont->fid );

    XSetFont( XtDisplay( GraalGraphicWindow ),
              GraalLargeTextGC, GraalLargeTextFont->fid );

    GraphicValue.background = GraalColor[ 1 ];  /* White */
    GraphicValue.foreground = GraalColor[ 0 ];  /* Black */
    GraphicValue.function   = GXxor;

    GraalXorGC = XCreateGC ( XtDisplay( GraalGraphicWindow ), 
                             Root,
                             ( GCForeground |
                               GCBackground |
                               GCFunction   |
                               GCPlaneMask ),
                               &GraphicValue );

    GraphicValue.background = GraalColor[ 0 ];  /* Black */
    GraphicValue.foreground = GraalColor[ 1 ];  /* White */

    for ( Counter = 0; Counter < RDS_MAX_LAYER; Counter++ )
    {
      Pattern = GraalLayerPatternDefine[ Counter ];

      GraphicValue.stipple    = GraalPattern[ Pattern ];
      GraphicValue.fill_style = FillStippled;
      GraphicValue.foreground = GraalColor[ 3 ];

      GraalLayerAcceptGC[ Counter ] =

           XCreateGC ( XtDisplay( GraalGraphicWindow ),
                                  Root,
                                  ( GCStipple    |
                                    GCForeground |
                                    GCBackground |
                                    GCFillStyle  |
                                    GCPlaneMask  ),
                                  &GraphicValue  );

      GraphicValue.foreground = GraalColor[ 4 ];
 
      GraalLayerEquiGC[ Counter ] =

           XCreateGC ( XtDisplay( GraalGraphicWindow ),
                                  Root,
                                  ( GCStipple    |
                                    GCForeground |
                                    GCBackground |
                                    GCFillStyle  |
                                    GCPlaneMask  ),
                                  &GraphicValue  );

      GraphicValue.foreground = GraalColor[ 5 ];

      GraalLayerDrucGC[ Counter ] =

           XCreateGC ( XtDisplay( GraalGraphicWindow ),
                                  Root,
                                  ( GCStipple    |
                                    GCForeground |
                                    GCBackground |
                                    GCFillStyle  |
                                    GCPlaneMask  ),
                                  &GraphicValue  );

      GraphicValue.foreground = GraalColor[ Counter + 6 ];

      GraalLayerFillGC[ Counter ] = 

           XCreateGC ( XtDisplay( GraalGraphicWindow ), 
                                  Root,
                                  ( GCStipple    | 
                                    GCForeground |
                                    GCBackground |
                                    GCFillStyle  | 
                                    GCPlaneMask  ),
                                  &GraphicValue  );

      GraalLayerDrawGC[ Counter ] = 

           XCreateGC ( XtDisplay( GraalGraphicWindow ), 
                                  Root,
                                  ( GCForeground |
                                    GCBackground |
                                    GCPlaneMask  ),
                                  &GraphicValue  );

    }
  } 
