/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   View.h                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  25/02/93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# ifndef GRAAL_VIEW
# define GRAAL_VIEW

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# define GRAAL_PERCENT_ZOOM      30
# define GRAAL_PERCENT_ZOOM_MIN   5
# define GRAAL_PERCENT_ZOOM_MAX  95

# define GRAAL_PERCENT_MOVE      30
# define GRAAL_PERCENT_MOVE_MIN   5
# define GRAAL_PERCENT_MOVE_MAX  95

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/

  typedef struct graalzoom
   {
     struct graalzoom *NEXT;

     long              X;
     long              Y;
     long             DX;
     long             DY;

   } graalzoom;

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  extern int            GraalPercentZoom;
  extern int            GraalPercentMove;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern void GraalZoomUndo();
  extern void GraalZoomRefresh();

  extern void GraalZoomLeft();
  extern void GraalZoomRight();
  extern void GraalZoomUp();
  extern void GraalZoomDown();

  extern void GraalZoomMore();
  extern void GraalZoomLess();

  extern void GraalZoomFit();

# endif 
