/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Message.c                        |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>
 

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GMV_H
# include "GMV_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  static char MessageBuffer[ 512 ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       GraalPromptZoomIn                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptZoomIn()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Zoom In" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventZoom )
    {
      case 0 : 

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter second corner" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalPromptZoomPan                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptZoomPan()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Zoom Pan" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select line"  );

    switch ( GraalCountEventZoom )
    {
      case 0 : 

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter source point" );

      break;

      case 1 : 

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter target point" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalPromptZoomCenter                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptZoomCenter()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Zoom Center" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select point" );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter center point" );
  }

