/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Menu.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>

# include MPH_H
# include RDS_H
# include RPR_H
# include GSB_H
# include GTB_H
# include GRM_H
# include GMV_H
# include GMT_H
# include GMX_H

# include "GMT_menu.h" 
# include "GMT_tools.h" 
# include "GMT_message.h" 

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

   GraalMenuItem GraalToolsMenu[] =

         {
           {
             "Equi",
             'E',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackToolsEqui,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "UnEqui",
             'i',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackToolsUnEqui,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Flat",
             'F',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackToolsFlatInstance,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Unflat",
             't',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackToolsUnflatInstance,
             (XtPointer)NULL,
             (Widget)NULL,  
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Peek",
             'P',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackToolsPeek,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           } 
           ,
           {
             "Unpeek",
             'k',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackToolsUnpeek,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Druc",
             'D',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackToolsDruc,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Message",
             'M',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackToolsMessage,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           NULL
         };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     CallbackToolsEqui                       |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsEqui( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterPanel( &GraalToolsGlobalPanel );

    if ( GraalHeadEqui != (rdsrec_list *)NULL )
    {
      GraalDelEqui();
      GraalZoomRefresh();
    }

    GraalChangeEditMode( GRAAL_TOOLS_EQUI, 
                         GraalPromptToolsEqui );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsUnEqui                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsUnEqui( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GraalHeadEqui != (rdsrec_list *)NULL )
    {
      GraalDelEqui();
      GraalZoomRefresh();
    }

    GraalEnterPanel( &GraalToolsGlobalPanel );
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackToolsFlatInstance                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsFlatInstance( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterPanel( &GraalToolsGlobalPanel );

    GraalChangeEditMode( GRAAL_TOOLS_FLATTEN,
                         GraalPromptToolsFlatten );
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackToolsUnflatInstance                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsUnflatInstance( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterPanel( &GraalToolsGlobalPanel );

    GraalChangeEditMode( GRAAL_TOOLS_UNFLATTEN,
                         GraalPromptToolsUnflatten );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsPeek                        |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsPeek( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterPanel( &GraalToolsGlobalPanel );

    GraalChangeEditMode( GRAAL_TOOLS_PEEK,
                         GraalPromptToolsPeek );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsUnpeek                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsUnpeek( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterPanel( &GraalToolsGlobalPanel );

    GraalToolsUnpeek();
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsDruc                        |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsDruc( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterPanel( &GraalToolsGlobalPanel );

    GraalChangeEditMode( GRAAL_TOOLS_DRUC,
                         GraalPromptToolsDruc );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackToolsMessage                     |
|                                                             |
\------------------------------------------------------------*/

  void CallbackToolsMessage( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterPanel( &GraalToolsMessagePanel );
  }
