/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Druc.c                           |
|                                                             |
| Author  :              Jacomme Ludovic                      |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RFM_H
# include RPR_H
# include DRC_H
# include GTB_H
# include GSB_H
# include GMX_H
# include GRM_H
# include GMT_H
# include DRC_H

# include "GMT_druc.h"
# include "GMT_panel.h"
# include "GMT_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  char GraalDrucAbort;
  char GraalDrucErrorMessage[ GRAAL_DRUC_MESSAGE_SIZE ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      GraalToolsDrucError                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalDisplayDrucError( Rectangle )

    rdsrec_list *Rectangle;
  {
    char *Comment;
    long  Error;

    Error   = MACRO_REGLE_NUM( Rectangle );
    Comment = drucgeterror( Error );

    sprintf( GraalDrucErrorMessage, "Rule error %d\n%s", 
             Error, Comment );

    GraalDisplayDrucMessage( GraalDrucErrorMessage );
  }

/*------------------------------------------------------------\
|                                                             |
|                        GraalToolsDruc                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalToolsDruc( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

     long LambdaX1;
     long LambdaY1;
     long LambdaX2;
     long LambdaY2;
  {
    graalselect  *Select;
    graalselect  *DelSelect;
    graalselect **Previous;
    rdsfig_list  *FigureRds;
    rdsrec_list  *Rectangle;
    rdsrec_list  *DrucRec;
    void         *Pointer;
    char          Layer;
    char          Error;

    GraalEditSelectFence( LambdaX1, LambdaY1, LambdaX2, LambdaY2 );

    Previous = &GraalHeadSelect;
    Select   = GraalHeadSelect;

    while ( Select != (graalselect *)NULL )
    {
      if ( IsRdsFigure( Select->RECTANGLE   ) ||
           IsRdsInstance( Select->RECTANGLE ) )
      {
        DelSelect = Select;
        Select    = Select->NEXT;
        *Previous = Select;
 
        GraalFreeSelect( DelSelect );
      }
      else
      {
        GraalAcceptRectangle( Select->RECTANGLE );
 
        Previous = &Select->NEXT;
        Select   = Select->NEXT;
      }
    }
 
    if ( GraalHeadSelect == (graalselect *)NULL  )
    {
      GraalWarningMessage( GraalMainWindow, "No element found !" );
    }
    else
    {
      FigureRds = addrdsfig( "_patrick_", MACRO_PLUS_TAILLE );

      for ( Select  = GraalHeadSelect;
            Select != (graalselect *)NULL;
            Select  = Select->NEXT )
      {
        Rectangle = Select->RECTANGLE;
        Pointer   = GRAAL_MBK( Rectangle );

        if ( IsRdsSegment( Rectangle ) )
        {
          segmbkrds( FigureRds, (phseg_list *)Pointer, 0 );
        }
        else
        if ( IsRdsConnector( Rectangle ) )
        {
          conmbkrds( FigureRds, (phcon_list *)Pointer );
        }
        else
        if ( IsRdsReference( Rectangle ) )
        {
          refmbkrds( FigureRds, (phref_list *)Pointer );
        }
        else
        if ( IsRdsVia( Rectangle ) )
        {
          viambkrds( FigureRds, (phvia_list *)Pointer );
        }
      }

      GraalDelSelect();

      if ( ( GraalHeadEqui != (rdsrec_list *)NULL ) ||
           ( GraalHeadPeek != (graalpeek   *)NULL ) )
      {
        GraalDelEqui();
        GraalDelPeek();
        GraalZoomRefresh();
      }

      FigureRds = Graaldrucrdsfig( FigureRds );

      GraalDisplayToolsMessage();

      if ( FigureRds == (rdsfig_list *)NULL )
      {
        GraalErrorMessage( GraalMainWindow, "Unable to execute druc !" );
      }
      else
      {
        Error = GRAAL_FALSE;

        for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
        {
          for ( Rectangle  = FigureRds->LAYERTAB[ Layer ];
                Rectangle != (rdsrec_list *)NULL;    
                Rectangle  = Rectangle->NEXT )
          {
            ClearGraalDruc( Rectangle ); Error = GRAAL_TRUE;
          }
        }

        if ( Error == GRAAL_FALSE )
        {
          GraalWarningMessage( GraalMainWindow, "No design error !" );
        }
        else
        {
          for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
          {
            for ( Rectangle  = FigureRds->LAYERTAB[ Layer ];
                  Rectangle != (rdsrec_list *)NULL;    
                  Rectangle  = Rectangle->NEXT )
            {
              DrucRec = GraalAddDruc( Rectangle );

              if ( DrucRec != (rdsrec_list *)NULL )
              {
                GraalDisplayDrucError( Rectangle );
                GraalDisplayRectangle( DrucRec );
                GraalDeleteRectangle( DrucRec );

                GraalDrucAbort = GRAAL_FALSE;

                GraalEnterPanel( &GraalToolsDrucPanel );
                GraalLimitedLoop( GraalToolsDrucPanel.PANEL );

                GraalDisplayRectangle( DrucRec );
                GraalDelDruc( DrucRec );

                if ( GraalDrucAbort ) break;
              }
            }
          }
        }

        XtUnmanageChild( GraalToolsDrucPanel.PANEL );

        delrdsfig( FigureRds->NAME );
      }
    }
  }
