/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Setup.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include GTB_H
# include GSB_H
# include GMX_H
# include GMF_H
# include GME_H
# include GMC_H
# include GMV_H
# include GMT_H
# include GMS_H

# include "GMS_setup.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
  
  static FILE *FileConfig;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      Set Panel New Values                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalSetPanelValues( Panel, Values )

    GraalPanelItem *Panel;
    int            *Values;
  {
    Panel->COMPUTE = 1;
    Panel->X       = Values[0];
    Panel->Y       = Values[1];
    Panel->WIDTH   = Values[2];
    Panel->HEIGHT  = Values[3];

    XtVaSetValues( Panel->PANEL,
                   XmNx        , Values[0],
                   XmNy        , Values[1],
                   XmNwidth    , Values[2],
                   XmNheight   , Values[3],
                   NULL );
  }

/*------------------------------------------------------------\
|                                                             |
|                      Write TopLevel Values                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalWriteTopLevelValues()

  {
    Dimension Values[4];

    XtVaGetValues( GraalTopLevel,
                   XmNx        , &Values[0],
                   XmNy        , &Values[1],
                   XmNwidth    , &Values[2],
                   XmNheight   , &Values[3],
                   NULL );

    Values[0] = Values[0] - GRAAL_TOPLEVEL_TRANSLATE_X;
    Values[1] = Values[1] - GRAAL_TOPLEVEL_TRANSLATE_Y;
    
    fprintf( FileConfig, "X: %d, Y: %d, WIDTH: %d, HEIGHT: %d\n",
             Values[0], Values[1], Values[2], Values[3] );
  }

/*------------------------------------------------------------\
|                                                             |
|                       Write Panel Values                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalWritePanelValues( Panel )

    GraalPanelItem *Panel;
  {
    Dimension Values[4];

    if ( Panel->COMPUTE == 0 )
    {
      XtVaGetValues( Panel->PANEL,
                     XmNx        , &Values[0],
                     XmNy        , &Values[1],
                     XmNwidth    , &Values[2],
                     XmNheight   , &Values[3],
                     NULL );

      Values[0] = Values[0] - GRAAL_PANEL_TRANSLATE_X;
      Values[1] = Values[1] - GRAAL_PANEL_TRANSLATE_Y;
    }
    else
    {
      Values[0] = Panel->X;
      Values[1] = Panel->Y;
      Values[2] = Panel->WIDTH;
      Values[3] = Panel->HEIGHT;
    }

    fprintf( FileConfig, "X: %d, Y: %d, WIDTH: %d, HEIGHT: %d\n",
             Values[0], Values[1], Values[2], Values[3] );
  }

/*------------------------------------------------------------\
|                                                             |
|                        Read Panel Values                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalReadPanelValues( Panel )

    GraalPanelItem *Panel;
  {
    int Values[4];

    fscanf( FileConfig, "X: %d, Y: %d, WIDTH: %d, HEIGHT: %d\n",
            &Values[0], &Values[1], &Values[2], &Values[3] );

    GraalSetPanelValues( Panel, Values );
  }

/*------------------------------------------------------------\
|                                                             |
|                       Read  Panel Values                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalReadTopLevelValues()
  {
    int Values[4];

    fscanf( FileConfig, "X: %d, Y: %d, WIDTH: %d, HEIGHT: %d\n",
            &Values[0], &Values[1], &Values[2], &Values[3] );

    XtVaSetValues( GraalTopLevel,
                   XmNx        , Values[0],
                   XmNy        , Values[1],
                   XmNwidth    , Values[2],
                   XmNheight   , Values[3],
                   NULL );
  }

/*------------------------------------------------------------\
|                                                             |
|                         ReadActiveLayers                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalReadActiveLayers()

  {
    char Layer;
    int  Value;

    for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
    {
      fscanf( FileConfig, "ACTIVE: %d\n", &Value );

      GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] = Value;
    }

    for ( Layer = 0; Layer < GRAAL_MAX_ACTIVE_NAME; Layer++ )
    {
      fscanf( FileConfig, "ACTIVE: %d\n", &Value );

      GRAAL_RDS_ACTIVE_NAME_TABLE[ Layer ] = Value;
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                        WriteActiveLayers                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalWriteActiveLayers()

  {
    char Layer;
    int  Value;

    for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
    {
      fprintf( FileConfig, "ACTIVE: %d\n", 
               GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] );
    }

    for ( Layer = 0; Layer < GRAAL_MAX_ACTIVE_NAME; Layer++ )
    {
      fprintf( FileConfig, "ACTIVE: %d\n", 
               GRAAL_RDS_ACTIVE_NAME_TABLE[ Layer ] );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                        GraalDefaultConfig                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalDefaultConfig()

  {
    char      Layer;

    XtVaSetValues( GraalTopLevel,
                   XmNheight   , GRAAL_TOPLEVEL_HEIGHT,
                   XmNwidth    , GRAAL_TOPLEVEL_WIDTH,
                   XmNx        , GRAAL_TOPLEVEL_X,
                   XmNy        , GRAAL_TOPLEVEL_Y,
                   NULL
                 );

    GraalSetPanelValues( &GraalViewArrowsPanel, 
                          GraalViewArrowsDefaultValues );
    GraalSetPanelValues( &GraalViewZoomPanel, 
                          GraalViewZoomDefaultValues );
    GraalSetPanelValues( &GraalViewLayerPanel, 
                          GraalViewLayerDefaultValues );
    GraalSetPanelValues( &GraalViewGridPanel, 
                          GraalViewGridDefaultValues );
    GraalSetPanelValues( &GraalViewMapPanel, 
                          GraalViewMapDefaultValues );
    GraalSetPanelValues( &GraalEditGlobalPanel, 
                          GraalEditGlobalDefaultValues );
    GraalSetPanelValues( &GraalWindowGlobalPanel, 
                          GraalWindowGlobalDefaultValues );
    GraalSetPanelValues( &GraalEditSelectPanel, 
                          GraalEditSelectDefaultValues );
    GraalSetPanelValues( &GraalEditIdentifyPanel, 
                          GraalEditIdentifyDefaultValues );
    GraalSetPanelValues( &GraalEditSearchPanel, 
                          GraalEditSearchDefaultValues );
    GraalSetPanelValues( &GraalEditSearchViewPanel, 
                          GraalEditSearchViewDefaultValues );
    GraalSetPanelValues( &GraalModifySegmentPanel,
                          GraalModifySegmentDefaultValues );
    GraalSetPanelValues( &GraalModifyViaPanel,
                          GraalModifyViaDefaultValues );
    GraalSetPanelValues( &GraalModifyTransistorPanel,
                          GraalModifyTransistorDefaultValues );
    GraalSetPanelValues( &GraalModifyConnectorPanel,
                          GraalModifyConnectorDefaultValues );
    GraalSetPanelValues( &GraalModifyReferencePanel,
                          GraalModifyReferenceDefaultValues );
    GraalSetPanelValues( &GraalModifyInstancePanel,
                          GraalModifyInstanceDefaultValues );
    GraalSetPanelValues( &GraalCreateSegmentPanel,
                          GraalCreateSegmentDefaultValues );
    GraalSetPanelValues( &GraalCreateViaPanel,
                          GraalCreateViaDefaultValues );
    GraalSetPanelValues( &GraalCreateTransistorPanel,
                          GraalCreateTransistorDefaultValues );
    GraalSetPanelValues( &GraalCreateConnectorPanel,
                          GraalCreateConnectorDefaultValues );
    GraalSetPanelValues( &GraalCreateReferencePanel,
                          GraalCreateReferenceDefaultValues );
    GraalSetPanelValues( &GraalCreateInstancePanel,
                          GraalCreateInstanceDefaultValues );
    GraalSetPanelValues( &GraalToolsGlobalPanel,
                          GraalToolsGlobalDefaultValues );
    GraalSetPanelValues( &GraalToolsMessagePanel,
                          GraalToolsMessageDefaultValues );
    GraalSetPanelValues( &GraalToolsDrucPanel,
                          GraalToolsDrucDefaultValues );

    for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
    {
      GRAAL_RDS_ACTIVE_LAYER_TABLE[ Layer ] = 1;
    }

    for ( Layer = 0; Layer < GRAAL_MAX_ACTIVE_NAME; Layer++ )
    {
      GRAAL_RDS_ACTIVE_NAME_TABLE[ Layer ] = 1;
    }

    GraalEnterPanel( &GraalViewArrowsPanel );
    GraalEnterPanel( &GraalViewZoomPanel   );

    XtUnmanageChild( GraalViewMapPanel.PANEL   );
    XtUnmanageChild( GraalViewLayerPanel.PANEL );

    GraalFirstViewLayer = 1;
  }

/*------------------------------------------------------------\
|                                                             |
|                          GraalLoadConfig                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalLoadConfig( Message )

    char Message;
  {
    FileConfig = fopen( GMS_FILE_NAME, "r" );

    if ( FileConfig == (FILE *)NULL )
    {
      if ( Message )
      {
        GraalErrorMessage( GraalMainWindow, 
                           "Unable to open config file !" );
      }
      else
      {
        GraalDefaultConfig();
      }
    }
    else
    {
      GraalReadTopLevelValues();

      GraalReadPanelValues( &GraalViewArrowsPanel       );
      GraalReadPanelValues( &GraalViewZoomPanel         );
      GraalReadPanelValues( &GraalViewLayerPanel        );
      GraalReadPanelValues( &GraalViewGridPanel         );
      GraalReadPanelValues( &GraalViewMapPanel          );
      GraalReadPanelValues( &GraalEditGlobalPanel       );
      GraalReadPanelValues( &GraalWindowGlobalPanel     );
      GraalReadPanelValues( &GraalEditSelectPanel       );
      GraalReadPanelValues( &GraalEditIdentifyPanel     );
      GraalReadPanelValues( &GraalEditSearchPanel       );
      GraalReadPanelValues( &GraalEditSearchViewPanel   );
      GraalReadPanelValues( &GraalModifySegmentPanel    );
      GraalReadPanelValues( &GraalModifyViaPanel        );
      GraalReadPanelValues( &GraalModifyTransistorPanel );
      GraalReadPanelValues( &GraalModifyConnectorPanel  );
      GraalReadPanelValues( &GraalModifyReferencePanel  );
      GraalReadPanelValues( &GraalModifyInstancePanel   );
      GraalReadPanelValues( &GraalCreateSegmentPanel    );
      GraalReadPanelValues( &GraalCreateViaPanel        );
      GraalReadPanelValues( &GraalCreateTransistorPanel );
      GraalReadPanelValues( &GraalCreateConnectorPanel  );
      GraalReadPanelValues( &GraalCreateReferencePanel  );
      GraalReadPanelValues( &GraalCreateInstancePanel   );
      GraalReadPanelValues( &GraalToolsGlobalPanel      );
      GraalReadPanelValues( &GraalToolsMessagePanel     );
      GraalReadPanelValues( &GraalToolsDrucPanel        );

      GraalReadActiveLayers();

      fclose( FileConfig );

      GraalEnterPanel( &GraalViewArrowsPanel );
      GraalEnterPanel( &GraalViewZoomPanel   );

      XtUnmanageChild( GraalViewMapPanel.PANEL   );
      XtUnmanageChild( GraalViewLayerPanel.PANEL );

      GraalFirstViewLayer = 1;
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                          GraalSaveConfig                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalSaveConfig()

  {
    FileConfig = fopen( GMS_FILE_NAME, "w" );

    if ( FileConfig == (FILE *)NULL )
    {
      GraalErrorMessage( GraalMainWindow,
                         "Unable to open config file !" );
    }
    else
    {
      GraalWriteTopLevelValues();

      GraalWritePanelValues( &GraalViewArrowsPanel       );
      GraalWritePanelValues( &GraalViewZoomPanel         );
      GraalWritePanelValues( &GraalViewLayerPanel        );
      GraalWritePanelValues( &GraalViewGridPanel         );
      GraalWritePanelValues( &GraalViewMapPanel          );
      GraalWritePanelValues( &GraalEditGlobalPanel       );
      GraalWritePanelValues( &GraalWindowGlobalPanel     );
      GraalWritePanelValues( &GraalEditSelectPanel       );
      GraalWritePanelValues( &GraalEditIdentifyPanel     );
      GraalWritePanelValues( &GraalEditSearchPanel       );
      GraalWritePanelValues( &GraalEditSearchViewPanel   );
      GraalWritePanelValues( &GraalModifySegmentPanel    );
      GraalWritePanelValues( &GraalModifyViaPanel        );
      GraalWritePanelValues( &GraalModifyTransistorPanel );
      GraalWritePanelValues( &GraalModifyConnectorPanel  );
      GraalWritePanelValues( &GraalModifyReferencePanel  );
      GraalWritePanelValues( &GraalModifyInstancePanel   );
      GraalWritePanelValues( &GraalCreateSegmentPanel    );
      GraalWritePanelValues( &GraalCreateViaPanel        );
      GraalWritePanelValues( &GraalCreateTransistorPanel );
      GraalWritePanelValues( &GraalCreateConnectorPanel  );
      GraalWritePanelValues( &GraalCreateReferencePanel  );
      GraalWritePanelValues( &GraalCreateInstancePanel   );
      GraalWritePanelValues( &GraalToolsGlobalPanel      );
      GraalWritePanelValues( &GraalToolsMessagePanel     );
      GraalWritePanelValues( &GraalToolsDrucPanel        );

      GraalWriteActiveLayers();

      fclose( FileConfig );
    }
  }
