/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Menu.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>

# include MPH_H
# include RDS_H
# include RPR_H
# include GSB_H
# include GTB_H
# include GRM_H
# include GMV_H
# include GME_H
# include GMX_H

# include "GME_menu.h" 
# include "GME_edit.h" 
# include "GME_modify.h" 
# include "GME_message.h" 

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

   GraalMenuItem GraalEditMenu[] =

         {
           {
             "Undo", 
             'U',   
             "Ctrl<Key>U", 
             "Ctrl U",  
             &xmPushButtonGadgetClass, 
             False, 
             False, 
             False, 
             CallbackEditUndo, 
             (XtPointer)NULL, 
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           } 
           , 
           {
             "Copy",
             'C',
             "Ctrl<Key>C",
             "Ctrl C",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditCopy,
             (XtPointer)0,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Move",
             'M',
             "Ctrl<Key>M",
             "Ctrl M",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditMove,
             (XtPointer)0,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Delete",
             'D',
             "Ctrl<Key>D",
             "Ctrl D",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditDelete,
             (XtPointer)0,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Stretch", 
             'S',  
             "Ctrl<Key>S",
             "Ctrl S", 
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditStretch,
             (XtPointer)0,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Modify           ",
             'y',
             "Ctrl<Key>Y",
             "Ctrl Y",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditModify,
             (XtPointer)0,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Identify",
             'I',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditIdentify,
             (XtPointer)0,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Search           ", 
             'h',   
             "Ctrl<Key>H", 
             "Ctrl H",  
             &xmPushButtonGadgetClass,
             False, 
             False, 
             False, 
             CallbackEditSearch,
             (XtPointer)0,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           } 
           , 
           NULL
         };

   GraalMenuItem GraalWindowMenu[] =

         {
           {
             "Undo", 
             'U',   
             "Meta<Key>U", 
             "Meta U",  
             &xmPushButtonGadgetClass, 
             False, 
             False, 
             False, 
             CallbackEditUndo, 
             (XtPointer)1, 
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           } 
           , 
           {
             "Copy",
             'C',
             "Meta<Key>C",
             "Meta C",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditCopy,
             (XtPointer)1,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Move",
             'M',
             "Meta<Key>M",
             "Meta M",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditMove,
             (XtPointer)1,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Delete",
             'D',
             "Meta<Key>D",
             "Meta D",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditDelete,
             (XtPointer)1,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Modify           ",
             'y',
             "Meta<Key>Y",
             "Meta Y",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditModify,
             (XtPointer)1,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Identify          ",
             'I',
             "Meta<Key>I",
             "Meta I",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackEditIdentify,
             (XtPointer)1,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           NULL
        };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     CallbackEditIdentify                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditIdentify( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalEnterPanel( &GraalWindowGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_WINDOW_IDENTIFY,
                           GraalPromptSelectWindowIdentify );
    }
    else
    {
      GraalEnterPanel( &GraalEditGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_POINT_IDENTIFY,
                           GraalPromptSelectPointIdentify );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackEditCopy                        |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditCopy( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalEnterPanel( &GraalWindowGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_WINDOW_COPY,
                           GraalPromptSelectWindowCopy );
    }
    else
    {
      GraalEnterPanel( &GraalEditGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_POINT_COPY,
                           GraalPromptSelectPointCopy );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackEditMove                        |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditMove( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalEnterPanel( &GraalWindowGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_WINDOW_MOVE,
                           GraalPromptSelectWindowMove );
    }
    else
    {
      GraalEnterPanel( &GraalEditGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_POINT_MOVE,
                           GraalPromptSelectPointMove );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackEditDelete                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditDelete( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalEnterPanel( &GraalWindowGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_WINDOW_DELETE,
                           GraalPromptSelectWindowDelete );
    }
    else
    {
      GraalEnterPanel( &GraalEditGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_POINT_DELETE,
                           GraalPromptSelectPointDelete );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackEditStretch                       |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditStretch( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterPanel( &GraalEditGlobalPanel );

    GraalChangeEditMode( GRAAL_SELECT_POINT_STRETCH,
                         GraalPromptSelectPointStretch );
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackEditModify                        |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditModify( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalEnterPanel( &GraalWindowGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_WINDOW_MODIFY,
                           GraalPromptSelectWindowModify );
    }
    else
    {
      GraalEnterPanel( &GraalEditGlobalPanel );

      GraalChangeEditMode( GRAAL_SELECT_POINT_MODIFY,
                           GraalPromptSelectPointModify );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackEditSearch                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditSearch( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterPanel( &GraalEditSearchPanel );
  }

/*------------------------------------------------------------\
|                                                             |
|                       CallbackEditUndo                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditUndo( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEditUndo();

    if ( ClientData )
    {
      GraalEnterPanel( &GraalWindowGlobalPanel );
    }
    else
    {
      GraalEnterPanel( &GraalEditGlobalPanel );
    }
  }
