/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Menu.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>
 
# include MPH_H
# include RDS_H
# include RPR_H
# include GTB_H
# include GSB_H
# include GRM_H
# include GMX_H
# include GMC_H

# include "GMC_menu.h"
# include "GMC_create.h"
# include "GMC_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

   GraalMenuItem GraalCreateMenu[] =

         {
           {
             "Instance",
             'I',
             "Ctrl<Key>I",
             "Ctrl I",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackCreateInstance,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Abutment Box",
             'A',
             "Ctrl<Key>A",
             "Ctrl A",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackCreateAbutmentBox,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Segment",
             'S',
             "Ctrl<Key>E",
             "Ctrl E",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackCreateSegment,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Via",
             'V',
             "Ctrl<Key>V",
             "Ctrl V",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackCreateVia,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Connector     ",
             'o',
             "Ctrl<Key>N",
             "Ctrl N",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackCreateConnector,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Transistor       ",
             'T',
             "Ctrl<Key>T",
             "Ctrl T",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackCreateTransistor,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Reference       ",
             'R',
             "Ctrl<Key>R",
             "Ctrl R",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackCreateReference,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL,
           }
           ,
           NULL
        };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackCreateSegment                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCreateSegment( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GraalSegmentWidth == -1 )
    {
      GraalSegmentWidth = GRAAL_SEGMENT_VALUE_TABLE[ GraalSegmentLayer ][0];
    }

    if ( GraalSegmentWire == GRAAL_FALSE )
    {
      GraalChangeEditMode( GRAAL_CREATE_SEGMENT,
                           GraalPromptCreateSegment );
    } 
    else
    {
      GraalChangeEditMode( GRAAL_CREATE_SEGMENT_WIRE,
                           GraalPromptCreateSegment );
    }

    GraalEnterPanel( &GraalCreateSegmentPanel );
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackCreateReference                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCreateReference( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_CREATE_REFERENCE,
                         GraalPromptCreateReference );

    GraalEnterPanel( &GraalCreateReferencePanel );
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackCreateVia                         |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCreateVia( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_CREATE_VIA,
                         GraalPromptCreateVia );

    GraalEnterPanel( &GraalCreateViaPanel );
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackCreateInstance                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCreateInstance( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_CREATE_INSTANCE,
                         GraalPromptCreateInstance );

    GraalEnterPanel( &GraalCreateInstancePanel );
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackCreateConnector                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCreateConnector( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ( GraalFigureMbk == (phfig_list *)NULL ) || 
         ( ( GraalFigureMbk->XAB1 == 0 ) &&     
           ( GraalFigureMbk->XAB2 == 0 ) &&     
           ( GraalFigureMbk->YAB1 == 0 ) &&     
           ( GraalFigureMbk->YAB2 == 0 ) ) )
    {
      GraalErrorMessage( GraalMainWindow, "No abutment box, can't create connector !" );
    }
    else
    {
      if ( GraalConnectorWidth == -1 )
      {
        GraalConnectorWidth = GRAAL_SEGMENT_VALUE_TABLE[ GraalConnectorLayer ][0];
      }

      GraalChangeEditMode( GRAAL_CREATE_CONNECTOR,
                           GraalPromptCreateConnector );

      GraalEnterPanel( &GraalCreateConnectorPanel );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackCreateTransistor                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCreateTransistor( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GraalTransistorLength == -1 )
    {
      GraalTransistorLength = GRAAL_SEGMENT_VALUE_TABLE[ GraalTransistorType ][0];
    }

    GraalChangeEditMode( GRAAL_CREATE_TRANSISTOR,
                         GraalPromptCreateTransistor );
 
    GraalEnterPanel ( &GraalCreateTransistorPanel );
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackCreateAbutmentBox                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackCreateAbutmentBox( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ( GraalFigureMbk != (phfig_list *)NULL ) &&
         ( ( GraalFigureMbk->XAB1 != 0 ) ||
           ( GraalFigureMbk->XAB2 != 0 ) ||
           ( GraalFigureMbk->YAB1 != 0 ) ||
           ( GraalFigureMbk->YAB2 != 0 ) ) )
    {
      GraalErrorMessage( GraalMainWindow, "There is already one abutment box !");
    }
    else
    {
      GraalChangeEditMode( GRAAL_CREATE_ABUTMENTBOX,
                           GraalPromptCreateAbutmentBox );
    }
  }
