/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                 Dialog.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GMC_H

# include "GMC_dialog.h"
# include "GMC_create.h"
# include "GMC_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  char GraalCreateDialogCancel = 1;

/*------------------------------------------------------------\
|                                                             |
|                        Create Dialog                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Segment Dialog                      |
|                                                             |
\------------------------------------------------------------*/
 
  GraalDialogItem GraalChangeSegmentWidthDialog =

  {
    "Segment width",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackChangeSegmentWidthOk,
    (XtPointer)NULL,
    (void *)CallbackChangeSegmentWidthCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalChangeSegmentNameDialog =

  {
    "Segment name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackChangeSegmentNameOk,
    (XtPointer)NULL,
    (void *)CallbackChangeSegmentNameCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                       Transistor Dialog                     |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalChangeTransistorLengthDialog =

  {
    "Transistor length",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackChangeTransistorLengthOk,
    (XtPointer)NULL,
    (void *)CallbackChangeTransistorLengthCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                        Connector Dialog                     |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalChangeConnectorWidthDialog =

  {
    "Connector width",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackChangeConnectorWidthOk,
    (XtPointer)NULL,
    (void *)CallbackChangeConnectorWidthCancel,
    (XtPointer)NULL
  };
    
  GraalDialogItem GraalChangeConnectorNameDialog =
 
  {
    "Connector name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackChangeConnectorNameOk,
    (XtPointer)NULL,
    (void *)CallbackChangeConnectorNameCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                        Reference Dialog                     |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalChangeReferenceNameDialog =

  {
    "Reference name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackChangeReferenceNameOk,
    (XtPointer)NULL,
    (void *)CallbackChangeReferenceNameCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                         Instance Dialog                     |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalChangeInstanceNameDialog =

  {
    "Instance name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackChangeInstanceNameOk,
    (XtPointer)NULL,
    (void *)CallbackChangeInstanceNameCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalChangeInstanceModelDialog =

  {
    "Instance model name",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackChangeInstanceModelOk,
    (XtPointer)NULL,
    (void *)CallbackChangeInstanceModelCancel,
    (XtPointer)NULL
  };
   
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    GraalBuildCreateDialog                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalBuildCreateDialog()

  {
    GraalBuildDialog( GraalMainWindow, &GraalChangeSegmentWidthDialog     );
    GraalBuildDialog( GraalMainWindow, &GraalChangeSegmentNameDialog      );
    GraalBuildDialog( GraalMainWindow, &GraalChangeTransistorLengthDialog );
    GraalBuildDialog( GraalMainWindow, &GraalChangeConnectorWidthDialog   );
    GraalBuildDialog( GraalMainWindow, &GraalChangeConnectorNameDialog    );
    GraalBuildDialog( GraalMainWindow, &GraalChangeReferenceNameDialog    );
    GraalBuildDialog( GraalMainWindow, &GraalChangeInstanceNameDialog     );
    GraalBuildDialog( GraalMainWindow, &GraalChangeInstanceModelDialog    );
  }

/*------------------------------------------------------------\
|                                                             |
|                      Callback For Dialog                    |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                  CallbackChangeSegmentWidthOk               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeSegmentWidthOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *WidthSet;
    long  NewWidth;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &WidthSet );

    XtUnmanageChild( GraalChangeSegmentWidthDialog.WIDGET );

    GraalExitDialog();

    GraalCreateDialogCancel = 0;

    if ( WidthSet != (char *)NULL )
    {
      NewWidth = atoi( WidthSet );

      if ( NewWidth >=  GRAAL_SEGMENT_VALUE_TABLE[ GraalSegmentLayer ][0] )    
      {
        GraalSegmentWidth = NewWidth;
      }
      else
      {  
        GraalErrorMessage( GraalMainWindow, "Incorrect segment width !" );
      }

      if ( GraalSegmentWire == GRAAL_FALSE )
      {
        GraalChangeEditMode( GRAAL_CREATE_SEGMENT, 
                             GraalPromptCreateSegment );
      }
      else
      {   
        GraalChangeEditMode( GRAAL_CREATE_SEGMENT_WIRE,
                             GraalPromptCreateSegment );
      }
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeSegmentWidthCancel             |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeSegmentWidthCancel( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalChangeSegmentWidthDialog.WIDGET );
 
    GraalExitDialog();

    GraalCreateDialogCancel = 1;
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackChangeSegmentNameOk               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeSegmentNameOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );

    XtUnmanageChild( GraalChangeSegmentNameDialog.WIDGET );

    GraalExitDialog();

    GraalCreateDialogCancel = 0;

    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL )
    {
      NameSet = namealloc( NameSet );
    }

    GraalSegmentName = NameSet;

    if ( GraalSegmentWire == GRAAL_FALSE ) 
    { 
      GraalChangeEditMode( GRAAL_CREATE_SEGMENT,
                           GraalPromptCreateSegment ); 
    }  
    else 
    {    
      GraalChangeEditMode( GRAAL_CREATE_SEGMENT_WIRE,
                           GraalPromptCreateSegment );
    }  
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackChangeSegmentNameCancel             |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeSegmentNameCancel( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalChangeSegmentNameDialog.WIDGET );
 
    GraalExitDialog();

    GraalCreateDialogCancel = 1;
  }

/*------------------------------------------------------------\
|                                                             |
|                    Callback For Transistor                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                 CallbackChangeTransistorLengthOk            |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeTransistorLengthOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *LengthSet;
    long  NewLength;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &LengthSet );

    XtUnmanageChild( GraalChangeTransistorLengthDialog.WIDGET );

    GraalExitDialog();

    GraalCreateDialogCancel = 0;

    if ( LengthSet != (char *)NULL )
    {
      NewLength = atoi( LengthSet );

      if ( NewLength >=  GRAAL_SEGMENT_VALUE_TABLE[ GraalTransistorType ][0] )
      {
        GraalTransistorLength = NewLength;
      }
      else
      {   
        GraalErrorMessage( GraalMainWindow, "Incorrect transistor length !" );
      }

      GraalChangeEditMode( GRAAL_CREATE_TRANSISTOR,
                           GraalPromptCreateTransistor );
    }
  }  

/*------------------------------------------------------------\
|                                                             |
|               CallbackChangeTransistorLengthCancel          |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeTransistorLengthCancel( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalChangeTransistorLengthDialog.WIDGET );

    GraalExitDialog();

    GraalCreateDialogCancel = 1;
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Connector                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                 CallbackChangeConnectorWidthOk              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeConnectorWidthOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *WidthSet;
    long  NewWidth;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &WidthSet );
 
    XtUnmanageChild( GraalChangeConnectorWidthDialog.WIDGET );
 
    GraalExitDialog();

    GraalCreateDialogCancel = 0;
 
    if ( WidthSet != (char *)NULL )
    {
      NewWidth = atoi( WidthSet );

      if ( NewWidth >=  GRAAL_SEGMENT_VALUE_TABLE[ GraalConnectorLayer ][0] )
      {
        GraalConnectorWidth = NewWidth;
      }
      else
      {   
        GraalErrorMessage( GraalMainWindow, "Incorrect connector width !" );
      }
 
      GraalChangeEditMode( GRAAL_CREATE_CONNECTOR,
                           GraalPromptCreateConnector );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|               CallbackChangeConnectorWidthCancel            |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeConnectorWidthCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalChangeConnectorWidthDialog.WIDGET );

    GraalExitDialog();

    GraalCreateDialogCancel = 1;
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackChangeConnectorNameOk              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeConnectorNameOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalChangeConnectorNameDialog.WIDGET );
 
    GraalExitDialog();

    GraalCreateDialogCancel = 0;

    NameSet = GraalPostTreatString( NameSet );
 
    if ( NameSet != (char *)NULL )
    {
      NameSet = namealloc( NameSet );
    }

    GraalConnectorName = NameSet;

    GraalChangeEditMode( GRAAL_CREATE_CONNECTOR,
                         GraalPromptCreateConnector );
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeConnectorNameCancel            |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeConnectorNameCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalChangeConnectorNameDialog.WIDGET );

    GraalExitDialog();

    GraalCreateDialogCancel = 1;
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Reference                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                  CallbackChangeReferenceNameOk              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeReferenceNameOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalChangeReferenceNameDialog.WIDGET );
 
    GraalExitDialog();
 
    GraalCreateDialogCancel = 0;

    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL ) 
    {
      NameSet = namealloc( NameSet );
    }

    GraalReferenceName = NameSet;

    GraalChangeEditMode( GRAAL_CREATE_REFERENCE,
                         GraalPromptCreateReference );
  }

/*------------------------------------------------------------\
|                                                             |
|                CallbackChangeReferenceNameCancel            |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeReferenceNameCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalChangeReferenceNameDialog.WIDGET );

    GraalExitDialog();

    GraalCreateDialogCancel = 1;
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Instance                   |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                   CallbackChangeInstanceNameOk              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeInstanceNameOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *NameSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &NameSet );
 
    XtUnmanageChild( GraalChangeInstanceNameDialog.WIDGET );
 
    GraalExitDialog();

    GraalCreateDialogCancel = 0;
 
    NameSet = GraalPostTreatString( NameSet );

    if ( NameSet != (char *)NULL )
    {
      NameSet = namealloc( NameSet );

      GraalInstanceName = NameSet;
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackChangeInstanceNameCancel            |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeInstanceNameCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalChangeInstanceNameDialog.WIDGET );

    GraalExitDialog();

    GraalCreateDialogCancel = 1;
  }

/*------------------------------------------------------------\
|                                                             |
|                   CallbackChangeInstanceModelOk             |
|                                                             |
\------------------------------------------------------------*/

  void CallbackChangeInstanceModelOk( MyWidget, ClientData, CallData )
 
      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *ModelSet;
 
    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &ModelSet );
 
    XtUnmanageChild( GraalChangeInstanceModelDialog.WIDGET );
 
    GraalExitDialog();

    GraalCreateDialogCancel = 0;

    ModelSet = GraalPostTreatString( ModelSet );
 
    if ( ModelSet != (char *)NULL )
    {
      ModelSet = namealloc( ModelSet );
    }

    GraalInstanceModel = ModelSet;

    GraalChangeEditMode( GRAAL_CREATE_INSTANCE,
                         GraalPromptCreateInstance );
  }

/*------------------------------------------------------------\
|                                                             |
|                 CallbackChangeInstanceModelCancel           |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackChangeInstanceModelCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalChangeInstanceModelDialog.WIDGET );

    GraalExitDialog();

    GraalCreateDialogCancel = 1;
  }
