#include MUT_H
#include MPH_H
extern long xscreen, yscreen, dxscreen, dyscreen;
extern float scale;

/* quite subtle :
   this must be a mutiple of the pixmap size for proper X11r4 displaying!
   if the beginning of a rectangle is not on a X11 ``grid step'',
   small garbage appears on the screen. */
#define OVERSIZE (long)(32)
/*
* returns 0 for no display
*/
int clip_to_window(x, y, dx, dy, xscreen, yscreen, dxscreen, dyscreen)
long *x, *y, *dx, *dy;
long xscreen, yscreen, dxscreen, dyscreen;
{
long x1, y1, x2, y2, xs1, ys1, xs2, ys2; /* cartesian coordinates */

	x1 = *x;
	y2 = *y;
	x2 = x1 + *dx;
	y1 = y2 - *dy;
	xs1 = xscreen;
	ys1 = yscreen;
	xs2 = xscreen + dxscreen;
	ys2 = yscreen + dyscreen;

	/* not points inside the window */
	if ((xs1 > x2) || (x1 > xs2) || (ys1 > y2) || (y1 > ys2))
		return 0;
	/* if it at least one point belongs to the window, let's troncate */
	if ((x1 >= xs1 && x1 <= xs2 && y1 >= ys1 && y1 <= ys2)
			|| (x2 >= xs1 && x2 <= xs2 && y1 >= ys1 && y1 <= ys2)
			|| (x1 >= xs1 && x1 <= xs2 && y2 >= ys1 && y2 <= ys2)
			|| (x2 >= xs1 && x2 <= xs2 && y2 >= ys1 && y2 <= ys2)) {
		if (y1 < ys1)
			y1 = ys1 - OVERSIZE;
		if (y2 > ys2)
			y2 = ys2 + OVERSIZE;
		if (x1 < xs1)
			x1 = xs1 - OVERSIZE;
		if (x2 > xs2)
			x2 = xs2 + OVERSIZE;
		*x = x1;
		*dx = x2 - x1;
		*y = y2;
		*dy = y2 - y1;
		return 1; /* as soon as possible */
	}
	/* if it crosses the window, let's troncate */
	if (((x1 < xs1 && x2 > xs2)
				&& ((y1 >= ys1 && y1 <= ys2) || (y2 >= ys1 && y2 <= ys2)))
			|| ((y1 < ys1 && y2 > ys2)
				&& ((x1 >= xs1 && x1 <= xs2) || (x2 >= xs1 && x2 <= xs2)))) {
		if (y1 < ys1)
			y1 = ys1 - OVERSIZE;
		if (y2 > ys2)
			y2 = ys2 + OVERSIZE;
		if (x1 < xs1)
			x1 = xs1 - OVERSIZE;
		if (x2 > xs2)
			x2 = xs2 + OVERSIZE;
		*x = x1;
		*dx = x2 - x1;
		*y = y2;
		*dy = y2 - y1;
		return 1;
	}
	/* if it surrounds, much less often, the window, let's troncate too */
	if (x1 < xs1 && x2 > xs2 && y1 < ys1 && y2 > ys2) {
		y1 = ys1 - OVERSIZE;
		y2 = ys2 + OVERSIZE;
		x1 = xs1 - OVERSIZE;
		x2 = xs2 + OVERSIZE;
		*x = x1;
		*dx = x2 - x1;
		*y = y2;
		*dy = y2 - y1;
		return 1;
	}
	return 0;
}

#define G_PAS (2 * SCALE_X)
#define G_DEMIPAS (SCALE_X)
int new_clip_to_window(x, y, dx, dy)
long *x, *y, *dx, *dy;
{
long x1, y1, x2, y2, xs1, ys1, xs2, ys2; /* cartesian coordinates */
	
	x1 = *x;
	y2 = *y;
	x2 = x1 + *dx;
	y1 = y2 - *dy;

	xs1 = xscreen;
	ys1 = yscreen;
	xs2 = xscreen + dxscreen;
	ys2 = yscreen + dyscreen;

	/*
	 * The rectangle is completely outside of the display.
	 */
	if ((xs1 > x2) || (x1 > xs2) || (ys1 > y2) || (y1 > ys2))
		return 0;

	/*
	 * Let's see if we have to truncate something.
	 */
	if (x1 < xs1) {
		x1 = ((xs1 - G_DEMIPAS - 1) / G_PAS) * G_PAS + G_DEMIPAS;
		*x = x1;
		*dx = x2 - x1;
	}
	if (x2 > xs2) {
		x2 = ((xs2 + G_DEMIPAS) / G_PAS) * G_PAS + G_DEMIPAS;
		*dx = x2 - x1;
	}
	if (y1 < ys1) {
		y1 = ((ys1 - G_DEMIPAS - 1) / G_PAS) * G_PAS + G_DEMIPAS;
		*dy = y2 - y1;
	}		
	if (y2 > ys2) {
		y2 = ((ys2 + G_DEMIPAS) / G_PAS) * G_PAS + G_DEMIPAS;
		*y = y2;
		*dy = y2 - y1;
	}

	if (x1 == x2 && y1 == y2)
		return 0;

	return 1;
}


