/*
 *	MBK : constants and structures of graphic databases
 *	
 *	Version : 1.0
 *       Date	: 11/06/90
 */

/* Flags used in appart_win() to indicate wich sides are in the window */
#define APTOP       0x80
#define APRIGHT     0x40
#define APBOTTOM    0x20
#define APLEFT      0x10
#define APSURROUND  0x00

/* Descriptor type */
#define SEG     0
#define VIA     1
#define INS     2
#define FIGCON  3
#define INSCON  4
#define REF	5
#define INSSEG  6
#define INSREF  7

/* Layer code for color matching */
/* 30 is random choosen, doesn't intersect with layer code in mbk.h */
#define G_GATE	         30
#define G_CONT_POLY   	31
#define G_CONT_DIFN	   32
#define G_CONT_DIFP	   33
#define G_CONT_BODY_N	34
#define G_CONT_BODY_P	35
#define G_CONT_VIA	   36
#define G_CONT_VIA2	   37
#define G_REF	         38	
#define G_INS	         39
#define G_DEF	         40

/* Used to mask the via type in a via descriptor */
#define MASK   0x0f

#define SIZEVIA	4	/* via extension graduated in 1/2 lambda */
#define SIZECON	2	/* connector extension in 1/2 lambda */
#define WTRANS  8	/* overflowing of diff. upon poly for a transistor */
#define RTRANS  4	/* overflowing of poly upon diff. for a transistor */


#define MAXLAYER      0x18 /* Number of known layer */
#define DEFAULT_LAYER 0x19 /* Code for an unknown layer */ 

/* Limits of scale factor for Xdrawing */
#define MAX_ZOOM      80
#define MIN_ZOOM      0.01

#define LONG_MAX      1000000

#define STEP	0	/* Step by step running for connectors in fill_ins */
#define RUN	1	/* single pass running for connectors in fill_ins */

/***************************************************************************
*	            DEFINITION OF DATABASE STRUCTURES			   *
***************************************************************************/

/* All coordinates are graduated in half lambda */

typedef int PIXEL;
typedef long LAMBDA;

/* Rectangle descriptor */
typedef struct rect {
	LAMBDA 		X,Y,DX,DY; /* MBK coordinates */
	unsigned char 	TYPE; 	   /* 2-0 : rect. code for inspect */
	struct rect	*NEXT;	   /* Next one */
	char 		*PTMBK;    /* MBK descriptor associated */
	char 		*USER;	   /* User data */
} X_RECT;

/* Peek rectangle descriptor */
typedef struct rectpeek {
	LAMBDA 		X,Y,DX,DY; /* MBK coordinates */
	unsigned char 	TYPE; 	   /* 2-0 : rect. code for inspect */
	struct rectpeek	*NEXT;	  
} X_RECTPEEK;
	
/* String descriptor */ 
typedef struct string {
	LAMBDA 		X,Y;       /* MBK coordinates */
	char 		*STRING;   /* The string */
	struct string	*NEXT;	   /* The next string */
	unsigned char	TYPE;  	   /* 2-0 : rect. code for drawing */
	int		STRLG;	   /* String Length */
} X_STRING;


/* Backup structure for Loom_mouse */
struct zoomBack {
	LAMBDA x,y,dx,dy;
	float scale;
};

/* Structure of layer array */
struct layer {
	char LAYER_CODE;	/* Layer code for MBK */
	char *LAYER_NAME;	/* Layer name associated */
	LAMBDA EXT;		/* Extension associated in 1/2 lambda */
};
