/*******************************************************************************
* dbx defines for variable scope in order to retains correct data              *
*******************************************************************************/
#define GLOBAL_SCOPE        'G'  /* global scope */
#define FUNCTION_DEFINITION 'F'  /* function */
#define PARAMETER           'p'  /* parameter */
#define TYPE_DEFINITION     't'  /* new type, typedef */
#define NEW_STRUCTURE       'T'  /* new structure */
#define STATIC_FILE_SCOPE   'S'  /* static storage, file scope */
#define STATIC_LOCAL_SCOPE  'V'  /* static storage, local scope */

/*******************************************************************************
* dbx defines for storage class needed for address calculations                *
*******************************************************************************/
#define GLOB                32   /* global variable, all file scope */
#define A_STAT              38   /* static arrays, global or local */
#define S_STAT              40   /* simple static variable, global or local */
#define AUTO                128  /* local variable */
#define FUNCT               36   /* function */
#define PARAM               160  /* parameter */

/*******************************************************************************
* structures used to represent dbx symbolic datas                              *
*******************************************************************************/
/* This is needed to have in memory an image of the source file types and
variables in order to be able to trace the values of variables */

typedef struct TypeDefinition {      /* type declaration                      */
	struct TypeDefinition *next;      /* next one                              */
	char                  *name;      /* type name, for info only              */
	int                   typeNumber; /* dbx type in "name", actual C type     */
	int                   object;     /* final, pointer, array, structure, ... */
	int                   typeFrom;   /* comes from this type when complex     */
	int                   size;       /* structure total size                  */
	struct Element        *member;    /* link on members or elements           */
} STRUCT, *PTSTRUCT;

typedef struct Element {             /* structure field                       */
	struct Element        *next;      /* next one                              */
	char                  *name;      /* structure field name                  */
	int                   typeNumber; /* dbx type number in "name"             */
	int                   size;       /* field size                            */
	int                   address;    /* field address                         */
} ELEMENT, *PTELEMENT;


typedef struct Variable {            /* variable list                         */
	struct Variable       *next;      /* next variable                         */
	char                  *name;      /* variable name                         */
	int                   typeNumber; /* dbx type number in "name"             */
	int                   size;       /* variable size                         */
	int                   address;    /* address depends on class              */
	int                   class;      /* dbx variable storage class            */
	int                   scope;      /* dbx variable scope                    */
} VARIABLE, *PTVARIABLE;

typedef struct func {
	char              *name_func;     /* function name                         */
	int               adr_func;       /* function address in memory            */
	struct func       *next_func;     /* next function                         */
} FUNC, *PTFUNC;

/* structure de sauvegarde de nom de fonction : interp_br.c, yacc */
typedef struct fonc {
	char              *name;
	int               code_adr;
	struct fonc       *next_fonc;
} fonc, *ptfonc;


/* structure pour la liste TRACE */
typedef struct var {
	char              *var;        /* variable to be traced */
	struct var        *next;       /* next one */
} VARI , *PT_VAR;
