
/************************************************************************/
/* module   : m_init.c							*/
/* date     : 07/09/93							*/
/* auteurs  : RENAUD & VENOT & PITON					*/
/************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <malloc.h>
#include <varargs.h>

#include PAT_H
#include "libpat_l.h"

/* ###--------------------------------------------------------------### */
/* function     : M_INIT                                                */
/* description  : add a PAINI list to the good PAPAT structure if it    */
/*            does exist, else create PAPAT on the way                  */
/* called func. : FormatValue,  CheckPattern, MajPatternCourant,	*/
/*	      SplitIdent,CheckIdent, checkWidth, atoi, pat_addpaini,	*/
/*	      CreatePapat, CreateAction					*/
/* ###--------------------------------------------------------------### */
 

void M_INIT (va_alist)
va_dcl
{
va_list  pa;
char    *param,*valeur;
char	 buffer	     [80];
char     buffer_anx  [80];
char     tmp_valeur  [1024];
char     value       [1024];
int      dim,borne_g,borne_d,sens,i,j;
struct alpha_num decomp;
struct paini *tmp_paini  = NULL;
struct paini *tmp2_paini = NULL;

    if (racine_paseq == NULL)
       Erreur ("INIT must declare output file name first\n");

    va_start(pa);

    param = va_arg(pa, char *);
    if (param == NULL) 
       Erreur ("INIT needs any parameters\n");
    strcpy(buffer,param);

    if ( GNP_TAB_PAIOL_CREE ==  GNP_INACTIF) 
    {
       racine_paiol = (struct paiol *) reverse (racine_paiol);
       racine_paiol = pat_crtpaiol(racine_paiol);
       GNP_TAB_PAIOL_CREE = GNP_ACTIF;
    }

    CheckPattern (buffer);
    MajPatternCourant(buffer);

    param = va_arg(pa, char *);
    if ( param == NULL) 
       Erreur ("INIT expected a paiol\n");

    while ( param != NULL) 
    {
       valeur = va_arg(pa, char *);
       if ( valeur == NULL) 
          Erreur ("INIT expected a string value\n");
       strcpy (tmp_valeur,valeur);

       strcpy(buffer,param);
       SplitIdent (buffer,buffer_anx);
       CheckIdent (buffer);

       if (strlen (buffer_anx) == 0) 
          dim = 0;
       else 
       {
          TraiterChaine (buffer_anx, &decomp);
          CheckWidth (&decomp);
          if (strlen (decomp.gauche) == 0)
            dim = 0;
          else 
          {
            if (strlen(decomp.alpha) ==0)
               dim = 1;
            else 
            {
               borne_g = atoi (decomp.gauche);
               borne_d = atoi (decomp.droite);
               if ( borne_g > borne_d ) 
               {
                  borne_d--;
                  sens = -1;
                  dim = borne_g - borne_d;
               }
               else 
               {
                  borne_d++;
                  sens = 1;
                  dim = borne_d - borne_g;
               }
            }
          }
       }
       switch (dim) 
       {
         case 0: 
         {
           FormatValue (value,tmp_valeur,1,GNP_UP,0);
	   tmp2_paini = pat_addpaini (NULL, buffer, *value);
           tmp_paini = FusionPaini (tmp_paini, tmp2_paini);
           break;
         }
         case 1: 
         {
           strcat(buffer," ");
           strcat(buffer,decomp.gauche);
           FormatValue (value,tmp_valeur,1,GNP_UP,0);
	   tmp2_paini = pat_addpaini (NULL, buffer, *value);
           tmp_paini = FusionPaini (tmp_paini, tmp2_paini);
           break;
         }
         default: 
         {
           FormatValue (value,tmp_valeur,dim,sens,0);
           for (i = borne_g, j=0; i != borne_d; i = i + sens ,j++) 
           {
              sprintf (buffer_anx, "%s %d", buffer, i);
	      tmp2_paini = pat_addpaini (NULL, buffer_anx, value[j]);
              tmp_paini = FusionPaini (tmp_paini, tmp2_paini);
           }
         }
       }
       param = va_arg(pa, char *);
    }
    va_end (pa);
    CreatePapat (NULL,NULL,tmp_paini);
    CreateAction ("I");
}
