


/*      Alliance CAD System 2.0                                   */
/*        FITPATH Package 0.0                                     */
/*                                                                */
/*  Author  :      Jean-Paul CHAPUT                               */
/*  E-mail  :  cao-vlsi@masi.ibp.fr                               */
/* ************************************************************** */
/*  module  :  "dml.h"                                            */


#ifndef  _FpgenMGN_
#define  _FpgenMGN_


/* Constant name for internal use in modules "FpgenMBK" and "FpgenMGN".
   Other FPGEN constants that have not to be seen by the user are
   defined in the header "FpgenMBK.h". */
#define        C_FPGEN_LSBIndexZero         0
#define        C_FPGEN_MSBIndexZero         1
#define        C_FPGEN_DEFAULTWidth        -2
#define        C_FPGEN_DEFAULTSlice        -3
#define        C_FPGEN_ConModeDEFAULT       2
#define        C_FPGEN_ConModeEXPLICIT      3
#define        C_FPGEN_ConModeIMPLICIT      4
#define        C_FPGEN_DataTypeTerminal    'T'
#define        C_FPGEN_DataTypeBlock       'B'
#define        C_FPGEN_ConSideDefault      'D'
#define        C_FPGEN_ConSideEast         'E'
#define        C_FPGEN_ConSideWest         'W'
#define        C_FPGEN_ConSideNorth        'N'
#define        C_FPGEN_ConSideSouth        'S'

/* Constant name for FPGEN user C source files. */
#define        LSB_INDEX_ZERO              C_FPGEN_LSBIndexZero
#define        MSB_INDEX_ZERO              C_FPGEN_MSBIndexZero
#define         TERMINAL                   C_FPGEN_DataTypeTerminal
#define            BLOCK                   C_FPGEN_DataTypeBlock
#define          DEFAULT_WIDTH             C_FPGEN_DEFAULTWidth
#define          DEFAULT_SLICE             C_FPGEN_DEFAULTSlice
#define          DEFAULT_MODE              C_FPGEN_ConModeDEFAULT
#define         EXPLICIT_MODE              C_FPGEN_ConModeEXPLICIT
#define         IMPLICIT_MODE              C_FPGEN_ConModeIMPLICIT
#define          DEFAULT_SIDE              C_FPGEN_ConSideDefault
#define             EAST_SIDE              C_FPGEN_ConSideEast
#define             WEST_SIDE              C_FPGEN_ConSideWest
#define            NORTH_SIDE              C_FPGEN_ConSideNorth
#define            SOUTH_SIDE              C_FPGEN_ConSideSouth


/* The last argument for functions that have a variable number
   of parameters. */
#define        EOL        ((char*)NULL)


#ifndef  ANSI_PROTO
/* Interface functions of module (K&R syntax). */
extern void  DP_DEFLOFIG();
extern void  DP_SAVLOFIG();
extern void  DP_CONMODE();
extern void  DP_LOCON();
extern void  DP_IMPORT();
extern void  DP_FLATTEN();
extern void  DP_INV();
extern void  DP_AND2();
extern void  DP_AND3();
extern void  DP_NAND2();
extern void  DP_NAND3();
extern void  DP_OR2();
extern void  DP_OR3();
extern void  DP_NOR2();
extern void  DP_NOR3();
extern void  DP_XOR2();
extern void  DP_XNOR2();
extern void  DP_NAND2MASK();
extern void  DP_NOR2MASK();
extern void  DP_NXOR2MASK();
extern void  DP_NMUX2CS();
extern void  DP_MUX2CS();
extern void  DP_MUX3CD();
extern void  DP_BUSE();
extern void  DP_NBUSE();
extern void  DP_ADD2F();
extern void  DP_ADSB2F();
extern void  DP_SHIFT();
extern void  DP_CONST();
extern void  DP_NUL();
extern void  DP_PLATCH1();
extern void  DP_NPLATCH1();
extern void  DP_PMS();
extern void  DP_PDFF();
extern void  DP_PDFFT();
extern void  DP_RFG1CC();
extern void  DP_RFG2CC();
extern void  DP_RFG1C0();
extern void  DP_RFG2C0();

# ifndef  HOME_PC
extern void  DP_RFG1FC();
extern void  DP_RFG2FC();
extern void  DP_RFG1F0();
extern void  DP_RFG2F0();
# endif
#else
/* Interface functions of module (ANSI syntax). */
extern void  DP_DEFLOFIG(char *aFigName ,
						 long  aMaxWidth,
						 long  aMsb0    ,
						 long  aType    );
extern void  DP_SAVLOFIG(void);
extern void  DP_CONMODE(char aConMode);
extern void  DP_LOCON(char *aConName,
					  char  aConDir ,
					  char *aConSig ,
					  char  aConSide);
/* extern void  DP_IMPORT(va_alist) va_dcl */
extern void  DP_FLATTEN(void);
/* extern void  DP_INV(       va_alist) va_dcl */
/* extern void  DP_AND2(      va_alist) va_dcl */
/* extern void  DP_AND3(      va_alist) va_dcl */
/* extern void  DP_NAND2(     va_alist) va_dcl */
/* extern void  DP_NAND3(     va_alist) va_dcl */
/* extern void  DP_OR2(       va_alist) va_dcl */
/* extern void  DP_OR3(       va_alist) va_dcl */
/* extern void  DP_NOR2(      va_alist) va_dcl */
/* extern void  DP_NOR3(      va_alist) va_dcl */
/* extern void  DP_XOR2(      va_alist) va_dcl */
/* extern void  DP_XNOR2(     va_alist) va_dcl */
/* extern void  DP_NAND2MASK( va_alist) va_dcl */
/* extern void  DP_NOR2MASK(  va_alist) va_dcl */
/* extern void  DP_XNOR2MASK( va_alist) va_dcl */
/* extern void  DP_NMUX2CS(   va_alist) va_dcl */
/* extern void  DP_MUX2CS(    va_alist) va_dcl */
/* extern void  DP_MUX3CD(    va_alist) va_dcl */
/* extern void  DP_BUSE(      va_alist) va_dcl */
/* extern void  DP_NBUSE(     va_alist) va_dcl */
/* extern void  DP_ADD2F(     va_alist) va_dcl */
/* extern void  DP_ADSB2F(    va_alist) va_dcl */
/* extern void  DP_SHIFT(     va_alist) va_dcl */
/* extern void  DP_CONST(     va_alist) va_dcl */
/* extern void  DP_NUL(       va_alist) va_dcl */
/* extern void  DP_PLATCH1(   va_alist) va_dcl */
/* extern void  DP_NPLATCH1(  va_alist) va_dcl */
/* extern void  DP_PMS(       va_alist) va_dcl */
/* extern void  DP_PDFF(      va_alist) va_dcl */
/* extern void  DP_PDFFT(     va_alist) va_dcl */
/* extern void  DP_RFG1C0(    va_alist) va_dcl */
/* extern void  DP_RFG1CC(    va_alist) va_dcl */
/* extern void  DP_RFG2C0(    va_alist) va_dcl */
/* extern void  DP_RFG2CC(    va_alist) va_dcl */
#endif


#endif
