#include  <stdio.h>

#include  <genlib.h>

#include  "support.h"
#include  "dplimits.h"
#include  "sub2.h"

/*      Alliance CAD System 2.0                                   */
/*        FITPATH Package 0.0                                     */
/*                                                                */
/*  Author  :      Jean-Paul CHAPUT                               */
/*  E-mail  :  cao-vlsi@masi.ibp.fr                               */
/* ************************************************************** */
/*  module  :      "sub2.c"                                       */


/* Module internal constants. */

/* Names of additional leaf cells. */
static char *TabLeafCellSub2[6] = {     "bn1csa1_fp",
								       "n1csa10_fp",
									  "n1csa1i_fp",
								     "n1csa1p_fp",
                                    "n1csa10i_fp",
                                   "n1csa10p_fp"
                                   };


/* Interface function of module.
   extern       char *Dgn_DispachSub2();
   */

/* Internal functions of module. */
static       void  Dgn_ErrorSub2();
static       void  Dgn_VhdlSub2();
static       void  Dgn_NetlistSub2();


/*  Function  :  'Dgn_DispatchSub2'                                */
/* -------------------------------------------------------------- */
/*  Interface of substracter 2 entries generator.                       */

extern char *Dgn_DispatchSub2(sub2_modelname,
							  sub2_width    ,
							  sub2_slice    ,
							  sub2_msb0     ,
							  sub2_vhdl     ,
							  sub2_netlist  ,
							  sub2_icon     )
	char *sub2_modelname;  /* Model name.                    */
	long  sub2_width;      /* Bus wide.                      */
	long  sub2_slice;      /* give the LSB starting slice.   */
	long  sub2_msb0;       /* Zero as MSB index.             */
	long  sub2_vhdl;       /* Generation of behavioral view. */
	long  sub2_netlist;    /* Generation of netlist view.    */
	long  sub2_icon;       /* Generation of icon.            */
{
	static short  DispachSub2_FirstCall = FALSE;
	static  char  ModelName[C_SUPP_MBKSZNAME];

	/* The first time the generator is call : */
	/*     - Load specific errors.            */
	if (!DispachSub2_FirstCall)
	{
		Dgn_ErrorSub2();
		DispachSub2_FirstCall = TRUE;
	}

	/* Check if, at least, one view is asked. */
	if (   (sub2_netlist == FALSE)
		 &&(sub2_vhdl    == FALSE)
		 &&(sub2_icon    == FALSE) )
		Dut_PrintError( E_SUB2_ERROR, E_SUB2_NOVIEW);

	/* Check the bus wide. */
	if ((sub2_width < 0) || (sub2_width > C_DPLIMITS_MAXSLICE))
		Dut_PrintError( E_SUB2_ERROR, E_SUB2_WIDTH, sub2_width);

	/* Check the LSB starting slice. */
	if ((sub2_slice < 0) || ( sub2_slice
							+sub2_width > DP_WIDTH))
		Dut_PrintError( E_SUB2_ERROR, E_SUB2_SLICE, sub2_slice);

	/* Check the model name. */
	if (sub2_modelname == (char*)NULL)
#ifndef  CRUNCH_FILENAME
		/* Build a more explicit model name. */
		(void*)sprintf( ModelName, "sub2_%ldx%ldx%ld%c_cl",
					                   DP_WIDTH              ,
					                 sub2_width              ,
					                 sub2_slice              ,
					               ((sub2_msb0 ) ? 'm' : 'l'));
#else
		/* Build the crunched model name. */
		strcpy( ModelName, Dut_MakeCrunchModelName(
									    "iv"       ,
									8L,  DP_WIDTH-1,
									8L, sub2_width-1,
									8L, sub2_slice  ,
									0L, sub2_msb0   ));
#endif
	else
		strcpy( ModelName, sub2_modelname);

	/* Generation of behaviorial view. */
	if (sub2_vhdl)
		Dgn_VhdlSub2( ModelName,
			   	   	 sub2_width,
			   		 sub2_slice,
			   		 sub2_msb0 );

	/* Generation of netlist view. */
	if (sub2_netlist)
		Dgn_NetlistSub2( ModelName,
						sub2_width,
						sub2_slice,
						sub2_msb0 );

	/* Generation of icone. */
	/* if (sub2_icon) */
	
	/* Return name of the generated model. */
	return((sub2_modelname == (char*)NULL) ?     ModelName 
		                                  : sub2_modelname);
}


/*  Function  :  'Dgn_ErrorSub2'                                   */
/* -------------------------------------------------------------- */
/*  Adds generator specific errors to the main errors data base.  */

static void  Dgn_ErrorSub2()
{
	Dut_AddError( E_SUB2_ERROR, E_SUB2_WIDTH,
				  "sub2alid bus width : %ld.");
	Dut_AddError( E_SUB2_ERROR, E_SUB2_MODELNAME,
				  "Missing model name.");
	Dut_AddError( E_SUB2_ERROR, E_SUB2_NOVIEW,
				  "No view to generate.");
	Dut_AddError( E_SUB2_ERROR, E_SUB2_OPENVBE,
				  "Unable to create file : \"%s\".");
}


/*  Function  :  'Dgn_NetListSub2'                                 */
/* -------------------------------------------------------------- */
/*  Generation of substracter behvioral view.                 */

static void  Dgn_VhdlSub2(sub2_modelname,
					      sub2_width    ,
					      sub2_slice    ,
						  sub2_msb0     )
	char *sub2_modelname;  /* Nom du modele.           */
	long  sub2_width;      /* Largeur du bus.          */
	long  sub2_slice;      /* LSB starting slice.      */
	long  sub2_msb0;       /* Zero comme index du MSB. */
{
	FILE *Sub2File;
	long  BitIndex,     LenString,      TmpTime;
	char  BusWide[256], BusWide0[256], BusWide1[256], TmpString[256];

	/* *** Creating the file holding behavioral view. *** */
	if ((Sub2File=mbkfopen(sub2_modelname,
						            "vbe",
						       WRITE_TEXT)) == (FILE*)NULL)
		Dut_PrintError( E_SUB2_ERROR, E_SUB2_OPENVBE,
					                  sub2_modelname);

	/* *** Write an identification header *** */

	/* Standart begin of header. */
	fprintf( Sub2File, 
"-- ###-------------------------------------------------------------###\n"
			);
	fprintf( Sub2File, 
"-- #                                                                 #\n"
			);
	fprintf( Sub2File,
"-- #    Alliance CAD System 2.0                                      #\n"
			);
    fprintf( Sub2File,
"-- #      FITPATH Package 0.0                                        #\n"
			);
    fprintf( Sub2File,
"-- #                                                                 #\n"
			);
    fprintf( Sub2File,
"-- # Author :     Jean-Paul CHAPUT                                   #\n" 
			);
    fprintf( Sub2File,
"-- # E-mail : cao-vlsi@masi.ibp.fr                                   #\n"
			);
	fprintf( Sub2File, 
"-- # *************************************************************** #\n"
			);
	fprintf( Sub2File,
"-- #                                                                 #\n"
			);
    fprintf( Sub2File,
"-- # Generator : \"sub2g\" (sub2erter buffer)                            #\n"
			);
	fprintf( Sub2File, 
"-- # --------------------------------------------------------------- #\n"
			);

	/* Print name of the generated file. */
	sprintf( TmpString, "\"%s.vbe\"."           , sub2_modelname);
    fprintf( Sub2File  , "-- # File : %-55s  #\n",      TmpString);
	fprintf( Sub2File,
"-- #                                                                 #\n"
			);

	/* Print date of generation. */
	TmpTime                = time((time_t*)NULL);
	sprintf( TmpString, "%s", asctime(localtime(&TmpTime)) );
	LenString              = strlen( TmpString);
	TmpString[LenString-1] = (char)0;
    fprintf( Sub2File  , "-- #           Date : %-45s  #\n", TmpString);

	/* Give the call used to generate the model. */
	sprintf(  TmpString, "\"sub2g %ld %ld %ld %s -vhdl -o %s\"" ,
			                        DP_WIDTH                      ,
			                       sub2_width                      ,
			                       sub2_slice                      ,
			                      (sub2_msb0     ) ? " -msb0"  : "",
			                       sub2_modelname                  );
    fprintf( Sub2File  , "-- # Generator Call : %-45s  #\n", TmpString);

	fprintf( Sub2File, 
"-- ###-------------------------------------------------------------###\n"
			);


	/* Select terminals (and signals) bus indexation. */
	/* (depending to the flag "sub2_msb0")             */
	if (!sub2_msb0)
		{ sprintf( BusWide, "(%ld downto %ld)", sub2_width-1
				                                +sub2_slice  ,
				                                sub2_slice  );

		  sprintf( BusWide0,"(%ld downto %ld)", sub2_width
				                                +sub2_slice  ,
				                                sub2_slice+1);

		  sprintf( BusWide1,"(%ld downto %ld)", sub2_width
				                                +sub2_slice  ,
				                                sub2_slice  );
        }
	else
		{ sprintf( BusWide, "(%ld to %ld)", DP_WIDTH-sub2_slice
				                                    -sub2_width   ,
				                            DP_WIDTH-sub2_slice-1);

		  sprintf( BusWide0,"(%ld to %ld)", DP_WIDTH-sub2_slice
				                                    -sub2_width+1 ,
				                            DP_WIDTH-sub2_slice  );

		  sprintf( BusWide1,"(%ld to %ld)", DP_WIDTH-sub2_slice
				                                    -sub2_width+1 ,
				                            DP_WIDTH-sub2_slice-1);
        }

	/* *** Interface description. *** */
	fprintf( Sub2File, "\nENTITY %s IS\n\tPORT(\n", sub2_modelname);

    /* Control terminals. */
	fprintf( Sub2File, "%14s :  out BIT;\n", "cout");
	fprintf( Sub2File, "%14s :  out BIT;\n", "ovr" );

	/* Terminals of data buses. */
	fprintf( Sub2File, "%14s :  in BIT_VECTOR%s;\n", "i0", BusWide);
	fprintf( Sub2File, "%14s :  in BIT_VECTOR%s;\n", "i1", BusWide);
	fprintf( Sub2File, "%14s : out BIT_VECTOR%s;\n", "o", BusWide );

	/* Supplies terminals. */
	fprintf( Sub2File, "%14s :  in BIT;\n", "vdd");
	fprintf( Sub2File, "%14s :  in BIT\n" , "vss");


	/* *** End of interface description *** */
	fprintf( Sub2File, "\t);\nEND %s;\n\n\n", sub2_modelname);


	/* *** Behavioral view *** */
	fprintf( Sub2File, "ARCHITECTURE behaviour_data_flow OF %s IS\n\n",
			                                            sub2_modelname);

    fprintf( Sub2File, "SIGNAL carry : BIT_VECTOR%s;\n",BusWide1);

	fprintf( Sub2File, "BEGIN\n\n");
	fprintf( Sub2File, "\tcarry(0) <= '1';\n\n" );
	fprintf( Sub2File, "\to%s <= i0%s xor (not i1%s) xor carry%s;\n\n" , BusWide, BusWide, BusWide, BusWide);
	fprintf( Sub2File, "\tcarry%s <= (i0%s and (not i1%s)) or (i0%s and carry%s) or (carry%s and (not i1%s));\n\n" , BusWide0, BusWide, BusWide, BusWide, BusWide, BusWide, BusWide);
	fprintf( Sub2File, "\tcout <= carry(%ld);\n\n", (DP_WIDTH-sub2_slice));
	fprintf( Sub2File, "\tovr <= carry(%ld) xor carry(%ld);\n\n", DP_WIDTH-sub2_slice, DP_WIDTH-sub2_slice-1);

	/* Check supplies connections. */
	fprintf( Sub2File, "\t-- ****************>");
	fprintf( Sub2File, " Supplies Check "      );
	fprintf( Sub2File, "<****************\n\n" );

	fprintf( Sub2File, "\tASSERT((vdd = '1') and (vss = '0'))\n");
	fprintf( Sub2File, "\t\tREPORT \"Power supply is missing on %s.\"\n",
			                                              sub2_modelname);
	fprintf( Sub2File, "\t\tSEVERITY WARNING;\n\n");

	/* *** End of behavioral view *** */
	fprintf( Sub2File, "END behaviour_data_flow;\n");

	/* *** Close the file holding the behavioral view *** */
	fclose( Sub2File);
}


/*  Function  :  'Dgn_NetListSub2'                                 */
/* -------------------------------------------------------------- */
/*  Generation of substracter netlist view.                   */

static void  Dgn_NetlistSub2(sub2_modelname,
						     sub2_width    ,
						     sub2_slice    ,
						     sub2_msb0     )
	char *sub2_modelname;  /* Model name.            */
	long  sub2_width;      /* Bus wide.              */
	long  sub2_slice;      /* LSB starting slice.    */
	long  sub2_msb0;       /* Zero as MSB index.     */
{
	int   number;
	long  BusIndex;
	long  SignalIndex0;
	long  SignalIndex1;
	long  LeafCellIndex;

	char *LeafCellSliceName;
	char  LeafCellInstaName[C_SUPP_MBKSZNAME];

	char  BusNameI0[C_SUPP_MBKSZNAME];
	char  BusNameI1[C_SUPP_MBKSZNAME];
	char  BusNameO[ C_SUPP_MBKSZNAME];

	char  PinNameI0[C_SUPP_MBKSZNAME];
	char  PinNameI1[C_SUPP_MBKSZNAME];
	char  PinNameO[ C_SUPP_MBKSZNAME];
	char  SignalName0[C_SUPP_MBKSZNAME];
	char  SignalName1[C_SUPP_MBKSZNAME];


	/* Select name of the leaf cell model. */

	/* Creation of the new logical figure. */
	DEF_LOFIG( sub2_modelname);

	/* Name of data bus terminals. */
	if (!sub2_msb0)
	{
		sprintf( BusNameI0,"i0[%ld:%ld]", sub2_width-1+sub2_slice, sub2_slice);
		sprintf( BusNameI1,"i1[%ld:%ld]", sub2_width-1+sub2_slice, sub2_slice);
		sprintf( BusNameO , "o[%ld:%ld]", sub2_width-1+sub2_slice, sub2_slice);
	}
	else
	{
		sprintf( BusNameI0,"i0[%ld:%ld]", DP_WIDTH-sub2_slice
				                                  -sub2_width  ,
				                          DP_WIDTH-sub2_slice-1);
		sprintf( BusNameI1,"i1[%ld:%ld]", DP_WIDTH-sub2_slice
				                                  -sub2_width  ,
				                          DP_WIDTH-sub2_slice-1);
		sprintf( BusNameO , "o[%ld:%ld]", DP_WIDTH-sub2_slice
				                                  -sub2_width  ,
				                          DP_WIDTH-sub2_slice-1);
	}

 
	/* Creation of figure terminals. */

	/* **** Control terminals **** */
	LOCON( "cout" , OUT , "cout"  );
	LOCON( "ovr"  , OUT   , "ovr"   );

    /* **** Data bus terminals **** */
	LOCON( BusNameI0, IN  , BusNameI0);
	LOCON( BusNameI1, IN  , BusNameI1);
	LOCON( BusNameO , OUT , BusNameO );

	/* **** Supply terminals **** */
	LOCON( "vdd",  INOUT ,  "vdd"); 
	LOCON( "vss",  INOUT ,  "vss"); 
	
	
	/* Creation of leaf cells instances. */

         

	/* ("normals" cells of column)       */
	for( LeafCellIndex=sub2_slice;
		 LeafCellIndex<sub2_slice+sub2_width-1; LeafCellIndex++)
	{
		number = (sub2_slice+sub2_width-1-LeafCellIndex)%2;
        SignalIndex0 = ( sub2_slice + sub2_width -2 - LeafCellIndex ) ;
        SignalIndex1 = ( sub2_slice + sub2_width -1 - LeafCellIndex ) ;
		

		/* Build terminal leaf cell name. */
        if (LeafCellIndex==sub2_slice)
          {
              if (number==0)
           	      LeafCellSliceName=TabLeafCellSub2[4];
              else
           	      LeafCellSliceName=TabLeafCellSub2[5];
          }
		/* Build leaf cell name. */
        else
          {
              if (number==0)
               	  LeafCellSliceName=TabLeafCellSub2[2];
        	  else
           		  LeafCellSliceName=TabLeafCellSub2[3];
          }
		     
		/* Compute terminal index. */
		if (!sub2_msb0) BusIndex =              LeafCellIndex;
		else            BusIndex = DP_WIDTH -1 -LeafCellIndex;

		/* Build signals names. */
		sprintf( PinNameI0, "i0[%ld]", BusIndex);
		sprintf( PinNameI1, "i1[%ld]", BusIndex);
		sprintf( PinNameO ,  "o[%ld]", BusIndex);
		sprintf( SignalName0 , "cin_%ld", SignalIndex0 );
		sprintf( SignalName1 , "cin_%ld", SignalIndex1 );

		/* Built instance name. */
		sprintf(LeafCellInstaName, "n1csa_%ld", (LeafCellIndex-sub2_slice) ); 

        
        if (LeafCellIndex==sub2_slice)

		/* Terminal leaf cell instanciation. */
		LOINS( LeafCellSliceName,
			   LeafCellInstaName,
			          PinNameI0 ,
			          PinNameI1 ,
			          SignalName0  ,
                      PinNameO , "vdd", "vss", EOL);
	
        else
		/* Leaf cell instanciation. */
		LOINS( LeafCellSliceName,
			   LeafCellInstaName,
	        		  PinNameI0 ,
	         		  PinNameI1 ,
					  SignalName1,
	      		      SignalName0,
               		  PinNameO, "vdd", "vss", EOL);
	}

    /* Creation of intermediaire cells */
    /* Intermediaire instance */
    LeafCellSliceName = TabLeafCellSub2[1];
	LeafCellIndex = sub2_slice+sub2_width-1;

	/* Compute terminal index. */
	if (!sub2_msb0) BusIndex =              LeafCellIndex ;
	else            BusIndex = DP_WIDTH -1 -LeafCellIndex;

	/* Build signals names. */
	sprintf( PinNameI0, "i0[%ld]", BusIndex);
	sprintf( PinNameI1, "i1[%ld]", BusIndex);
	sprintf( PinNameO ,  "o[%ld]", BusIndex);

	/* Built instance name. */
	sprintf(LeafCellInstaName, "n1csa_%ld", (DP_WIDTH-sub2_slice-1) ); 

	/* Intermediaire instanciation */
	LOINS( LeafCellSliceName,
		   LeafCellInstaName,
                   PinNameI0,
		    	   PinNameI1,
			        "cin_0" ,
			         "cout" ,
                   PinNameO , "vdd","vss",EOL);

	/* Creation of buffer instance. */

	/*  buffer instance name. */
	sprintf(LeafCellInstaName, "bn1csa_%ld",(DP_WIDTH-sub2_slice)); 
	LeafCellSliceName = TabLeafCellSub2[0];

	/* Buffer instanciation. */
	LOINS( LeafCellSliceName,
		   LeafCellInstaName,
		           "cin_0"  ,
		            "cout"  ,
		            "ovr"   , "vdd", "vss", VSS, EOL);

	/* Ends and write to disk the new figure. */
	SAVE_LOFIG();
}
