#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>

#include   DUT_H
#include  "dplimits.h"
#include  "pdfft.h"


/*      Alliance CAD System 2.0                                   */
/*        FITPATH Package 0.0                                     */
/*                                                                */
/*  Author  :      Jean-Paul CHAPUT                               */
/*  E-mail  :  cao-vlsi@masi.ibp.fr                               */
/* ************************************************************** */
/*  module  :  "DPPDFFT.c"                                        */


/* Internal constants of module. */
#define        S_DPPDFFT_ARGLC_MSB0         "msb0"
#define        S_DPPDFFT_ARGLC_VHDL         "vhdl"
#define        S_DPPDFFT_ARGLC_NETLIST      "netlist"
#define        S_DPPDFFT_ARGLC_ICON         "icon"
#define        S_DPPDFFT_ARGLC_DPWTH        "dpwth"
#define        S_DPPDFFT_ARGLC_WIDTH        "width"
#define        S_DPPDFFT_ARGLC_SLICE        "slice"
#define        S_DPPDFFT_ARGLC_NAME         "o"


/* Error constants of module. */
#define        E_DPPDFFT_ARGLC_DPWTH         2
#define        E_DPPDFFT_ARGLC_WIDTH         3
#define        E_DPPDFFT_ARGLC_SLICE         4
#define        E_DPPDFFT_ARGLC_NAME          5
#define        E_DPPDFFT_ARGLC_NOVIEW        6
#define        E_DPPDFFT_MaxWidth            7


main(argc,argv)
	 int  argc;
	char *argv[];
{
	long  arglc_width;
	long  arglc_slice;

	/* Loads errors associated to command line arguments. */
	Dut_ErrorArgLc();

	/* Initialization of arguments table. */
	Dut_AddArgLc( C_SUPP_ARGLC_SW, C_SUPP_ARGLC_FLOATPOS,
				                S_DPPDFFT_ARGLC_MSB0    );
	Dut_AddArgLc( C_SUPP_ARGLC_SW, C_SUPP_ARGLC_FLOATPOS,
				                S_DPPDFFT_ARGLC_VHDL    );
	Dut_AddArgLc( C_SUPP_ARGLC_SW, C_SUPP_ARGLC_FLOATPOS,
				                S_DPPDFFT_ARGLC_NETLIST );
	Dut_AddArgLc( C_SUPP_ARGLC_SW, C_SUPP_ARGLC_FLOATPOS,
				                S_DPPDFFT_ARGLC_ICON    );
	Dut_AddArgLc( C_SUPP_ARGLC_VL, 1                    ,
				                S_DPPDFFT_ARGLC_DPWTH   );
	Dut_AddArgLc( C_SUPP_ARGLC_VL, 2                    ,
				                S_DPPDFFT_ARGLC_WIDTH   );
	Dut_AddArgLc( C_SUPP_ARGLC_VL, 3                    ,
				                S_DPPDFFT_ARGLC_SLICE   );
	Dut_AddArgLc( C_SUPP_ARGLC_VL, C_SUPP_ARGLC_FLOATPOS,
				                S_DPPDFFT_ARGLC_NAME    );

	/* Errors associated to a missing argument. */
	Dut_AddError( E_DPPDFFT_ERROR, E_DPPDFFT_ARGLC_NAME,
		 "Missing argument : \"%s\" (model name).");
	Dut_AddError( E_DPPDFFT_ERROR, E_DPPDFFT_ARGLC_DPWTH,
		 "Missing argument : \"%s\" (data-path wide).");
	Dut_AddError( E_DPPDFFT_ERROR, E_DPPDFFT_ARGLC_WIDTH,
		 "Missing argument : \"%s\" (bus wide).");
	Dut_AddError( E_DPPDFFT_ERROR, E_DPPDFFT_ARGLC_SLICE,
		 "Missing argument : \"%s\" (LSB starting slice).");
	Dut_AddError( E_DPPDFFT_ERROR, E_DPPDFFT_ARGLC_NOVIEW,
	"No view to generate (use \"-vhdl\", \"-netlist\" or \"-icon\").");

	Dut_AddError( E_DPPDFFT_ERROR, E_DPPDFFT_MaxWidth,
		 "<dpwidth>:value out of range:%ld.");

	/* Reads arguments of command line. */
	Dut_SetArgLc( argc, argv);

	/* Display command line arguments. */
	Dut_PrintArgLc( S_DPPDFFT_ARGLC_DPWTH  );
	Dut_PrintArgLc( S_DPPDFFT_ARGLC_WIDTH  );
	Dut_PrintArgLc( S_DPPDFFT_ARGLC_SLICE  );
	Dut_PrintArgLc( S_DPPDFFT_ARGLC_MSB0   );
	Dut_PrintArgLc( S_DPPDFFT_ARGLC_VHDL   );
	Dut_PrintArgLc( S_DPPDFFT_ARGLC_NETLIST);
	Dut_PrintArgLc( S_DPPDFFT_ARGLC_ICON   );
	Dut_PrintArgLc( S_DPPDFFT_ARGLC_NAME   );

	/* Le nom a-t-il ete lu. */
	/* if (!Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_NAME)) */
	/*	Dut_PrintError( E_DPPDFFT_ERROR     ,       */
	/*				    E_DPPDFFT_ARGLC_NAME,       */
	/*				    S_DPPDFFT_ARGLC_NAME);      */

	/* Check if the data-path bus wide argument has been read. */
	if (!Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_DPWTH))
		Dut_PrintError( E_DPPDFFT_ERROR      , 
					    E_DPPDFFT_ARGLC_DPWTH,
					    S_DPPDFFT_ARGLC_DPWTH);
	else
	{
		DP_WIDTH = atol( Dut_GetArgLcValue(S_DPPDFFT_ARGLC_DPWTH));

		/* Check the value of 'DP_WIDTH'. */
		if ((DP_WIDTH < 1) || (DP_WIDTH > C_DPLIMITS_MAXSLICE))
			Dut_PrintError( E_DPPDFFT_ERROR, E_DPPDFFT_MaxWidth,
						    DP_WIDTH);
	}

	/* Check if the operator bus wide argument has been read. */
	if (!Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_WIDTH))
		Dut_PrintError( E_DPPDFFT_ERROR      , 
					    E_DPPDFFT_ARGLC_WIDTH,
					    S_DPPDFFT_ARGLC_WIDTH);
	else
		arglc_width =
			atol( Dut_GetArgLcValue(S_DPPDFFT_ARGLC_WIDTH));

	/* Check if the LSB starting slice argument has been read. */
	if (!Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_SLICE))
		Dut_PrintError( E_DPPDFFT_ERROR      , 
					    E_DPPDFFT_ARGLC_SLICE,
					    S_DPPDFFT_ARGLC_SLICE);
	else
		arglc_slice =
			atol( Dut_GetArgLcValue(S_DPPDFFT_ARGLC_SLICE));


	/* Check if at least one view is asked. */
	if (   (!Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_VHDL   ))
		 &&(!Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_NETLIST))
		 &&(!Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_ICON   )) )
		Dut_PrintError( E_DPPDFFT_ERROR       ,
					    E_DPPDFFT_ARGLC_NOVIEW);


	Dgn_DispatchPdfft(
		Dut_GetArgLcValue(S_DPPDFFT_ARGLC_NAME  ),
		arglc_width                              ,
		arglc_slice                              ,
		Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_MSB0   ),
		Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_VHDL   ),
		Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_NETLIST),
		Dut_GetArgLcFlag(S_DPPDFFT_ARGLC_ICON   )
		);

	exit(0);
}
