%{
#include MUT_H
#include "drucompi.yac.tab.h"
#include "drucutil.h"
#include "drucompi.h"
 
#undef yywrap

#ifdef FLEX_SCANNER

#ifdef YY_INPUT
#undef YY_INPUT
#endif

#define YY_INPUT(buf,result,max_size) \
        do { \
        int c = getc(yyin); \
           result = (c == EOF) ? YY_NULL \
           : (buf[0] = isupper(c) ? toupper(c) : c, 1); \
        } while(0)

int yylineno;

#else /* using lex, for sure */

#ifdef input
#undef input
#endif

#define input() (((yytchar = yysptr > yysbuf ? U(*--yysptr)    \
                   : getc(yyin)) == 10 ?(yylineno++,yytchar)   \
                      : yytchar) == EOF ? 0                    \
                         : isupper(yytchar) ? toupper(yytchar) \
                           : yytchar)
#endif

%}

%p 3000

delim [ \n\t]
esp   [ \t]
rc    [\n]
pct   [\.\,\;\:\'\"\?\/\~\`\@\^<>\!\&\*\(\)\-\_\=\+\{\}\[\]\$\%\\\|]
blanc {delim}+

lettre      [A-Za-z]
ident       {lettre}({lettre}*|{dec}*|[_]*)*
dec         [0-9]
decimal     {dec}+
reel        {dec}*([\.]{dec}*)
comment [#]({lettre}*{dec}*{esp}*{pct}*)*{rc}

%%


{blanc}                 { ECHO;}
layer                   { ECHO; return(DRUC_LAYER);}
regle                   { ECHO; return(DRUC_REGLE);}
regles                  { ECHO; return(DRUC_REGLES);}
fin                     { ECHO; return(DRUC_FIN);}

define                  { ECHO; return(DRUC_DEFINE);}
undefine                { ECHO; return(DRUC_UNDEFINE);}
caracterise             { ECHO; return(DRUC_CARACTERISE);}
relation                { ECHO; return(DRUC_RELATION);}

exclusion               { ECHO; return(DRUC_EXCLUSION);}
union                   { ECHO; return(DRUC_UNION);}
enveloppe               { ECHO; return(DRUC_ENVELOPPE);}
marge                   { ECHO; return(DRUC_MARGE);}
croix                   { ECHO; return(DRUC_CROIX);}
intersection            { ECHO; return(DRUC_INTERSECT);}
extension               { ECHO; return(DRUC_EXTENSION);}
inclusion               { ECHO; return(DRUC_INCLUSION);}
distance                { ECHO; return(DRUC_DISTANCE);}

surface_inter           { ECHO; return(DRUC_SURFACE_INTER);}
longueur_inter          { ECHO; return(DRUC_LONG_INTER);}
largeur_inter           { ECHO; return(DRUC_LARGE_INTER);}
penetre_inter           { ECHO; return(DRUC_PENET_INTER);}
paralelle_inter         { ECHO; return(DRUC_PARAL_INTER);}
perpendiculaire_inter   { ECHO; return(DRUC_PERPEN_INTER);}

axiale                  { ECHO; return(DRUC_AXIALE);}
geodesique	             { ECHO; return(DRUC_GEODESIQUE);}
frontale  	             { ECHO; return(DRUC_FRONTALE);}
laterale_min            { ECHO; return(DRUC_LATERALE_MIN);}
laterale_max            { ECHO; return(DRUC_LATERALE_MAX);}

longueur_min            { ECHO; return(DRUC_LONGUEUR_MIN);}
longueur_max            { ECHO; return(DRUC_LONGUEUR_MAX);}
largeur_min             { ECHO; return(DRUC_LARGEUR_MIN);}
largeur_max             { ECHO; return(DRUC_LARGEUR_MAX);}
superieure              { ECHO; return(DRUC_SUP);}
inferieure              { ECHO; return(DRUC_INF);}

surface                 { ECHO; return(DRUC_SURFACE);}
longueur                { ECHO; return(DRUC_LONGUEUR);}
largeur                 { ECHO; return(DRUC_LARGEUR);}

notch       	        { ECHO; return(DRUC_NOTCH);}
min         	        { ECHO; return(DRUC_MIN);}
max         	        { ECHO; return(DRUC_MAX);}
"<="		        { ECHO; return(DRUC_INFEQ);}
">="		        { ECHO; return(DRUC_SUPEQ);}
{decimal}               { ECHO; sscanf(yytext,"%d",&DrucInputEntier);
		  	             return(DRUC_ENTIER);
                        }
{reel}                  { ECHO; sscanf(  yytext,"%f",& DrucInputFloat);
		  	             return(DRUC_FLOAT);
                        }
{ident}                 { ECHO; sscanf(yytext,"%s",DrucInputChaine);
		 	             return(DRUC_NOM);
                        }
{comment}               { ECHO;}
.                       { ECHO; return (*yytext);}

%%
int yywrap()
{ return(1) ; }
