/********************************************************************
*                                                                   *
* Laboratoire MASI CAO-VLSI, UPMC, Copyright 1991 1992 1993 1994    *
*                                                                   *
* Software support Email : cao-vlsi@masi.ibp.fr                     *
*                                                                   *
* Authors : Zouina AKTOUF &                                         *
*           El Arabi RHOMARI &                                      *
*           Jose MARTINS DOS SANTOS                                 *
*                                                                   *
* Supervision & Modifications : Lotfi BEN AMMAR                     *
*                                                                   *
********************************************************************/
/**********************************************************************
*                 Structure de donnees DPP                            *
**********************************************************************/

typedef struct ADPP_SPACE
        {
        char   *INSNAME;        /* Nom de l'instance                      */
        char   *FIGNAME;        /* Nom du modele                          */
        char   *UPFIG;          /* Nom du modele l'instance mere          */
        char   *UPINS;          /* Nom de l'instance mere                 */
        long   X, Y    ;        /* Coordonnees de la cellule              */
        int   WIDTH   ;         /* largeur de la cellule                  */
        int   HEIGHT  ;         /* hauteur du bit slice                   */
        int   NBCASE;           /* Nombre de cases du tableau             */
        int   I;                /* index du  bit slice                    */
        int   J;                /* index de la colonne                    */
        int   TRACK_CAPACITY;   /* Nombre de pistes max                   */
        struct chain *N_CON;    /* Connecteurs NORD                       */
        struct chain *S_CON;    /* Connecteurs SUD                        */
        struct chain *DF_CON;   /* Connecteurs EST et OUEST               */
        struct chain *SEG;      /* Liste des segments horizontaux en TALU2*/
        struct chain *SIG;      /* Liste des signaux de l'instance        */
        struct chain *USER;     /* Specific application                   */
        }
        DPP_SPACE; /* Modele de la case */ 

typedef struct ADPP_CONNECTOR
        {
        char *NAME;              /* Nom du connecteur                        */
        int COL   ;              /* Index de la colonne                      */
        int LIN   ;              /* Index de la ligne                        */ 
        char ORIENT;             /* Orientation du connecteur                */
        DPP_SPACE *INS;              /* L'instance a laquelle appartient le connecteur*/
        struct chain *POS;       /* Liste des possibilites                   */
        struct ADPP_SIGNAL *SIGN;    /* Pointeur sur le signal                   */ 
        struct chain *USER;      /* Specific application                     */
        }
        DPP_CONNECTOR; /* Modele du connecteur */
        
typedef struct ADPP_POSSIBILITY
        {
        long XCON, YCON;          /* Coordonnees du connecteur                */
        char LAYER;               /* Code du LAYER                            */ 
        }
        DPP_POSSIBILITY; /*Possibilite de placement des connecteurs */
        
typedef struct ADPP_SIGNAL
        {
        char         *NAME   ;    /* Nom du signal                          */ 
    	long index   ;            /* Identificateur du signal MBK           */
    	char type    ;            /* I:interne, E:externe                   */
    	int MIN_COL  ;            /* Index de la colonne min                */
    	int width    ;            /* Largeur du signal                      */
    	int MIN_LIN  ;            /* Index de la ligne min                  */ 
    	int height   ;            /* Index de la ligne max                  */ 
        int TMP_MIN_COL;          /* MIN_COL temporaire                     */
        int TMP_width  ;          /* Largeur du signal temporaire           */
        int COMPUTE    ;          /* Indicateur de presence du signal dans la colonne */
    	struct chain *CON ;       /* Liste des connecteurs equipotentiels   */
    	struct chain *COL ;       /* Liste des colonnes                     */
    	struct chain *LIN ;       /* Liste des lignes                       */
    	struct chain *USER;       /* Specific application                   */
        }
        DPP_SIGNAL; /* Modele de signal */ 
 
typedef struct ADPP_SEGMENT
        {
        char *NAME;                 /* Nom du segment                       */   
        long X1,Y1,X2,Y2;           /* Coordonnees du segment               */
        long WIDTH;                 /* Largeur du  segment                  */
        }
        DPP_SEGMENT; /* Modele de segment */

typedef struct ADPP_DATAPATH
        {
        struct chain *SIG;        /* Liste de tous les signaux de la figure      */
        struct chain *CON;        /* Liste de tous les connecteurs de la figure  */
        }
        DPP_DATAPATH;

typedef struct DPP_GET_INDEX
        {
        struct DPP_GET_INDEX	*NEXT;
        char			*INSNAME;
        char			*UPFIG;
        char			*UPINS;
        int			     INDEX;
        } DPP_GET_INDEX_LIST;

/*********************************************************************************/
/*                        DPP constantes                                        */
/********************************************************************************/
#define MAXLIN 150
#define MAXCOL 400 
#define MSB 1 
#define LSB 0 
#define LAYERWIDTH ((long)2*SCALE_X)

/************************************************************************
*              structure des donnees  DPR                       		*
*									*
*	version : 3.0							*
*	date    : 16/03/92						*
************************************************************************/
typedef struct AFIGURE 
        {
        struct chain  *LIN;		/* liste des lignes	        	*/
        struct chain  *COL;		/* liste des colonnes	    	*/
        struct chain  *SIG;		/* liste des signaux	    	*/
        struct chain  *CON;		/* liste des connecteurs	    */
        struct chain  *ALLOW;	/* liste des transparences    	*/
        struct chain  *ALIM;	/* liste des ports d'alim	    */
        struct chain  *GRID;	/* noeud bas gauche de la figure*/
        struct chain  *USER;	/* specific application(s)	    */
        }
        FIGURE;	  /* mother figure */

typedef struct ACOLUMN 
	    {
        char		*NAME;		/* nom indexe de la colonne 	*/
        char		 TYPE;	        /* Left,Right,Channel,Operator 	*/
        long		 X,Y;          	/* coordonnees			*/
        long		 WIDTH;        	/* Largeur 			*/
        long		 S_WIDTH;      	/* Largeur Symbolique		*/
        long     	 HEIGHT;       	/* Hauteur 			*/
        long     	 S_HEIGHT;     	/* Hauteur Symbolique		*/
	    int		 INDEX;		/* position  de la colonne 	*/
        struct chain 	*SIG;       	/* Liste des signaux 		*/
        struct chain 	*DF_CON;      	/* Liste des connecteurs (ph)	*/
        struct chain 	*CT_CON;      	/* Liste des connecteurs (ph)	*/
        struct chain 	*ALIMS;      	/* Liste des connecteurs (ph)	*/
        struct chain 	*INS;        	/* Liste des instances 		*/
        struct chain 	*VIA;        	/* Liste des vias ou contacts 	*/
        struct chain 	*SEG;        	/* Liste des segments 		*/
        struct chain 	*ALLOW;       	/* Liste des Transparences 	*/
        struct chain 	*RDATA;        	/* Zone de Travail 		*/     
        struct chain 	*ALLOWUSED;    	/* Zone de Manoeuvre 		*/
        struct chain 	*USER;		/* specific application(s)	*/
        }
        COLUMN;	  /* Modele de colonne */

typedef struct ANWELLREF
      	{
        long 		 X,Y;		/* coordonnees 		 	*/
        long 		 WIDTH;		/* largeur 		 	*/
    	struct chain	*INS;		/* Pointeur sur la cellule      */
    	struct chain    *COL;       	/* Pointeur sur la colonne      */
        struct chain    *USER;        	/* specific application(s)	*/
        }
    	NWELLREF;/* Modele de reference nwell */

typedef struct ACONNECTOR 
    	{
        char		*NAME;         	/* Nom 				*/
        char		 TYPE;       	/* (I)nterne ou (E)xterne 	*/
        long 		 NBPOSS;	/* Nombre de possibilites 	*/
        long 		 MINPOS;	/* Nombre de possibilites 	*/
        long 		 MAXPOS;	/* Nombre de possibilites 	*/
        struct chain    *POS;        	/* liste des possibilites 	*/ 
    	struct chain    *SIG;       	/* Pointeur sur le signal       */ 
    	struct chain	*INS;		/* Pointeur sur la cellule      */
    	struct chain    *COL;       	/* Pointeur sur la colonne      */
    	struct chain    *LIN;       	/* Pointeur sur la ligne        */
        struct chain    *USER;        	/* specific application(s)	*/
        }
        CONNECTOR;  /* Modele du Connecteur */

typedef struct APOSSIBILITY
      	{
        long 		 X,Y;		/* coordonnees 		 	*/
        long 		 WIDTH;		/* largeur 		 	*/
        long 		 TRACK;		/* numero de piste 	 	*/
        char		 TYPE;       	/* fixe ou acces-multiple 	*/
    	char             ACCES;		/* segment name             	*/
    	char             LAYER;		/* code du layer              	*/
        CONNECTOR       *CON;           /* Connecteur                   */
        struct chain    *USER;        	/* specific application(s)	*/
        }
    	POSSIBILITY;/* Modele de possibilite */

typedef struct ATRACK
        {
        struct ATRACK *NEXT;
        long           Y;
        }
        TRACK;

typedef struct AGABARIT
        {
        char          *ALIM1;
        long           WALIM1,WALIM2;
        long           HEIGHT;
        long           NBTRACK;
        struct ATRACK *TRACK;
        }
        GABARIT;

typedef struct  AACCESS
        {
        struct AACCESS       *NEXT;
        struct AACCESS       *PREV;
        struct APOSSIBILITY  *POS;
        char                  ORIENT;
        struct ASIGNAL       *SIG;
        struct APOSSIBILITY  *LAST_POS;
        char                  LAST_ORIENT;
        }
        ACCESS;

typedef struct  ANODE
        {
        struct ANODE   *NEXT;
        struct ANODE   *PREV;
        struct ANODE   *DPR_UP;
        struct ANODE   *DPR_DWN;
        struct AACCESS *DPR_RIGHT;
        struct AACCESS *DPR_LEFT;
        }
        NODE;

typedef struct ALINE 
    	{
        long		 X,Y;          	/* coordonnees			*/
        long		 WIDTH;        	/* Largeur 			*/
        long     	 HEIGHT;       	/* Hauteur 			*/
    	int		 INDEX;		/* position de la ligne (B-S)	*/
        GABARIT	        *GAB;           /* Gabarit de la ligne	        */
        NODE            *GRID;          /* noeud bas gauche de la ligne */
        struct chain 	*SIG;       	/* Liste des signaux 		*/
        struct chain 	*CON;      	/* Liste des connecteurs (Ph) 	*/
        struct chain 	*INS;        	/* Liste des instances 		*/
        struct chain 	*N_WELL;       	/* Liste des Bornes NWell 	*/
        struct chain 	*ALLOW;       	/* Liste des Transparences 	*/
        struct chain 	*USER;        	/* specific application(s)	*/
        }
        LINE;	/* Modele de colonne */

typedef struct ASIGNAL 
    	{
        char		*NAME;		/* nom du signal 		*/
        long		 INDEX;		/* identificateur du signal MBK	*/
        char		 TYPE;       	/* (I)nterne ou (E)xterne 	*/
        long             MIN_LIN;       /* index de la ligne Dn         */
        long             HEIGHT;        /* hauteur du signal            */
        long             MIN_COL;       /* index de la colonne left     */
        long             WIDTH;         /* largeur du signal            */
        struct chain	*CON;		/* Liste des connecteurs	*/
        struct chain	*COL;		/* Liste des colonnes 		*/
        struct chain	*LIN;		/* Liste des lignes 		*/
        struct chain	*BCROSS;	/* Zone de Manoeuvre 		*/
        struct chain	*YPRIOR;	/* Zone de Manoeuvre 		*/
        struct chain    *USER;        	/* specific application(s)	*/
        }
        SIGNAL;	/* Modele de Signal */  

typedef struct AINSTANCE 
    	{
        char		*INSNAME;	/* instance name     		*/
        char		*FIGNAME;	/* figure name       		*/
        long		 X,Y;		/* coordonnees			*/
        long		 WIDTH;		/* Largeur 			*/
        long		 HEIGHT;       	/* Hauteur 			*/
    	char		 TRANSF;	/* transformation		*/
        struct chain 	*DF_CON;	/* Liste des connecteurs (Ph) 	*/
        struct chain 	*CT_CON;	/* Liste des connecteurs (Ph) 	*/
        struct chain 	*ALIMS; 	/* Liste des connecteurs (Ph) 	*/
        struct chain 	*RAPPELS; 	/* Liste des connecteurs (Ph) 	*/
        struct chain 	*ALLOW; 	/* Liste des Transparences 	*/
        struct chain 	*N_WELL;       	/* Liste des Bornes NWell 	*/
        struct chain    *USER;        	/* specific application(s)	*/
        }
        INSTANCE;	/* Modele d'une instance  */

typedef struct ASEGMENT 
    	{
    	char            *NAME;		/* segment name             	*/
    	long             X1,Y1,X2,Y2;	/* segment coordinates      	*/
    	long             WIDTH;	        /* largeur du segment        	*/
    	char             TYPE;		/* possibles values: V H    	*/
    	char             LAYER;		/* physical layer           	*/
        struct chain    *USER;        	/* specific application(s)	*/
        }
    	SEGMENT;	/* modele de segment  */

typedef struct AINLINE
    	{
        int		Y;		/* Abscisse 			*/
        struct chain	*CON;		/* Liste des ports a connecter  */
        struct chain    *USER;        	/* specific application(s)	*/
        }
        INLINE;		/* Modele de liste de ports alignes */  

typedef struct AVIA 
    	{
        int		 TYPE;		/* contact ou via		*/
    	long		 X,Y;		/* coordonnees			*/
        struct chain    *USER;        	/* specific application(s)	*/
        }
        VIA;		/* Modele de via */      

typedef struct SCR_ConnectorList
    	{
    	struct SCR_ConnectorList       *NextCon; /* Next symbolic terminal */
    	long				ConName; /* Signal index           */
    	long				Mark   ; /* Track indice           */
    	}
        ConnectorList;

typedef struct SCR_SegmentList
    	{
    	struct SCR_SegmentList	       *NextSeg;
        char                           *SegName;
    	long				X1Seg   ;
    	long				Y1Seg   ;
    	long				X2Seg   ;
    	long				Y2Seg   ;
    	}
        SegmentList;

typedef struct SCR_ViasList
    	{
    	struct SCR_ViasList	       *NextVia;
    	long				XVia    ;
    	long				YVia    ;
    	}
        ViasList;

typedef struct ACHANNEL
        {
        ConnectorList  *NORTHCON;
        ConnectorList  *SOUTHCON;
        ConnectorList  *WESTCON;
        ConnectorList  *EASTCON;
        }
        CHANNEL ;

typedef struct ANUMTRACK
        {
        struct ANUMTRACK *NEXT ; /* Next numtrack          */
        long              NUM  ; /* Symbolic track index   */
        long              TRACK; /* Horizontal track Y     */
        } 
        NUMTRACK ;

/************************************************************************
*              DPR constantes                                  		*
************************************************************************/
#define SETACCESS       1803
#define SESAME		1903
#define OPTIPLACE       2003

#define MAXLONG  999999999
#define MINLONG -999999999
#define MAXINT  99999
#define MININT -99999
#define EXTERN  'E'
#define INTERN  'I'
#define TYPEFIX 'F'
#define MULTIAX 'M'
#define ORIENTX 'X'
#define FTRACK  -1
#define MAXTRACK 10
#define TRUE     1
#define FALSE    0
#define FOUT    stdout

#define WLAYER1            1 
#define WLAYER2            2 
#define WTRAN              2 
#define NWELL_NWELL       12 
#define MIN_NWELL          4 
#define ALU1_ALU1          4 
#define NOTCHE_LAYER1      1 
#define VIA_VIA            4 
#define CANAL_BORDER_RIGHT 2 
#define CANAL_BORDER_LEFT  2 
#define CANAL_INTER_TRACK  5 

#define DEBUG_SESAME    0
#define DEBUG_LOAD      0
#define DEBUG_FIG       0
#define DEBUG_LIN       0
#define DEBUG_COL       0
#define DEBUG_GRILLE    0
#define DEBUG_ROUTER    0
#define DEBUG_DIFF      0
#define DEBUG_CHANNEL   0
#define DEBUG_MBK_LO    0
#define DEBUG_MBK_PH    0

#define Upcase(c) (((c>='a')&&(c<='z'))? c+'A'-'a':c)
#define dpr_min(x,y) ((x<y)?x:y)
#define dpr_max(x,y) ((x>y)?x:y)

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>
#include "mut315.h"
#include "mlo404.h"
#include "mph402.h"
