/********************************************************************
*                                                                   *
* Laboratoire MASI CAO-VLSI, UPMC, Copyright 1991 1992 1993 1994    *
*                                                                   *
* Software support Email : cao-vlsi@masi.ibp.fr                     *
*                                                                   *
* Authors : Zouina AKTOUF &                                         *
*           El Arabi RHOMARI &                                      *
*           Jose MARTINS DOS SANTOS                                 *
*                                                                   *
* Supervision & Modifications : Lotfi BEN AMMAR                     *
*                                                                   *
********************************************************************/
/*********************************************************************************
*                         Fichier: chanrout_R.c                                  *
*       version : 3.0                                                            *
*       date    : 24/04/92                                                       *
*********************************************************************************/
/*********************************************************************************
*                                   PARTIE ROUTAGE CANAL                         *
*********************************************************************************/

#include "dpr_R.h"
#include "util_R.h"

/*********************************************************************************
* les fonction aff??? sont des utilitaires de debug                              *
*                                                                                *
*********************************************************************************/
 void affcon_chan(ptcon_orient,ps)
 ConnectorList *ptcon_orient;
 char *ps;

 {
 ConnectorList *ptcon_ch=NULL;

 printf("|	|____________Connecteur(s) d'orientation %s :\n",ps);
 for (ptcon_ch=ptcon_orient;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
     printf("|	|	|__ConName,Mark   : %ld, %ld.\n",
             ptcon_ch->ConName,
             ptcon_ch->Mark);
 printf("|	|_______________________________________  \n");
 }

/*********************************************************************************
* affdprpath                                                                     *
*                                                                                *
*********************************************************************************/
 void affdprpath(ptccol)
 chain_list *ptccol;

 {
 COLUMN    *ptcol;
 CHANNEL   *ptchannel;
  
 for (ptccol=ptccol->NEXT;ptccol;ptccol=ptccol->NEXT->NEXT)
     {
     ptcol = (COLUMN *)ptccol->DATA;
     printf("|	|__COL.index.name : %d, %s.\n ",ptcol->INDEX,ptcol->NAME);
     if ((ptchannel=(CHANNEL *)ptcol->DF_CON->DATA))
        {
        affcon_chan(ptchannel->NORTHCON,"NORTH");
        affcon_chan(ptchannel->SOUTHCON,"SOUTH");
        affcon_chan(ptchannel->WESTCON,"WEST");
        affcon_chan(ptchannel->EASTCON,"EAST");
        }
     }
 }

/********************************************************************************
* addnumtrack     ajout en debut de liste                                       *
*                 d'un element de type numtrack                                 *
********************************************************************************/
 NUMTRACK *addnumtrack(pt,num,track)
 NUMTRACK *pt;
 long      num,track;

 {
 NUMTRACK *ptnew;

 ptnew = (NUMTRACK *)mbkalloc(sizeof(NUMTRACK));
 ptnew->NEXT = pt;
 ptnew->NUM  = num;
 ptnew->TRACK = track;

 return ptnew ;
 }

/********************************************************************************
*liste_numtrack: creation de la liste des numtracks                             *
*                                                                               *
********************************************************************************/
 NUMTRACK *liste_numtrack(ptclinhead)
 chain_list *ptclinhead;

 {
 TRACK      *pttrack=NULL;
 NUMTRACK   *ptnum_track=NULL;
 NUMTRACK   *ptnum_track_head=NULL;
 long        num=1l;
 chain_list *ptclin=NULL;
 LINE       *ptlin=NULL;
 
 ptnum_track_head = addnumtrack(NULL,0,0);
 ptnum_track = ptnum_track_head;

 for (ptclin=ptclinhead;ptclin;ptclin=ptclin->NEXT)
     {
     ptlin = (LINE *)ptclin->DATA;
     for (pttrack=ptlin->GAB->TRACK->NEXT;pttrack;pttrack=pttrack->NEXT)
         {
         ptnum_track->NEXT = addnumtrack(ptnum_track->NEXT,num,pttrack->Y);
         ptnum_track = ptnum_track->NEXT;
         num++;
         }
     }
 return (ptnum_track_head->NEXT);
 }

/********************************************************************************
* Real2Symb_x
*  Traduction d'une largeur en lambdas  vers une largeur symbolique
*  adaptee au routeur canal.
********************************************************************************/
 long Real2Symb_x(width)
 long width;
 
 {
 long S_width=0;

 S_width = (width-(CANAL_BORDER_RIGHT*SCALE_X)-(CANAL_BORDER_LEFT*SCALE_X));
 if (S_width<0)
    return 0;
 S_width = S_width/(CANAL_INTER_TRACK*SCALE_X);
 return (S_width+1);
 }

/********************************************************************************
* Real2Symb_y
*  Traduction d'une hauteur en lambdas vers une hauteur symbolique adaptee
*  au routeur canal.
********************************************************************************/
 long Real2Symb_y(listnum_track)
 NUMTRACK  *listnum_track;
 
 {
 NUMTRACK  *pttrack;

 for (pttrack=listnum_track;pttrack->NEXT;pttrack=pttrack->NEXT);

 return (pttrack->NUM);
 }

/********************************************************************************
* visavis
*  return TRUE s'il n'y que des vis a vis dans le canal
*  sinon FALSE.
********************************************************************************/
 int        visavis(ptchannel)
 CHANNEL   *ptchannel;
 
 {
 ConnectorList *ptconl_ch=NULL;
 ConnectorList *ptconr_ch=NULL;
 long           nb_conl=0;
 long           nb_conr=0;

 if ((ptchannel->NORTHCON)||(ptchannel->SOUTHCON))
    return (FALSE);

 for (ptconl_ch=ptchannel->WESTCON;ptconl_ch;ptconl_ch=ptconl_ch->NextCon)
     {
     nb_conl++;
     }
 for (ptconr_ch=ptchannel->EASTCON;ptconr_ch;ptconr_ch=ptconr_ch->NextCon)
     {
     nb_conr++;
     }
 if (nb_conl!=nb_conr)
    return (FALSE);

 for (ptconl_ch=ptchannel->WESTCON;ptconl_ch;ptconl_ch=ptconl_ch->NextCon)
     {
     for (ptconr_ch=ptchannel->EASTCON;ptconr_ch;ptconr_ch=ptconr_ch->NextCon)
         {
         if ((ptconl_ch->ConName==ptconr_ch->ConName)&&
             (ptconl_ch->Mark!=ptconr_ch->Mark))
            return (FALSE);
         }
     }

 return (TRUE);
 }

/********************************************************************************
* dprchannel                                                                    *
* Encapsulation de l'appel du routeur canal symbolique pre- et post-traitements *
* Rotation Moins avant routage symbolique et Rotation Plus apres routage        *
********************************************************************************/
 void dprchannel(ptfig,ptlist_numtrack)
 FIGURE   *ptfig;
 NUMTRACK **ptlist_numtrack;
 
 {
 CHANNEL       *ptchannel=NULL;
 ConnectorList *ptcon_ch=NULL;
 SegmentList   *ptseg_ver=NULL;
 SegmentList   *ptseg_hor=NULL;
 ViasList      *ptvia=NULL;
 SegmentList   *ptseg_headver=NULL;
 SegmentList   *ptseg_headhor=NULL;
 ViasList      *ptvia_head=NULL;
 chain_list    *ptccol=NULL;
 chain_list    *ptccol1=NULL;
 chain_list    *ptclin_C=NULL;
 NUMTRACK      *pt_track_num;
 COLUMN        *ptcol=NULL;
 COLUMN        *ptcol1=NULL;
 long           delta_X=0;
 long           symbheight=0;
 long           symbwidth=0;
 long          *ptlong=NULL;
 long           debug1=0;
 ptype_list    *ptptype1=NULL;
 long           x,y,x1,y1,x2,y2;

# ifdef DEBUG_ROUTER
    if ( DEBUG_ROUTER ) fprintf(FOUT,"Entree de dprchannel :\n");
# endif

 *ptlist_numtrack = liste_numtrack(ptfig->LIN);
 for (ptccol=ptfig->COL->NEXT;ptccol;ptccol=ptccol->NEXT->NEXT)
     {
     ptcol = (COLUMN *)ptccol->DATA;
     ptchannel = (CHANNEL *)ptcol->DF_CON->DATA;

     /* Appel du routeur canal si necessaire en faisant une rotation du canal */
     if ((ptchannel->NORTHCON)||
         (ptchannel->SOUTHCON)||
         (ptchannel->EASTCON)||
         (ptchannel->WESTCON))
        {
        if ((ptcol->WIDTH!=0)||!visavis(ptchannel))
           {
           /* calcul des index symboliques des connecteurs EAST/WEST avant routage canal */
           /* Traduction des index des connecteurs du reel (Lambda) au symbolique (SCR) */
           /* Le premier index en bas est egal a 1 */
           pt_track_num = *ptlist_numtrack;
           for (ptcon_ch=ptchannel->WESTCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               for (;pt_track_num;pt_track_num=pt_track_num->NEXT)
                   if (pt_track_num->TRACK==ptcon_ch->Mark)
                      {
                      ptcon_ch->Mark=pt_track_num->NUM;
                      break;
                      }
           pt_track_num = *ptlist_numtrack;
           for (ptcon_ch=ptchannel->EASTCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               for (;pt_track_num;pt_track_num=pt_track_num->NEXT)
                   if (pt_track_num->TRACK==ptcon_ch->Mark)
                      {
                      ptcon_ch->Mark=pt_track_num->NUM;
                      break;
                      }
    
# ifdef DEBUG_CHANNEL 
    if (DEBUG_CHANNEL)
       {
       printf("| |__COL.index.name (NUMdespistes): %d, %s.\n",
               ptcol->INDEX, ptcol->NAME);
       if ((ptchannel=(CHANNEL *)ptcol->DF_CON->DATA))
          {
          affcon_chan(ptchannel->NORTHCON,"NORTH");
          affcon_chan(ptchannel->SOUTHCON,"SOUTH");
          affcon_chan(ptchannel->WESTCON,"WEST");
          affcon_chan(ptchannel->EASTCON,"EAST");
          }
       }
# endif
      
           ptcol->S_WIDTH = Real2Symb_x(ptcol->WIDTH);
           ptcol->S_HEIGHT = Real2Symb_y(*ptlist_numtrack);
           ptseg_headhor=NULL;
           ptseg_headver=NULL;
           ptvia_head=NULL;
           symbheight = ptcol->S_HEIGHT;
           symbwidth = ptcol->S_WIDTH;
           SymbolicChannelRouter(ptchannel->WESTCON,ptchannel->EASTCON,
                                 ptchannel->SOUTHCON,ptchannel->NORTHCON,
                                 &ptcol->S_HEIGHT,&ptcol->S_WIDTH,&ptseg_headhor,
                                 &ptseg_headver,&ptvia_head);
           if (ptcol->S_HEIGHT>symbheight)
              {
              printf("Error: Not enough horizontal tracks in channel number %d!!\n",
                      ptcol->INDEX);
              exit(30);
              }

           /*rotation des objets canal resultat et calcul des nouvelles coordonnees */
           for (ptseg_ver=ptseg_headver;ptseg_ver;ptseg_ver=ptseg_ver->NextSeg)
               {
               x1 = ptseg_ver->X1Seg;
               y1 = ptseg_ver->Y1Seg;
               x2 = ptseg_ver->X2Seg;
               y2 = ptseg_ver->Y2Seg;
               ptseg_ver->X1Seg = ptcol->S_WIDTH + 1 - y2;
               ptseg_ver->X2Seg = ptcol->S_WIDTH + 1 - y1;
               ptseg_ver->Y1Seg = x1;
               ptseg_ver->Y2Seg = x2;
               }

           for (ptseg_hor=ptseg_headhor;ptseg_hor;ptseg_hor=ptseg_hor->NextSeg)
               {
               x1 = ptseg_hor->X1Seg;
               y1 = ptseg_hor->Y1Seg;
               x2 = ptseg_hor->X2Seg;
               y2 = ptseg_hor->Y2Seg;
               ptseg_hor->X1Seg = ptcol->S_WIDTH + 1 - y2;
               ptseg_hor->X2Seg = ptcol->S_WIDTH + 1 - y1;
               ptseg_hor->Y1Seg = x1;
               ptseg_hor->Y2Seg = x2;
               }

           for (ptvia=ptvia_head;ptvia;ptvia=ptvia->NextVia)
               {
               x = ptvia->XVia;
               y = ptvia->YVia;
               ptvia->XVia = ptcol->S_WIDTH + 1 - y;
               ptvia->YVia = x;
               }

           /* Inversion des index des connecteurs nord du canal (a cause de la rotation) */
           for (ptcon_ch=ptchannel->NORTHCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               {
               ptcon_ch->Mark = ptcol->S_WIDTH + 1 - ptcon_ch->Mark;
               }

           /* Inversion des index des connecteurs sud du canal (a cause de la rotation) */
           for (ptcon_ch=ptchannel->SOUTHCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               {
               ptcon_ch->Mark = ptcol->S_WIDTH + 1 - ptcon_ch->Mark;
               }

           /* sauvegarde du resultat dans les champs SEG et VIA de la colonne */ 
           ptcol->SEG = addchain(ptcol->SEG,(void *)ptseg_headver);
           ptcol->SEG = addchain(ptcol->SEG,(void *)ptseg_headhor);
           ptcol->VIA = addchain(ptcol->VIA,(void *)ptvia_head);

           /*on pousse tout vers la droite si necessaire a partir du canal en cours*/
           if (ptcol->S_WIDTH>symbwidth)
              {
              delta_X = ((((ptcol->S_WIDTH-1)*CANAL_INTER_TRACK)+
                         CANAL_BORDER_LEFT+CANAL_BORDER_RIGHT)*SCALE_X-ptcol->WIDTH);
              }
           else
              {
              delta_X = 0;
              }
           if (delta_X>0) /* c.a.d plus large que prevu */
              {
              /* on actualise la largeur du canal */
              ptcol->WIDTH = ptcol->WIDTH + delta_X;
              /* on actualise les X des colonnes qui suivent */
              for (ptccol1=ptccol->NEXT;ptccol1;ptccol1=ptccol1->NEXT)
                  {
                  ptcol1=(COLUMN *)ptccol1->DATA;
                  ptcol1->X = ptcol1->X + delta_X;
                  }
              }
      
           /* calcul de l'ordonnee des connecteurs EAST/WEST apres routage canal */
           /* Traduction des index des connecteurs du symbolique (SCR) au reel (Lambda)*/
           pt_track_num = *ptlist_numtrack;
           for (ptcon_ch=ptchannel->WESTCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               for (;pt_track_num;pt_track_num=pt_track_num->NEXT)
                   if (pt_track_num->NUM==ptcon_ch->Mark)
                      {
                      ptcon_ch->Mark = pt_track_num->TRACK;
                      break;
                      }
           pt_track_num = *ptlist_numtrack;
           for (ptcon_ch=ptchannel->EASTCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               for (;pt_track_num;pt_track_num=pt_track_num->NEXT)
                   if (pt_track_num->NUM==ptcon_ch->Mark)
                      {
                      ptcon_ch->Mark = pt_track_num->TRACK;
                      break;
                      }
           }
        }
     else
        {
        ptcol->SEG = addchain(ptcol->SEG,(void *)NULL);
        ptcol->SEG = addchain(ptcol->SEG,(void *)NULL);
        ptcol->VIA = addchain(ptcol->VIA,(void *)NULL);
        }
     }

# ifdef DEBUG_ROUTER 
    if ( DEBUG_ROUTER ) fprintf(FOUT,"Sortie de dprchannel :\n");
# endif
  
 }

/********************************************************************************
* dprchannelbis                                                                 *
* Encapsulation de l'appel du routeur canal symbolique pre- et post-traitements *
* Rotation Plus avant routage symbolique et Rotation Moins apres routage        *
********************************************************************************/
 void dprchannelbis(ptfig,ptlist_numtrack)
 FIGURE   *ptfig;
 NUMTRACK **ptlist_numtrack;
 
 {
 CHANNEL       *ptchannel=NULL;
 ConnectorList *ptcon_ch=NULL;
 SegmentList   *ptseg_ver=NULL;
 SegmentList   *ptseg_hor=NULL;
 ViasList      *ptvia=NULL;
 SegmentList   *ptseg_headver=NULL;
 SegmentList   *ptseg_headhor=NULL;
 ViasList      *ptvia_head=NULL;
 chain_list    *ptccol=NULL;
 chain_list    *ptccol1=NULL;
 chain_list    *ptclin_C=NULL;
 NUMTRACK      *pt_track_num;
 COLUMN        *ptcol=NULL;
 COLUMN        *ptcol1=NULL;
 long           delta_X=0;
 long           symbheight=0;
 long           symbwidth=0;
 long          *ptlong=NULL;
 long           debug1=0;
 ptype_list    *ptptype1=NULL;
 long           x,y,x1,y1,x2,y2;

# ifdef DEBUG_ROUTER
    if ( DEBUG_ROUTER ) fprintf(FOUT,"Entree de dprchannelbis :\n");
# endif

 *ptlist_numtrack = liste_numtrack(ptfig->LIN);
 for (ptccol=ptfig->COL->NEXT;ptccol;ptccol=ptccol->NEXT->NEXT)
     {
     ptcol = (COLUMN *)ptccol->DATA;
     ptchannel = (CHANNEL *)ptcol->DF_CON->DATA;

     /* Appel du routeur canal si necessaire en faisant une rotation du canal */
     if ((ptchannel->NORTHCON)||
         (ptchannel->SOUTHCON)||
         (ptchannel->EASTCON)||
         (ptchannel->WESTCON))
        {
        if ((ptcol->WIDTH!=0)||!visavis(ptchannel))
           {
           /* calcul des index symboliques des connecteurs EAST/WEST avant routage canal */
           /* Traduction des index des connecteurs du reel (Lambda) au symbolique (SCR) */
           /* Le premier index en bas est egal a 1 */
           ptcol->S_WIDTH = Real2Symb_x(ptcol->WIDTH);
           ptcol->S_HEIGHT = Real2Symb_y(*ptlist_numtrack);
           pt_track_num = *ptlist_numtrack;
           for (ptcon_ch=ptchannel->WESTCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               for (;pt_track_num;pt_track_num=pt_track_num->NEXT)
                   if (pt_track_num->TRACK==ptcon_ch->Mark)
                      {
                      ptcon_ch->Mark = ptcol->S_HEIGHT + 1 - pt_track_num->NUM;
                      break;
                      }
           pt_track_num = *ptlist_numtrack;
           for (ptcon_ch=ptchannel->EASTCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               for (;pt_track_num;pt_track_num=pt_track_num->NEXT)
                   if (pt_track_num->TRACK==ptcon_ch->Mark)
                      {
                      ptcon_ch->Mark = ptcol->S_HEIGHT + 1 - pt_track_num->NUM;
                      break;
                      }

# ifdef DEBUG_CHANNEL 
    if (DEBUG_CHANNEL)
       {
       printf("| |__COL.index.name (NUMdespistes): %d, %s.\n",
               ptcol->INDEX, ptcol->NAME);
       if ((ptchannel=(CHANNEL *)ptcol->DF_CON->DATA))
          {
          affcon_chan(ptchannel->NORTHCON,"NORTH");
          affcon_chan(ptchannel->SOUTHCON,"SOUTH");
          affcon_chan(ptchannel->WESTCON,"WEST");
          affcon_chan(ptchannel->EASTCON,"EAST");
          }
       }
# endif
      
           /* inverser les deux listes chainees des connecteurs est et ouest */
           /* car SCR demande des listes triees par index croissant          */
           ptchannel->WESTCON=(ConnectorList *)reverse((chain_list *)ptchannel->WESTCON);
           ptchannel->EASTCON=(ConnectorList *)reverse((chain_list *)ptchannel->EASTCON);
    
# ifdef DEBUG_CHANNEL 
    if (DEBUG_CHANNEL)
       {
       printf("| |__COL.index.name (NUMdespistes): %d, %s.\n",
               ptcol->INDEX, ptcol->NAME);
       if ((ptchannel=(CHANNEL *)ptcol->DF_CON->DATA))
          {
          affcon_chan(ptchannel->NORTHCON,"NORTH");
          affcon_chan(ptchannel->SOUTHCON,"SOUTH");
          affcon_chan(ptchannel->WESTCON,"WEST");
          affcon_chan(ptchannel->EASTCON,"EAST");
          }
       }
# endif
      
           ptseg_headhor=NULL;
           ptseg_headver=NULL;
           ptvia_head=NULL;
           symbheight = ptcol->S_HEIGHT;
           symbwidth = ptcol->S_WIDTH;
           SymbolicChannelRouter(ptchannel->EASTCON,ptchannel->WESTCON,
                                 ptchannel->NORTHCON,ptchannel->SOUTHCON,
                                 &ptcol->S_HEIGHT,&ptcol->S_WIDTH,&ptseg_headhor,
                                 &ptseg_headver,&ptvia_head);
           if (ptcol->S_HEIGHT>symbheight)
              {
              printf("Error: Not enough horizontal tracks in channel number %d!!\n",
                      ptcol->INDEX);
              exit(30);
              }

           /*rotation des objets canal resultat et calcul des nouvelles coordonnees */
           for (ptseg_ver=ptseg_headver;ptseg_ver;ptseg_ver=ptseg_ver->NextSeg)
               {
               x1 = ptseg_ver->X1Seg;
               y1 = ptseg_ver->Y1Seg;
               x2 = ptseg_ver->X2Seg;
               y2 = ptseg_ver->Y2Seg;
               ptseg_ver->X1Seg = y1;
               ptseg_ver->X2Seg = y2;
               ptseg_ver->Y1Seg = ptcol->S_HEIGHT + 1 - x1;
               ptseg_ver->Y2Seg = ptcol->S_HEIGHT + 1 - x2;
               }

           for (ptseg_hor=ptseg_headhor;ptseg_hor;ptseg_hor=ptseg_hor->NextSeg)
               {
               x1 = ptseg_hor->X1Seg;
               y1 = ptseg_hor->Y1Seg;
               x2 = ptseg_hor->X2Seg;
               y2 = ptseg_hor->Y2Seg;
               ptseg_hor->X1Seg = y1;
               ptseg_hor->X2Seg = y2;
               ptseg_hor->Y1Seg = ptcol->S_HEIGHT + 1 - x2;
               ptseg_hor->Y2Seg = ptcol->S_HEIGHT + 1 - x1;
               }

           for (ptvia=ptvia_head;ptvia;ptvia=ptvia->NextVia)
               {
               x = ptvia->XVia;
               y = ptvia->YVia;
               ptvia->XVia = y;
               ptvia->YVia = ptcol->S_HEIGHT + 1 - x;
               }

           /* sauvegarde du resultat dans les champs SEG et VIA de la colonne */ 
           ptcol->SEG = addchain(ptcol->SEG,(void *)ptseg_headver);
           ptcol->SEG = addchain(ptcol->SEG,(void *)ptseg_headhor);
           ptcol->VIA = addchain(ptcol->VIA,(void *)ptvia_head);

           /*on pousse tout vers la droite si necessaire a partir du canal en cours*/
           if (ptcol->S_WIDTH>symbwidth)
              {
              delta_X = ((((ptcol->S_WIDTH-1)*CANAL_INTER_TRACK)+
                         CANAL_BORDER_LEFT+CANAL_BORDER_RIGHT)*SCALE_X-ptcol->WIDTH);
              }
           else
              {
              delta_X = 0;
              }
           if (delta_X>0) /* c.a.d plus large que prevu */
              {
              /* on actualise la largeur du canal */
              ptcol->WIDTH = ptcol->WIDTH + delta_X;
              /* on actualise les X des colonnes qui suivent */
              for (ptccol1=ptccol->NEXT;ptccol1;ptccol1=ptccol1->NEXT)
                  {
                  ptcol1=(COLUMN *)ptccol1->DATA;
                  ptcol1->X = ptcol1->X + delta_X;
                  }
              }
      
           /* calcul de l'ordonnee des connecteurs EAST/WEST apres routage canal */
           /* Traduction des index des connecteurs du symbolique (SCR) au reel (Lambda)*/
           for (ptcon_ch=ptchannel->WESTCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               for (pt_track_num=*ptlist_numtrack;pt_track_num;
                    pt_track_num=pt_track_num->NEXT)
                   if (pt_track_num->NUM==ptcol->S_HEIGHT+1-ptcon_ch->Mark)
                      {
                      ptcon_ch->Mark = pt_track_num->TRACK;
                      break;
                      }
           for (ptcon_ch=ptchannel->EASTCON;ptcon_ch;ptcon_ch=ptcon_ch->NextCon)
               for (pt_track_num=*ptlist_numtrack;pt_track_num;
                    pt_track_num=pt_track_num->NEXT)
                   if (pt_track_num->NUM==ptcol->S_HEIGHT+1-ptcon_ch->Mark)
                      {
                      ptcon_ch->Mark = pt_track_num->TRACK;
                      break;
                      }
           }
        }
     else
        {
        ptcol->SEG = addchain(ptcol->SEG,(void *)NULL);
        ptcol->SEG = addchain(ptcol->SEG,(void *)NULL);
        ptcol->VIA = addchain(ptcol->VIA,(void *)NULL);
        }
     }

# ifdef DEBUG_ROUTER 
    if ( DEBUG_ROUTER ) fprintf(FOUT,"Sortie de dprchannelbis :\n");
# endif
  
 }

