/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : error.c                                                     */
/*                                                                          */
/*    (c) copyright 1993 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 27/01/1993     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/
#include"declar.h"

/****************************************************************************
 *                         fonction dsbFatalError();                        *
 ****************************************************************************/
void dsbFatalError(code,str1,str2,num)
int code ;
char * str1 ;
char * str2 ;
int num ;

{

   if (DESB_LANG=='E')
   fprintf(stderr,"\n[FATAL ERR %d] ",code);
   else if(DESB_LANG=='F')
   fprintf(stderr,"\n[FATAL ERR %d] ",code);

   switch (code)
   {

      case 1 :

      if(DESB_LANG=='E')
      fprintf(stderr,"No %s connector in the circuit \n",NAME_VDD);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Pas de connecteur %s dans le circuit\n",NAME_VDD);
      break ;

      case 2 :
     
      if(DESB_LANG=='E')
      fprintf(stderr,"No %s connector in the circuit \n",NAME_VSS);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Pas de connecteur %s dans le circuit\n",NAME_VSS);
      break ;

      case 3 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Connector '%s' is power supply AND ground\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Connecteur '%s' a la fois alim ET masse\n",str2);;
      break ;

      case 4 :
     
      if(DESB_LANG=='E')
      fprintf(stderr,"No %s signal in the circuit \n",NAME_VDD);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Pas de signal %s dans le circuit\n",NAME_VDD);
      break ;
      
      case 5 :
     
      if(DESB_LANG=='E')
      fprintf(stderr,"No %s signal in the circuit \n",NAME_VSS);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Pas de signal %s dans le circuit\n",NAME_VSS);
      break ;

      case 6 :
     
      if(DESB_LANG=='E')
      fprintf(stderr,"Unknown type of connector\n");
      else if (DESB_LANG=='F')
      fprintf(stderr,"Connecteur de type inconnu\n");
      break ;

      case 7 :
     
      if(DESB_LANG=='E')
      fprintf(stderr,"Can't open file '%s'\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Ouverture du fichier '%s' impossible\n",str2);
      break ;

      case 8 :
     
      if(DESB_LANG=='E')
      fprintf(stderr,"Can't close file '%s'\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Fermeture du fichier '%s' impossible\n",str2);
      break ;

      case 9 :
     
      if(DESB_LANG=='E')
      fprintf(stderr,"Several external connectors on signal '%s'\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Plusieurs connecteurs externes sur le signal '%s'\n",str2);
      break ;

      default :

      if(DESB_LANG=='E')
      fprintf(stderr,"Unrecognized error\n");
      else if (DESB_LANG=='F')
      fprintf(stderr,"Erreur non identifiee\n");
      break ;

   }
fflush(stderr);
exit(-1);
}

/****************************************************************************
 *                         fonction dsbWarning();                           *
 ****************************************************************************/
void dsbWarning(code,str1,str2,str3,num)
int code ;
char * str1 ;
char * str2 ;
char * str3 ;
int num ;

{
lotrs_list * trans ;

   if(code == 0) code = num  ;
   else 
   {
      if (DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"[WAR %d] ",code);
      else if(DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"[WAR %d] ",code);
   }

   switch (code)
   {
   
      case 1 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Loop between 2 dual gates '%s' (bleeder found)\n",str2);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Boucle detectee entre 2 portes duales '%s' (bleeder trouve)\n",str2);
      break ;

      case 2 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Loop between 2 dual gates '%s' (latch found)\n",str2);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Boucle detectee entre 2 portes duales '%s' (latch trouve)\n",str2);
      break ;

      case 3 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Loop between 2 dual gates '%s' (nothing found)\n",str2);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Boucle detectee entre 2 portes duales '%s' (rien trouve)\n",str2);
      break ;

      case 4 :

      trans=(lotrs_list*)str3 ;
      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Transistor %s (X=%d,Y=%d) is a resistance\n",str2,trans->X,trans->Y);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Transistor %s (X=%d,Y=%d) monte en resistance\n",str2,trans->X,trans->Y);
      break ;

      case 5 :

      trans=(lotrs_list*)str3 ;
      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Transistor (X=%d,Y=%d) is a diode\n",trans->X,trans->Y);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Transistor (X=%d,Y=%d) monte en diode\n",trans->X,trans->Y);
      break ;

      case 6 :

      trans=(lotrs_list*)str3 ;
      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Transistor %s (X=%d,Y=%d) is always off\n",str2,trans->X,trans->Y);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Transistor %s (X=%d,Y=%d) bloque\n",str2,trans->X,trans->Y);
      break ;

      case 7 :

      trans=(lotrs_list*)str3 ;
      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Transistor (X=%d,Y=%d) is a capacitance\n",trans->X,trans->Y);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Transistor (X=%d,Y=%d) monte en capacite\n",trans->X,trans->Y);
      break ;

      case 8 :

      trans=(lotrs_list*)str3 ;
      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"%s of transistor (X=%d,Y=%d) is not connected\n",str2,trans->X,trans->Y);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"%s de transistor (X=%d,Y=%d) non connecte\n",str2,trans->X,trans->Y);
      break ;

      case 9 :

      trans=(lotrs_list*)str3 ;
      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Transistor %s (X=%d,Y=%d) is not used\n",str2,trans->X,trans->Y);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Transistor %s (X=%d,Y=%d) non utilise\n",str2,trans->X,trans->Y);
      break ;

      case 10 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Signal %s does not drive anything \n",str2);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Signal '%s' sans recepteur \n",str2);
      break ;

      case 11 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Signal %s is not driven \n",str2);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Signal '%s' sans emetteur \n",str2);
      break ;

      case 12 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Conflict may occur on signal '%s'\n",str2);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Le signal '%s' peut etre conflictuel\n",str2);
      break ;

      case 13 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"HZ state may occur on signal  '%s'\n",str2);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Le signal '%s' peut etre HZ\n",str2);
      break ;

      case 14 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Loop between 2 latchs '%s' and '%s'\n",str2,str3);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Boucle entre 2 latch '%s' et '%s' \n",str2,str3);
      break ;

      default :
   
      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Unrecognized warning\n");
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Warning non identifie\n");
      break ;
   }
}

   
/****************************************************************************
 *                         fonction dsbError();                             *
 ****************************************************************************/
void dsbError(code,str1,str2,num2,str3,num3)
int code ;
char * str1 ;
char * str2 ;
char * str3 ;
int    num2 ;
int    num3 ;

{
   if(code == 0) code = num2  ;
   else 
   {
   DESB_NB_ERR++;
      if (DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"[ERR %d] ",code);
      else if(DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"[ERR %d] ",code);
   }

   switch (code) 
   {

      case 1 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Short circuit ? : signal (%d)\n",num2);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Court circuit ? : signal (%d)\n",num2);
      break ;
      
      case 2 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Same level of '_s' on drain and source of transistor : '%s' and '%s'\n",str2,str3);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"meme poids de '_s' sur drain et source de transistor : '%s' et '%s'\n",str2,str3);
      break ;

      case 3 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Transistor-gate signal '%s' is not driven\n",str2);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Signal '%s'de grille de transistor non drive\n",str2);
      break ;

      case 4 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Loop between (%d)'%s' and (%d)'%s'\n",num2,str2,num3,str3);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"(%d)'%s' et (%d)'%s' sont reboucles",num2,str2,num3,str3);
      break ;

      case 5 :

      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Gate of transistor (X=%d,Y=%d) is not connected\n",num2,num3);
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Grille de transistor (X=%d,Y=%d) non connecte\n",num2,num3);
      break ;

      default :
   
      if(DESB_LANG=='E')
      fprintf(DESB_ERR_FILE,"Unrecognized error\n");
      else if (DESB_LANG=='F')
      fprintf(DESB_ERR_FILE,"Erreur non identifiee\n");
      break ;

   }
fflush(DESB_ERR_FILE);
}

/****************************************************************************
 *                         fonction dsbBug();                               *
 ****************************************************************************/
void dsbBug(code,str1,str2,str3,num)
int code  ;
char *str1;
char *str2;
char *str3;
int num   ;
{
   if(code == 0) code = num  ;
   else 
   {
      if (DESB_LANG=='E')
      fprintf(stderr,"\n[BD ERR %d] executing '%s' ",code,str1);
      else if(DESB_LANG=='F')
      fprintf(stderr,"\n[BD ERR %d] au cours de '%s' ",code,str1);
   }

   switch (code)
   {

      case 1 :

      if(DESB_LANG=='E')
      fprintf(stderr,"NULL Argument pointer \n");
      else if (DESB_LANG=='F')
      fprintf(stderr,"Pointeur Argument NULL\n");
      break ;

      case 2 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Signal '%s' without USER '%s'\n",str2,str3);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Signal '%s' sans USER '%s'\n",str2,str3);
      break ;

      case 3 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Incone of cone '%s' without USER '%s'\n",str2,str3);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Incone du cone  '%s' sans USER '%s'\n",str2,str3);
      break ;

      case 4 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Cone '%s' without model \n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Cone '%s' sans model \n",str2);
      break ;

      case 5 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Path of cone '%s' without USER '%s'\n",str2,str3);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Path du cone '%s' sans USER '%s'\n",str2,str3);
      break ;

      case 6 :

      if(DESB_LANG=='E')
      fprintf(stderr,"TabPath overflow\n");
      else if (DESB_LANG=='F')
      fprintf(stderr,"TabPath overflow\n");
      break ;

      case 7 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Outcone '%s' of cone '%s' not found\n",str2,str3);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Outcone '%s' du cone '%s' non trouve\n",str2,str3);
      break ;

      case 8 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Incone '%s' of cone '%s' not found\n",str2,str3);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Incone '%s' du cone '%s' non trouve\n",str2,str3);
      break ;

      case 9 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Incone is missing in cone '%s'\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Incone manquant dans le cone '%s'\n",str2);
      break ;

      case 10 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Outcone is missing in cone '%s'\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Outcone manquant dans le cone '%s'\n",str2);
      break ;

      case 11 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Command of latch '%s' not found\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Commande du latch '%s' non trouvee\n",str2);
      break ;

      case 12 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Cone '%s' without USER '%s'\n",str2,str3);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Cone '%s' sans USER '%s'\n",str2,str3);
      break ;

      case 13 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Unknown type of path in cone '%s'\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Type de branche inconnu dans le cone '%s'\n",str2);
      break ;

      case 14 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Connector '%s' without USER '%s'\n",str2,str3);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Connecteur '%s' sans USER '%s'\n",str2,str3);
      break ;

      case 15 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Not enough memory \n");
      else if (DESB_LANG=='F')
      fprintf(stderr,"Allocation memoire impossible\n");
      break ;

      case 16 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Unknown type of link in cone '%s'\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Type de link inconnu dans le cone '%s'\n",str2);
      break ;

      case 17 :

      if(DESB_LANG=='E')
      fprintf(stderr,"Cone '%s' EXT without path\n",str2);
      else if (DESB_LANG=='F')
      fprintf(stderr,"Cone '%s' EXT sans branche\n",str2);
      break ;


      default :
   
      if(DESB_LANG=='E')
      fprintf(stderr,"Unrecognized bug\n");
      else if (DESB_LANG=='F')
      fprintf(stderr,"Bug non identifiee\n");
      break ;
   }
fflush(stderr);
exit(-1);
}

/****************************************************************************
 *                         fonction dsbMessage();                           *
 ****************************************************************************/
void dsbMessage(code,str1)
int code ;

{
fprintf(stdout,"[MES] ");

   switch (code)
   {
   
   case 1 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Loading the figure '%s'\n",str1); 
   else if (DESB_LANG=='F')
   fprintf(stdout,"Chargement de la figure '%s'\n",str1);
   break ;

   case 2 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Flatening the figure \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Mise a plat de la figure\n");
   break ;

   case 3 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Transistor netlist checking \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Controle de la netlist transistor\n");
   break ;

   case 4 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Making gates \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Desassemblage en portes \n");
   break ;

   case 5 :

   if(DESB_LANG=='E')
   fprintf(stdout,"External connectors orientation \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Orientation des connecteurs externes\n");
   break ;

   case 6 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Dual gate detection \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"detection des portes duales\n");
   break ;

   case 7 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Latches detection \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"detection des latchs\n");
   break ;

   case 8 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Functional analysis \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Analyse fontionnelle \n");
   break ;

   case 9 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Gates caracterisation \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Caracterisation des portes \n");
   break ;

   case 10 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Checking the desb figure \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Controle de la figure desb \n");
   break ;

   case 11 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Master Slave detection\n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Detection des maitre-esclaves\n");
   break ;

   case 12 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Saving the figure '%s.deb' \n",str1);
   else if (DESB_LANG=='F')
   fprintf(stdout,"Sauvegarde de la figure '%s.deb'\n",str1); 
   break ;

   case 13 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Erasing the transistor netlist \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Destruction de la netlist transistor\n");
   break ;

   case 14 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Generating a hirachical netlist \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"generation de la netlist hierarchique\n");
   break ;

   case 15 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Generating the Vhdl Data Flow\n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Generation du Vhdl Data Flow\n");
   break ;

   case 16 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Reading file '%s.inf'\n",str1);
   else if (DESB_LANG=='F')
   fprintf(stdout,"Lecture du fichier '%s.inf'\n",str1);
   break ;

   case 17 :

   if(DESB_LANG=='E')
   fprintf(stdout,"Execution COMPLETED \n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"C'est FINI !!!\n");
   break ;

   default :
   if(DESB_LANG=='E')
   fprintf(stdout,"This is not a legal message !?! Cross fingers\n");
   else if (DESB_LANG=='F')
   fprintf(stdout,"Ceci n'est pas un message legal !?! Croisez les doigts\n");
   break ;   

   }

fflush(stdout);
}

/****************************************************************************
 *                         fonction dsbCrendu();                            *
 ****************************************************************************/
chain_list * dsbCrendu(code,str1,str2,num)
int code ;
char * str1 ;
char * str2 ;
int num     ;
{
char * res ;
char buff[200];
long n ;


   switch (code) 
   {
      case  1 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d loops of dual gates make an incomplete memory point\n",code,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d boucle de portes duales constituent un point memorisant incomplet\n",code,num);
      break ;

      case  4 :

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d transistors are used as a resistance\n",code,num);
      
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d transistors sont montes en resistance\n",code,num);
      break ;

      case  5 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d transistors are used as a diode\n",code,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d transistors sont montes en diode\n",code,num);
      break ;

      case 6 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d transistors are always off\n",code,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d transistors ne sont jamais passant\n",code,num);
      break ;

      case 7 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d transistors are used as capacitance\n",code,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d transistors sont montes en capacite\n",code,num);
      break ;

      case 8 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d transistors are not connected\n",code,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d transistors ne sont pas connectes\n",code,num);
      break ;

      case 9 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d transistors are not used \n",code,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d transistors ne sont pas utilises\n",code,num);
      break ;

      case 12 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d conflicts may occur in the circuit\n",code,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d signaux peuvent etre conflictuels\n",code,num);
      break ;

      case 13 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d signals may be HZ\n",code,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d signaux peuvent etre HZ\n",code,num);
      break ;

      case 14 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[WAR %d] %d loops between two latchs detected\n",code,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[WAR %d] %d latches reboucles detectes\n",code,num);
      break ;

     /*-------------------------------------------------+
     |               ERREURS                            |
     +-------------------------------------------------*/
      case 102 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[ERR %d] %d '_s' error in names of signal\n",code-100,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[ERR %d] %d erreurs de suffixage '_s'\n",code-100,num);
      break ;
      
      case 103 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[ERR %d] %d Transistor gate signals are not driven \n",code-100,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[ERR %d] %d signaux de grille de transistors ne sont pas drives\n",code-100,num);
      break ;

      case 104 : 

      if(DESB_LANG=='E')
      sprintf(buff,"[ERR %d] %d loops in the gate netlist \n",code-100,num);
      else if (DESB_LANG=='F')
      sprintf(buff,"[ERR %d] %d boucles dans la netlist de portes\n",code-100,num);
      break ;

      default :
      if(DESB_LANG=='E')
      sprintf(buff,"Unrecognized type of warning\n");
      else if (DESB_LANG=='F') 
      sprintf(buff,"Type de warning non reconnu\n");
      break ;

   }

res = (char *)malloc(strlen(buff)+1);
strcpy (res,buff);
DESB_RECAP_ERR=addchain(DESB_RECAP_ERR,(void*)res);
}
