/************************************************************************************/
/************************************************************************************/
/**				                				   **/
/**			 $$$     $$   $$    $$$$$                                  **/
/**			$   $    $ $ $ $   $     $				   **/
/**            	 	$$$$$    $  $  $   $                                       **/
/**			$   $    $     $   $   $$$                                 **/
/**             	$   $    $     $    $$$$$                                  **/ 
/**										   **/
/**		 	ARRAY MULTIPLIER GENERATOR				   **/
/**										   **/
/**										   **/
/**										   **/
/** VERSION : 1.0 (Juillet 93)							   **/
/** AUTHOR  : Philippe ROYANNEZ							   **/
/**										   **/
/************************************************************************************/
/************************************************************************************/

/* Inclusion des fichiers header 						    */

# include<genlib.h>
# include<stdio.h>
# include<ctype.h>
# include<string.h>
# include<math.h>

extern void amg ();

/* definition des constantes     						    */

#define TRUE  		(1)		/* valeur booleenne VRAI		    */
#define FALSE 		(0)		/* valeur booleenne FAUX		    */
#define TAILLE_MAX	(40)		/* nb max de colonne de la partie ARRAY	    */ 
#define alim_step	(5)		/* Rappel d'alim tout les 5 MUX+CSA	    */


				

/* definition des macros	                                                    */

#define x_max(a,b)	((a)>(b)?(a):(b))	/* rend le max de  a et b	    */
#define x_min(a,b)	((a)>(b)?(b):(a))	/* rend le min de  a et b	    */ 
#define round(a)        (2*((a+1)/2))		/* rend a si il est pair,a+1 sinon  */


/* definition des variables globales 	                                            */

long  	op1=8,op2=8;			/* Taille temporaire des oprandes	    */
int 	t0=0,t1=0,n=0;			/* Parametres pour l'emplacement du pipeline*/
int 	layout,vhdl,data,icon,patterns;	/* vues generes				    */
int	virtual,msb0;			/* parametres pour les connecteurs    	    */
char	*name;				/* nom du bloc genere		    	    */


/************************************************************************************/
/************************************************************************************/
/*                      Jeu de "MAIN" jeu de vilain                                 */
/************************************************************************************/
/************************************************************************************/
int main (argc,argv)
int argc;
char *argv[];
{
int 	i;
/*
PRINTF ("\n\n");
PRINTF ("		   @@@@@@   @@@      @    @@@@@@@   	\n");
PRINTF ("		 @@      @  @@@@    @@   @@      @   	\n");
PRINTF ("		 @@      @  @@ @@  @ @  @@       @     	\n");
PRINTF ("		 @@      @  @@  @@@  @  @@            	\n");
PRINTF ("		 @@      @  @@   @   @  @@             	\n");
PRINTF ("		 @@@@@@@@@  @@       @  @@     @@@  	\n");
PRINTF ("		 @@      @  @@       @  @@       @    	\n");
PRINTF ("		 @@      @  @@       @   @@      @   	\n");
PRINTF ("	 	@@@      @ @@@       @    @@@@@@@       \n");

PRINTF ("\n");
PRINTF ("\n");
PRINTF ("		Chaine CAO & VLSI	AMG			\n");
PRINTF ("		PRODUIT: AMG (Array Multiplier Generator) 1.0	\n");
PRINTF ("		(c) copyright 1993 labo MASI equipe CAO & VLSI	\n");
PRINTF ("		Tous droits reserves				\n");
PRINTF (" 		Support : e-mail cao-vlsi@masi.ibp.fr         \n\n");
*/
alliancebanner("AMG", AMG, "Array Multiplier Generator", "93", ALC);

/********************************************************************************************************/
/*                 TRAITEMENT DES PARAMETRES ET DES OPTIONS             				*/
/********************************************************************************************************/
if ( argc <= 2 ) 
	{
	fprintf ( stderr, "Usage : amg size1 size2 [-t0] [-t1] [-n=p] [-msb0] [-virtual] [-layout -icon -vhdl -patterns -datasheet] [-o BlockName] \n");
	fprintf ( stderr, "\tsize1		= First operand size				\n");
	fprintf ( stderr, "\tsize2		= Second operand size				\n");
	fprintf ( stderr, "\t-t0		: Place a pipeline register after the DNC part	\n");
	fprintf ( stderr, "\t-t1		: Place a pipeline register before the CLA part	\n"); 
	fprintf ( stderr, "\t-n=p		: Place p pipeline registers in the ARRAY part	\n"); 
	fprintf ( stderr, "\t-msb0		: Force a BIG ENDIAN indexation			\n");
	fprintf ( stderr, "\t-virtual		: Keep virtual connectors			\n");
	fprintf ( stderr, "\tlayout icon vhdl			 				\n");
	fprintf ( stderr, "\tpatterns datasheet	: Specifie the generated views			\n");
	fprintf ( stderr, "\t-o BlocName	: Specifie the name of the generated block	\n\n");

	exit(1);
	}

	op1 = atoi ( argv[ 1 ] );	/* les deux premiers arguments sont obligatoirement		*/
	op2 = atoi ( argv[ 2 ] );	/* les tailles des operandes					*/
	
	layout =FALSE;		/* par defaut la vue layout n'est pas generee				*/	
	icon   =FALSE;		/* par defaut la vue icon n'est pas generee				*/	
	vhdl   =FALSE;		/* par defaut la vue vhdl n'est pas generee				*/	
	data   =FALSE;		/* par defaut la vue data n'est pas generee				*/	
	t0=t1=n=FALSE;		/* par defaut on ne pipeline pas du tout				*/
	virtual=FALSE;		/* par defaut les connecteurs sont durcit				*/
	msb0   =FALSE;		/* par defaut index=poids binaire					*/

	for (i=3;i<argc;i++)
	{
	if (strcmp (argv[i],       "-layout")==0)	layout  =TRUE;	/* produit le layout		*/
	else if (strcmp (argv[i],         "-vhdl")==0)	vhdl    =TRUE;	/* produit le vhdl .vbe		*/
	else if (strcmp (argv[i],    "-datasheet")==0)	data    =TRUE;	/* produit la data-sheet	*/
	else if (strcmp (argv[i],         "-icon")==0)	icon    =TRUE;	/* produit la vue icone		*/
	else if (strcmp (argv[i],      "-patterns")==0)	patterns=TRUE;	/* produit la vue icone		*/
	else if (strcmp (argv[i],          "-t0")==0)	t0      =TRUE;	/* met un reg apres le cnd	*/
	else if (strcmp (argv[i],          "-t1")==0)	t1      =TRUE;	/* met un reg avant le cla	*/
	else if (strcmp (argv[i],     "-virtual")==0)	virtual =TRUE;	/* connecteurs virtuels		*/
	else if (strcmp (argv[i],        "-msb0")==0)	msb0    =TRUE;	/* index dans la convention bull*/
	else if (strncmp(argv[i],        "-n=",3)==0)	n=atoi(argv[i]+3);/* n reg dans la partie ARRAY */
	else if (strcmp (argv[i],"-o")==0)
		if(++i==argc)
		{
		fprintf( stderr, "A name must be specified after -o option\n" ) ;
		exit( 1 ) ;
		}
		else name=argv[i];
	else {fprintf (stderr,"Invalid option %s\n",argv[i]);exit (1);}
	}
if (name==(NULL)) name=NAME("m%dx%d",op1,op2);		/* par defaut le nom est du type m32x16		*/			
printf ("\n");
/******************* FIN DU TRAITEMENT DES OPTIONS ******************************************************/

amg ();
return 0;
}
/*_____________________________________________________________________*/
/*								       */
/* 			FIN DU MAIN				       */
/*_____________________________________________________________________*/
