#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define VRAI (1)
#define FAUX (0)

extern int	M, N;
extern char	*name;



void patpack ()
{
int 	i,j;
int 	cur_vect;
char 	filepat[16];
FILE 	*f;

/********************************************************************************/
/*			OUVERTURE DU FICHIER .pat				*/
/********************************************************************************/
sprintf (filepat,"%s.pat"  ,name);
f=fopen (filepat,"w");
fprintf (f,	"-- patterns for booth multiplier				\n");
fprintf (f,	"								\n\n");
fprintf (f,	"-- input / output list :					\n");
fprintf (f,	"in	a (%d downto 0) B;;;					\n",M-1);
fprintf (f,	"in	b (%d downto 0) B;;;					\n",N-1);
fprintf (f,	"out	p (%d downto 0) B;;;					\n\n",M+N-1);

fprintf (f,	"begin								\n");
fprintf (f,	"-- a"								);
nspace (f,M+1);
fprintf (f,	"b"								);
nspace (f,N+2);
fprintf (f,	"p\n\n"								);


for (i=0;i<M;i=i+1)
	{
	for (j=0;j<N;j=j+1)
		{
		fprintf (f,	" : "						);
		kron (f,i,M);
		fprintf (f,	"  "						);
		kron (f,j,N);
		fprintf (f,	"  ?"						);
		nstar (f,M+N);
		fprintf (f,	"  ;\n"						);
		}
	}
fprintf (f, "\nend;								\n");
fclose(f);
}



/********************************************************************/
/*        REMPLIT AVEC p zero					    */
/********************************************************************/
full0 (fpt,p)
int 	p;
FILE 	*fpt;
{
int k,count=1;
while ( (count++) < (p+1))	fprintf (fpt,"0");
}
/********************************************************************/



/********************************************************************/
/*        REMPLIT AVEC p  un					    */
/********************************************************************/
full1 (p,fpt)
int 	p;
FILE 	*fpt;
{
int k,count=1;
while ( (count++) < (p+1))	fprintf (fpt,"1");
}
/********************************************************************/



/********************************************************************/
/*			REMPLIT AVEC 0101			    */
/********************************************************************/
full5 (fpt)
FILE	*fpt;
{
fprintf (fpt,"0");
fprintf (fpt,"1");
fprintf (fpt,"0");
fprintf (fpt,"1");
}
/********************************************************************/



/********************************************************************/
/*			REMPLIT AVEC 1010			    */
/********************************************************************/
full10 (fpt)
FILE	*fpt;
{
fprintf (fpt,"1");
fprintf (fpt,"0");
fprintf (fpt,"1");
fprintf (fpt,"0");
}
/********************************************************************/


/********************************************************************/
/*			REMPLIT AVEC 0011			    */
/********************************************************************/
full3 (fpt)
FILE	*fpt;
{
fprintf (fpt,"0");
fprintf (fpt,"0");
fprintf (fpt,"1");
fprintf (fpt,"1");
}
/********************************************************************/






/*************************************************************************/
/* Ecrit 2^k en base 2 code sur size bits dans le fichier pointe par fpt */
/*************************************************************************/
kron (fpt,k,size)
FILE 	*fpt;
int	k;
int	size;
{
full0 (fpt,size-k-1);
fprintf (fpt,"1"					);				
full0 (fpt,k);
}
/************************************************************************/





/************************************************************************/
/*			ecrit n espaces					*/
/************************************************************************/
nspace (fpt,k)
FILE 	*fpt;
int 	k;
{
int count=1;
while (count++ < k+1) fprintf (fpt,	" ");
}
/************************************************************************/




/************************************************************************/
/*			ecrit n etoiles					*/
/************************************************************************/
nstar (fpt,k)
FILE 	*fpt;
int 	k;
{
int count=1;
while (count++ < k+1) fprintf (fpt,	"*");
}
/************************************************************************/
