#include <stdio.h>
#include <math.h>
#include <ctype.h>

extern long M,N;
extern int t0,t1,n;
extern int step1,step2;
extern char *name;

/************************************************************************************************/
#define h_slice         (60)            /* hauteur d'un slice dp_lib 				*/
#define l_dnc           (90)            /* longueur d'un DNC 					*/
#define l_mux           (77)            /* longueur d'un MUX de BOOTH 				*/
#define l_quatrois      (150)           /* longueur d' un cla 4 bits 				*/
#define l_out           (33)            /* longueur d'un rappel d'alim 				*/
#define l_cla           (400)           /* longueur d'un CLA 					*/
#define l_regt0         (249)           /* longueur d'un registre de type t0 			*/
#define l_regn          (415)           /* longueur d'un registre de type n 			*/
#define l_regt1         (249)           /* longueur d'un registre de type t1 			*/
/************************************************************************************************/
 

/************************************************************************************************/
/*		PARAMETRES CARACTERISTIQUES DE LA TECHNO CIBLE				 	*/
/************************************************************************************************/
#define str_tech        "1 micron " 	/* nom de la techno 					*/
#define ech             (0.875)         /* valeur relle du lambda 				*/
#define coef_ct_rsa     (0.538)		/* coefficient constant dans l'equation de rsa		*/
#define coef_ln_rsa     (2.34)		/* coefficient du log dans l'equation de rsa		*/
#define coef_cl_rsa     (1.84)		/* coefficient du Cload dans l'equation de rsa		*/
#define coef_ct_amg	(2.76)		/* coefficient constant dans l'equation amg non pipeline*/
#define coef_M_amg	(0.1)		/* coefficient de M  dans l'equation amg non pipeline	*/
#define coef_N_amg	(1.157)		/* coefficient de N  dans l'equation amg non pipeline	*/
#define coef_ct_tcy	(2.21)		/* coefficient constant dans l'equation du temp de cycle*/
#define coef_s1_tcy	(2.68)		/* coefficient de step1 dans l'equation du temp de cycle*/
#define coef_su_tcy	(0.4)		/* majorant de T set up dans l'equation du temp de cycle*/
#define coef_ct_tff	(3.0)		/* coefficient constant dans l'equation de Tflip-flop	*/
#define coef_M_tff	(0.037)		/* coefficient de M     dans l'equation de Tflip-flop	*/
#define coef_ct_cl4	(3.78)		/* Tpropa d'un cla 4 bit non charge		 	*/
#define coef_ct_DNC	(3.00)		/* coefficient constant dans l'equation Tpropa du DNC	*/
/************************************************************************************************/


/************************************************************************************************/
/*              GENERE LA DATA SHEET POUR UNE VERSION PIPELINE OU NON 				*/
/************************************************************************************************/
void datapack ()
{
int n_pipe;
n_pipe=t0+t1+n;
entete    ();
perf_surf ();
if (n_pipe == 0) perf_temp_comb ();
else             perf_temp_reg();
}
/*_________________________	FIN DE LA FONCTION PRINCIPALE	________________________________*/






/************************************************************************************************/
/*					  ENTETE 						*/
/************************************************************************************************/
entete ()
{
int n_pipe;
n_pipe=t0+t1+n;
system ("clear");
printf ("________________________________________________________________________\n");
printf ("|									|\n");
printf ("|		%dx%d	BOOTH 	MULTIPLIER DATA	- SHEET			|\n",M,N);
printf ("|									|\n");
printf ("|			\"ALLIANCE CAD - SYSTEM \" 			|\n");
printf ("|									|\n");
printf ("________________________________________________________________________\n");
printf (" \n");
printf (" \n");
printf (" \n");
printf ("\t* Technologie \t:\t %s 							\n\n",str_tech);
printf ("\t* BIT - Number \t:	 Multiplicator size is %d 			\n",M);
printf ("\t\t\t\t Multiplicand  size is %d 					\n",N);
printf ("\t\t\t\t Product size is       %d 					\n",M+N);
printf (" 									\n");
if (n_pipe==0)
printf ("\t* Function \t: Provide the multiplication : %dbitsx%dbits",M,N);
else
printf ("\t* Function \t: Provide the pipelined multiplication \" %dbitsx%dbits \"",M,N);
printf ("\n\n");
printf ("\t* Name \t\t: %s \n",name);
printf (" \n");
printf ("________________________________________________________________________\n\n");
}
/************************************************************************************************/
												 



/************************************************************************************************/
/*			PERFORMANCES SURFACIQUES						*/
/************************************************************************************************/
int perf_surf ()
{
float long_la,haut_la;          /* longueur et hauteur en lambda 				*/
float long_mi,haut_mi;          /* longueur et hauteur en micron 				*/
float surf_la,surf_reg;         /* surface en lamda carre 					*/
float surf_mi;                  /* surface en micron carre 					*/
long  nb_tr;			/* nombre de transistors					*/


long_la=l_dnc+l_mux+(N/2-1)*l_quatrois+l_cla+l_out+t0*l_regt0+n*l_regn+t1*l_regt1;
long_mi=long_la*ech;
haut_la=(M+2)*h_slice;
haut_mi=haut_la*ech;
surf_la=long_la*haut_la;
surf_mi=surf_la*(ech*ech);
nb_tr  = 0;
printf ("\t * AREA : \n");
printf ("		 _______________________________________________________ \n");
printf ("		|Heigh   	|With		|Area			| \n");
printf ("	________________________________________________________________ \n");
printf ("	|Lambda	|%7.0f	|%7.0f	|%7.0f		| \n",haut_la,long_la,surf_la);
printf ("	________________________________________________________________ \n");
printf ("	|Micron	|%7.1f	|%7.1f	|%7.1f		| \n",haut_mi,long_mi,surf_mi);
printf ("	________________________________________________________________ \n\n");
printf ("	Number of transistors: %d					 \n",nb_tr);
printf ("\n\n\n");
return 0;
}
/************************************************************************************************/




/************************************************************************************************/
/*			PERFORMANCES TEMPORELLES						*/
/************************************************************************************************/
int perf_temp_comb ()
{
float tpa_lsb;  /* temps de propagation d'un bit du multiplicande  vers une sortie poids faible */
float tpb_lsb;  /* temps de propagation d'un bit du multiplicateur vers une sortie poids faible */
float tpa_msb;  /* temps de propagation d'un bit du multiplicande  vers une sortie poids fort   */
float tpb_msb;  /* temps de propagation d'un bit du multiplicateur vers une sortie poids fort   */

tpb_lsb = coef_ct_amg + coef_M_amg*M + coef_N_amg*N + coef_ct_cl4;
tpa_lsb = tpb_lsb - (coef_ct_DNC + coef_M_amg*M);
tpb_msb = tpb_lsb + coef_ct_rsa + coef_ln_rsa*log((double)M+2)-coef_ct_cl4 ;
tpa_msb = tpb_msb - (coef_ct_DNC + coef_M_amg*M);
printf ("\t * TIMING : \n");
printf ("               ________________________________________________ \n");
printf ("               | Tpropa from ai       	| Tpropa from bi       	| \n");
printf ("       ________________________________________________________ \n");
printf ("       | lsb   | %7.2f + %7.2fCl	| %7.2f + %7.2fCl	| \n",tpa_lsb,coef_cl_rsa,tpb_lsb,coef_cl_rsa);
printf ("       ________________________________________________________ \n");
printf ("       | msb   | %7.2f + %7.2fCl	| %7.2f + %7.2fCl	| \n",tpa_msb,coef_cl_rsa,tpb_msb,coef_cl_rsa);
printf ("       _________________________________________________________ \n");
printf ("\n\n");
printf ("________________________________________________________________________\n\n");
return 0;
}
/*************************************************************************************************/



/************************************************************************************************/
/*			PERFORMANCES TEMPORELLES POUR UNE VERSION PIPELINE			*/
/************************************************************************************************/
int perf_temp_reg ()
{
float   tpa_in; /* temps d'entree pour un bit du multiplicande 					*/
float   tpb_in; /* temps d'entree pour un bit du multiplicande 					*/
float   tplsb_out;      /* temps de sortie pour un bit de poids faible 				*/
float   tpmsb_out;      /* temps de sortie pour un bit de poids fort 				*/
float   t_cycle;        /* temps de cycle interne 						*/
if (t0) tpa_in = 0.0;
else    tpa_in = coef_ct_tcy + coef_s1_tcy*step1 ;
tpb_in = coef_ct_DNC + coef_M_amg*M + tpa_in;
if (t1) {
        tplsb_out = coef_ct_cl4 ;
        tpmsb_out = coef_ct_rsa + coef_ln_rsa * log ((double)M+2) ;
        }
else    {
        tplsb_out = coef_ct_cl4 + coef_ct_tcy + coef_s1_tcy*step2;
        tpmsb_out = coef_ct_rsa + coef_ln_rsa * log ((double)M+2) + coef_ct_tcy + coef_s1_tcy*step2;
        }
t_cycle = coef_ct_tff + coef_M_tff*M + coef_ct_tcy + coef_s1_tcy * step1;
printf ("\t *TIMING : \n");
printf ("               ________________________________________________ \n");
printf ("               |	Tpropa from ai	|	Tpropa from bi	| \n");
printf ("       ________________________________________________________ \n");
printf ("       | Tin   |       %7.2f		|       %7.2f		| \n",tpa_in,tpb_in);
printf ("       ________________________________________________________ \n");
printf (" \n");
printf ("               ________________________________________________ \n");
printf ("               |	Tpropa to lsb	|	Tpropa to msb	| \n");
printf ("       ________________________________________________________ \n");
printf ("       | Tout  |    %7.2f+%7.2fCl	|   %7.2f+%7.2fCl	| \n",tplsb_out,coef_cl_rsa,tpmsb_out,coef_cl_rsa);
printf ("       ________________________________________________________ \n");
printf (" \n");
printf ("\t* Tcycle (intern) =%7.2f \n",t_cycle);
printf ("\n");
printf ("========================================================================\n\n");
printf ("\n\n");
return 0;
}
/*************************************************************************************************/
