/*
 * May 20, 1993
 * Copyright 1993 Rob Talley   (rob@aii.com)
 * This source code is freely redistributable and may be used for
 * any purpose. This copyright notice and the following copyright 
 * notice must be maintained intact. No warranty whatsoever is
 * provided. This code is furnished AS-IS as a component of the
 * larger work Copyright 1991 Lance Norskog and Sundry Contributors.
 * Much appreciation to ross-c  for his sampConv utility for SGI/IRIX
 * from where these methods were derived.
 */


/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */

/*
 * Sound Tools skeleton file format driver.
 */

#include <stdio.h>
#include "st.h"

/* Private data for TX16 file */
typedef struct tx16stuff {
	long	rest;			/* bytes remaining in sample file */
} *tx16_t;

IMPORT float volume, amplitude;
IMPORT int summary, verbose;

/*
 * Do anything required before you start reading samples.
 * Read file header. 
 *	Find out sampling rate, 
 *	size and style of samples,
 *	mono/stereo/quad.
 */
tx16startread(ft)
ft_t ft;
{
	int c;
	char filetype[7];
	char format;
	char sample_rate;
	long num_samp_bytes = 0;
	char dummy;


	tx16_t sk = (tx16_t) ft->priv;
	/* If you need to seek around the input file. */
	if (! ft->seekable)
		fail("tx16 input file must be a file, not a pipe");

	/* This is dumb but portable, just count the bytes til EOF */
        while ( getc(ft->fp) != EOF ) 
	    num_samp_bytes++; 
	num_samp_bytes -= 32;  /* calculate num samples by sub header size */
        fseek(ft->fp,0L,0);  /* rewind file */
	sk->rest = num_samp_bytes; /* set how many sample bytes to read */

	/* first 6 bytes are file type ID LM8953 */
	filetype[0] = getc(ft->fp);
	filetype[1] = getc(ft->fp);
	filetype[2] = getc(ft->fp);
	filetype[3] = getc(ft->fp);
	filetype[4] = getc(ft->fp);
	filetype[5] = getc(ft->fp);
	filetype[6] = '\0';
	for( c = 16; c > 0 ; c-- )   /* Discard next 16 bytes */
	    dummy = getc(ft->fp);    /* they have no meaning here */
	format = getc(ft->fp);
	sample_rate = getc(ft->fp);
	for( c = 8; c > 0 ; c-- )   /* Discard next 8 bytes */
	    dummy = getc(ft->fp);   /* they have no meaning here */
        /*
	 * We should now be pointing at start of raw sample data in file 
	 */

	/* Check to make sure we got a good filetype ID from file */
        report("tx16startread: Found header filetype %s",filetype);
        if(strcmp(filetype,"LM8953"))
	   fail("tx16startread: Invalid filetype ID in input file header, != LM8953");
	/*
	 * Set up the sample rate as indicated by the header
	 */

	 switch( sample_rate ) {
	 case 1:
	     ft->info.rate = 33000;
	     break;
	 case 2:
	     ft->info.rate = 50000;
	     break;
	 case 3:
	     ft->info.rate = 16000;
	     break;
         default:
	     fail("tx16startread: Invalid sample rate identifier found %d", (int)sample_rate);
         }
	report("tx16startread: Sample rate = %ld",ft->info.rate);

	ft->info.channels = 1 ; /* not sure about stereo sample data yet ??? */
	ft->info.size = WORD; /* this is close enough */
	ft->info.style = SIGN2;
}

/*
 * Read up to len samples from file.
 * Convert to signed longs.
 * Place in buf[].
 * Return number of samples read.
 */

tx16read(ft, buf, len) 
ft_t ft;
long *buf, len;
{
	tx16_t sk = (tx16_t) ft->priv;
	int done = 0;
	unsigned char uc1,uc2,uc3;
	unsigned short s1,s2;

        /*
	 * This gets called by the top level 'process' routine.
	 * We will essentially get called with a buffer pointer
	 * and a max length to read. Graciously, it is always
	 * an even amount so we don't have to worry about
	 * hanging onto the left over odd samples since there
	 * won't be any. Something to look out for though :-(
	 * We return the number of samples we read.
	 * We will get called over and over again until we return
	 *  0 bytes read.
	 */

	/*
	 * This is ugly but it's readable!
	 * Read three bytes from stream, then decompose these into
	 * two unsigned short samples. 
	 * TCC 3.0 appeared to do unwanted things, so we really specify
	 *  exactly what we want to happen.
	 * Convert unsigned short to long then shift up the result
	 *  so that the 12-bit sample lives in the most significant
	 *  12-bits of the long.
	 * This gets our two samples into the internal format which we
	 * deposit into the given buffer and adjust our counts respectivly.
         */
        for(done = 0; done < len; ) {
	    if(sk->rest <= 0) break; /* Finished reading from file? */
	    uc1 = (unsigned char)getc(ft->fp); /* read the three bytes */
	    uc2 = (unsigned char)getc(ft->fp);
	    uc3 = (unsigned char)getc(ft->fp);
	    sk->rest -= 3; /* adjust remaining for bytes we just read */
	    s1 = (unsigned short) (uc1 << 4) | (((uc2 >> 4) & 017));
	    s2 = (unsigned short) (uc3 << 4) | (( uc2 & 017 ));
	    *buf = (long) s1;
            *buf = (*buf << 20);
	    buf++; /* sample one is done */
	    *buf = (long) s2;
            *buf = (*buf << 20);
	    buf++; /* sample two is done */
	    done += 2; /* adjust converted & stored sample count */
	    }
	return done;
}

/*
 * Do anything required when you stop reading samples.  
 * Don't close input file! 
 */
tx16stopread(ft) 
ft_t ft;
{
}

tx16startwrite(ft) 
ft_t ft;
{
	tx16_t sk = (tx16_t) ft->priv;

	/* If you have to seek around the output file */
	if (! ft->seekable)
		fail("Output .tx16 file must be a file, not a pipe");

	/* If your format specifies any of the following info. */
	/*
	ft->info.rate = 
	ft->info.size = BYTE or WORD ...;
	ft->info.style = UNSIGNED or SIGN2 ...;
	ft->info.channels = 1 or 2 or 4;
	*/
	/* Write file header, if any */
	/* Write comment field, if any */
	
}

tx16write(ft, buf, len) 
ft_t ft;
long *buf, len;
{
	tx16_t sk = (tx16_t) ft->priv;
	register int datum;
	int abs;
	int done = 0;

	while(len--)
		putc((*buf++ >> 24) ^ 0x80, ft->fp);
	/* If you cannot write out all of the supplied samples, */
	/*	fail("tx16: Can't write all samples to %s", ft->filename); */
	
}

tx16stopwrite(ft) 
ft_t ft;
{
	/* All samples are already written out. */
	/* If file header needs fixing up, for example it needs the */
 	/* the number of samples in a field, seek back and write them here. */
}

