#include "cs.h"			/*						SOUNDIO.C	*/
#include "soundio.h"

	char	sfout[60];
static	char	outbuf[BUFSIZE];
static	short	*outbufp = (short *) outbuf;	    /* (init for nosound)   */
static	float	*floutbufp = (float *) outbuf;	    /*	    ditto	    */
static	int	sfd, sfopen = 0, bufrem = 4;	    /* (real set in sfinit) */
static	float	fzero = 0.;

extern	float	esr;
extern	float	*spout, maxamp[], omaxamp[];
extern  long	maxloc[], omaxloc[], rngcnt[];
extern	short	rngflg;
extern	int	nspout, nrecs, nchnls, ksmps;
extern	int	floatout, sampsize, bufsmps;
extern	int	remotein, remoteout;
extern	char	errmsg[], *buildsfname();

sfinit()					/* init for sound out */
{						/* (not called if nosound) */
register SFHEADER *sfh;
register char	*sfname, *wherecolon;
extern	char	*outfile;

	sfname = buildsfname((outfile != NULL) ? outfile : DEFAULT_NAME);
	if (index(sfname,':') != NULL) 			/* if : in name,     */
		sfd = rsfopen(sfname,'>');		/*  open remote file */
	else if ((sfd = open(sfname,O_TRUNC|O_CREAT|O_RDWR,PMODE)) < 0)
		dies("sfinit: cannot open %s", sfname);
#ifdef SFIRCAM					/* for soundfiles w. headers */
	sfh = (SFHEADER *)outbuf;			/* positn header blk */
	sfsrate(sfh) = esr;				/*   at begin outbuf */
	sfchans(sfh) = nchnls;				/* & assgn headrvals */
	sfclass(sfh) = (floatout ? SF_FLOAT : SF_SHORT);
	sfmagic(sfh) = SF_MAGIC;
	outbufp = (short *) (outbuf+sizeof(SFHEADER));	/* step over hdrblk */
	floutbufp = (float *) outbufp;			/*  for fix & float */
	bufrem = (BUFSIZE - sizeof(SFHEADER)) / sampsize;
#else
	outbufp = (short *) outbuf;
	floutbufp = (float *) outbuf;
	bufrem = BUFSIZE / sampsize;
#endif
	sfopen = 1;
 	printf("writing %s to %s\n", (floatout ? "floats":"shorts"), sfname);
	strcpy(sfout, sfname);
}

fixtran()				/* fix spout vals and put in outbuf */
{					/*	write buffer when full	    */
register float	*sp, *maxampp;
register long   longsmp, *maxlocp, *rngp;
register int	n, spoutrem;
	float	absamp;

	sp = spout;			/* adr spout	*/	
	spoutrem = nspout;		/* smps to go	*/
	maxampp = maxamp;
	maxlocp = maxloc;

nchk:	if ((n = spoutrem) > bufrem)	/* if nspout remaining > buf rem, */
		n = bufrem;		/*	prepare to send in parts  */
	spoutrem -= n;
	bufrem -= n;
	do {
		if ((longsmp = *sp) >= 0) {		/* +ive samp:	*/
			if (*sp > *maxampp) {		/*  maxamp this seg  */
				*maxampp = *sp;		/*  and its location */
				*maxlocp = nrecstobytes(nrecs)
						+ ((char *) outbufp - outbuf);
			}
			if (longsmp > 32767) {		/* out of range?     */
				longsmp = 32767;	/*   clip and report */
				rngp = rngcnt + (maxampp - maxamp);
				(*rngp)++;
				rngflg = 1;
			}
		}
		else {					/* ditto -ive samp */
			if ((absamp = -*sp) > *maxampp) {
				*maxampp = absamp;
				*maxlocp = nrecstobytes(nrecs)
						+ ((char *) outbufp - outbuf);
			}
			if (longsmp < -32768) {
				longsmp = -32768;
				rngp = rngcnt + (maxampp - maxamp);
				(*rngp)++;
				rngflg = 1;
			}
		}
		*outbufp++ = (short) longsmp;
		sp++;
		if (nchnls > 1) {
			maxlocp++;
			if (++maxampp - maxamp >= nchnls) {
				maxlocp = maxloc;
				maxampp = maxamp;
			}
		}
	} while (--n);
	if (!bufrem) {
		if (sfopen) {
			if ((n = write(sfd,outbuf,BUFSIZE)) < BUFSIZE)
				sounderr('w',n);
			nrecs++;
		}
		outbufp = (short *) outbuf;
		bufrem = bufsmps;
		if (spoutrem) goto nchk;
	}
}

floatran()				/* send float spout vals to outbuf */
{					/*	write buffer when full	    */
register float	*sp, *maxampp;
register long	*maxlocp;
register int	n, spoutrem;
register float	absamp;

	sp = spout;			/* adr spout	*/	
	spoutrem = nspout;		/* smps to go	*/
	maxampp = maxamp;
	maxlocp = maxloc;

nchk:	if ((n = spoutrem) > bufrem)	/* if nspout remaining > buf rem, */
		n = bufrem;		/*	prepare to send in parts  */
	spoutrem -= n;
	bufrem -= n;
	do {
		if ((absamp = *sp) < 0.)
			absamp = -absamp;
		if (absamp > *maxampp) {	/*  maxamp this seg  */
			*maxampp = absamp;	/*  and its location */
			*maxlocp = nrecstobytes(nrecs)
					+ ((char *) floutbufp - outbuf);
		}
		*floutbufp++ = *sp++;
		if (nchnls > 1) {
			maxlocp++;
			if (++maxampp - maxamp >= nchnls) {
				maxlocp = maxloc;
				maxampp = maxamp;
			}
		}
	} while (--n);
	if (!bufrem) {
		if (sfopen) {
			if ((n = write(sfd,outbuf,BUFSIZE)) < BUFSIZE)
				sounderr('w',n);
			nrecs++;
		}
		floutbufp = (float *) outbuf;
		bufrem = bufsmps;
		if (spoutrem) goto nchk;
	}
}

zerotran(kcnt)			/* copy kcnt zerospouts to short soundbuf, */
 int kcnt;			/*	sending buffer whenever full	 */
{
register int	n, smpsrem, clearcnt = 0;

	if (!sfopen)  return;
	smpsrem = nspout * kcnt;	/* calculate total smps to go	*/
nchk:	if ((n = smpsrem) > bufrem)	/* if smps remaining > buf rem, */
		n = bufrem;		/*	prepare to send in parts  */
	smpsrem -= n;
	bufrem -= n;
	if (clearcnt < bufsmps) {
		clearcnt += n;		/* clear buf only till clean */
		do *outbufp++ = (short) 0;
		while (--n);
	}
	else outbufp += n;
	if (!bufrem) {
		if ((n = write(sfd,outbuf,BUFSIZE)) < BUFSIZE)
			sounderr('w',n);
		nrecs++;
		outbufp = (short *) outbuf;
		bufrem = bufsmps;
		if (smpsrem) goto nchk;
	}
}

fzerotran(kcnt)			/* copy kcnt zerospouts to float soundbuf, */
 int kcnt;			/*	sending buffer whenever full	 */
{
register int	n, smpsrem, clearcnt = 0;

	if (!sfopen)  return;
	smpsrem = nspout * kcnt;	/* calculate total smps to go	*/
nchk:	if ((n = smpsrem) > bufrem)	/* if smps remaining > buf rem, */
		n = bufrem;		/*	prepare to send in parts  */
	smpsrem -= n;
	bufrem -= n;
	if (clearcnt < bufsmps) {
		clearcnt += n;		/* clear buf only till clean */
		do *floutbufp++ = fzero;
		while (--n);
	}
	else floutbufp += n;
	if (!bufrem) {
		if ((n = write(sfd,outbuf,BUFSIZE)) < BUFSIZE)
			sounderr('w',n);
		nrecs++;
		floutbufp = (float *) outbuf;
		bufrem = bufsmps;
		if (smpsrem) goto nchk;
	}
}

static SFCODE	ampcode = {
	SF_MAXAMP,
	sizeof(SFMAXAMP) + sizeof(SFCODE)
}; 

sfclose()
{
register int	nb, n;

	SFHEADER hd;
	SFMAXAMP sfm;

	if (!sfopen) return;
	if ((nb = (bufsmps - bufrem) * sampsize) > 0) {
		if ((n = write(sfd,outbuf,nb)) < nb)
			sounderr('w',n);
		nrecs++;
	}
#ifdef SFIRCAM
	if (!remoteout)		/* if perf is writing sound over the net,    */
	{			/* no backward seeks, so omit the following: */
		lseek(sfd,0,0);
		rheader(sfd,&hd);		/* Update header with maxamp */
		for(n = 0; n < 4; n++) {
			sfmaxamp(&sfm,n) = omaxamp[n];
				/* First buf included header so subtract it */
			sfmaxamploc(&sfm,n) = (omaxloc[n]-sizeof(SFHEADER))>>1;
		}
		sfmaxamptime(&sfm) = time(0);
		putsfcode(&hd,&sfm,&ampcode);
		lseek(sfd,0,0);
		wheader(sfd,&hd);
	}
#endif
	close(sfd);
}

sndinset(p)				/* init for soundin, and gen01	*/
 register SOUNDIN *p;			/* all reads kept on		*/
{					/*   INBUFSIZ (4K?) boundaries	*/
register SFHEADER *sfh;
register int	n, hdrsize, insampsize;
extern	int	inerrcnt;
	char	*sfname, numstr[10];

	if (p->infd > 0)
		return;
	if ((n = p->OUTCOUNT) != 1 && n != 2 && n != 4) {
		sprintf(errmsg,"illegal no of receiving channels");
		goto errtn;
	}
	sfname = buildsfname(SOUNDIN_NAME);
	sprintf(numstr, "%d", (int) *p->ifilno);
	strcat(sfname,numstr);
	if (index(sfname,':') != NULL)			/* open infil remote */
		p->infd = rsfopen(sfname,'<');
	else if ((p->infd = open(sfname,O_RDONLY)) < 0) {	 /* or local */
		sprintf(errmsg,"soundin cannot open %s",sfname);
		goto errtn;
	}
	fdrecord(&p->infd);				 /* log the fd store */
	p->endfile = 0;					 /* & begin fileread */
	if ((n = readin(p->infd,p->inbuf,INBUFSIZ)) == 0)
		sounderr('r',n);
	p->floatin = 0;					/* set default vals  */
	insampsize = 2;
	p->chanbytes = insampsize * p->OUTCOUNT;
	hdrsize = 0;
#ifdef SFIRCAM
	sfh = (SFHEADER *) p->inbuf;			/* & chk headercodes */
	if (sfmagic(sfh) == SF_MAGIC) {
		if (sfsrate(sfh) != esr) {
			sprintf(errmsg,"%s sr != orch sr",sfname);
			warning(errmsg);
		}
		if (sfchans(sfh) != p->OUTCOUNT) {
			sprintf(errmsg,"soundin cells != %s chnls",sfname);
			warning(errmsg);
		}
		if (sfclass(sfh) == SF_FLOAT) {
			p->floatin = 1;
			insampsize = 4;
		}
		p->chanbytes = insampsize * sfchans(sfh);
		hdrsize = sizeof(SFHEADER);
	}
	else if (BYTREVL(sfmagic(sfh)) == SF_MAGIC) {
		sprintf(errmsg,"%s bytes are in wrong order",sfname);
		goto errtn;
	}
	else {
		sprintf(errmsg,"%s not a soundfile, assuming floats",sfname);
		warning(errmsg);
		p->floatin = 1;
		p->chanbytes = 4 * p->OUTCOUNT;
	}
#endif
	p->inbufp = p->inbuf + hdrsize;			    /* step ovr hdr */
	p->bufend = p->inbuf + n;			    /* record endbuf */
	if (*p->iskptim > 0.) {				/* for pos skiptime: */
		int	nsamps, nbytes, seekbytes;
		nsamps = *p->iskptim * esr;		/* calc bytes to skip*/
		nbytes = nsamps * p->chanbytes + hdrsize;
		p->inbufp = p->inbuf + nbytes;
		if (p->inbufp >= p->bufend) {	   /* if not already in buf: */
			seekbytes = nbytes & (-INBUFSIZ);  /* mask to begin */
			if ((n = seekbytes/INBUFSIZ) > 1) {
				if (remotein)		/* remote? spin read */
					while (--n)	/*  to reqd boundary */
					     readin(p->infd,p->inbuf,INBUFSIZ);
				else if (lseek(p->infd,seekbytes,L_SET) < 0)
					die("soundin seek error");
			}				/* now read for real */
			if ((n = readin(p->infd,p->inbuf,INBUFSIZ)) == 0)
				p->endfile = 1;
			else {
				nbytes -= seekbytes;	 /* then pnt to samp */
				p->inbufp = p->inbuf + nbytes;
				p->bufend = p->inbuf + n;
			}
		}
	}
	if (p->inbufp >= p->bufend)
		p->endfile = 1;
	return;

errtn:	if (p->h.insdshead == NULL) {
		printf(errmsg);			/* error from gen01 call */
		putchar('\n');
		inerrcnt++;
	}
	else initerror(errmsg);			/* else from instr soundin */
}

soundin(p)
 register SOUNDIN *p;
{
register short	nsmps;
register float	*r1, *r2, *r3, *r4;
	int	chnsout, n, ntogo;

	r1 = p->r1;
	r2 = p->r2;
	r3 = p->r3;
	r4 = p->r4;
	chnsout = p->OUTCOUNT;
	ntogo = ksmps;
	if (p->endfile)
		goto filend;
	nsmps = (p->bufend - p->inbufp) / p->chanbytes;
	if (nsmps > ksmps)
		nsmps = ksmps;
	ntogo -= nsmps;
	if (p->floatin) {
		register float *inbufp = (float *)p->inbufp;
floats:		switch(chnsout) {
		case 1:	do {	*r1++ = *inbufp++;
			} while (--nsmps);
			break;
		case 2:	do {	*r1++ = *inbufp++;
				*r2++ = *inbufp++;
			} while (--nsmps);
			break;
		case 4:	do {	*r1++ = *inbufp++;
				*r2++ = *inbufp++;
				*r3++ = *inbufp++;
				*r4++ = *inbufp++;
			} while (--nsmps);
		}
		if ((char *)inbufp >= p->bufend) {
			if ((n = readin(p->infd,p->inbuf,INBUFSIZ)) == 0) {
				p->endfile = 1;
				if (ntogo) goto filend;
				else return;
			}
			inbufp = (float *) p->inbuf;
			p->bufend = p->inbuf + n;
			if (ntogo > 0) {
				if ((nsmps = n / p->chanbytes) > ntogo)
					nsmps = ntogo;
				ntogo -= nsmps;
				goto floats;
			}
		}
		p->inbufp = (char *) inbufp;
	}
	else {
		register short *inbufp = (short *)p->inbufp;
shorts:		switch(chnsout) {
		case 1:	do {	*r1++ = (float) *inbufp++;
			} while (--nsmps);
			break;
		case 2:	do {	*r1++ = (float) *inbufp++;
				*r2++ = (float) *inbufp++;
			} while (--nsmps);
			break;
		case 4:	do {	*r1++ = (float) *inbufp++;
				*r2++ = (float) *inbufp++;
				*r3++ = (float) *inbufp++;
				*r4++ = (float) *inbufp++;
			} while (--nsmps);
		}
		if (inbufp >= (short *)p->bufend) {
			if ((n = readin(p->infd,p->inbuf,INBUFSIZ)) == 0) {
				p->endfile = 1;
				if (ntogo) goto filend;
				else return;
			}
			inbufp = (short *) p->inbuf;
			p->bufend = p->inbuf + n;
			if (ntogo > 0) {
				if ((nsmps = n / p->chanbytes) > ntogo)
					nsmps = ntogo;
				ntogo -= nsmps;
				goto shorts;
			}
		}
		p->inbufp = (char *) inbufp;
	}
	return;

filend:	nsmps = ntogo;
	switch(chnsout) {			/* if past end of file, */
	case 1:	do *r1++ = fzero;		/*    move zeros	*/
		while (--nsmps);
		break;
	case 2:	do {	*r1++ = fzero;
			*r2++ = fzero;
		} while (--nsmps);
		break;
	case 4:	do {	*r1++ = fzero;
			*r2++ = fzero;
			*r3++ = fzero;
			*r4++ = fzero;
		} while (--nsmps);
	}
}

sounderr(rw,nbytes)		/* report soundfile read/write error	*/
 char rw;			/* especially to check on remote r/w's	*/
 int nbytes;
{
	sprintf(errmsg,"soundfile error.  %s returned bytecount of %d, not %s",
		(rw == 'r')? "read" : "write",
		nbytes,
		(rw == 'r')? "INBUFSIZ" : "BUFSIZE" );
	die(errmsg);
}
