#include "sysdep.h"				/*				SFCODES.C	*/
#include <stdio.h>
#include <sys/file.h>
#include <local/sfheader.h>

/* Find location in header for the coded information. 
   Return a pointer to the beginning of the SFCODE structure not
   to the information structure itself. The srate, number of channels, magic
   number, number of bytes per channel are NOT coded via these routines. */

static bcopy(b1, b2, len)
 register char	*b1, *b2;
 register int	len;
{
	if (len <= 0)  return;
	do  *b2++ = *b1++;
	while (--len);
}
   
char *getsfcode(hd,code)
	SFHEADER *hd;
{
	register char *sfc;
	register SFCODE *sp;
	char *hdend = (char *) hd + sizeof(SFHEADER);

	sfc = &sfcodes(hd); 
	while(sfc < hdend) {
		sp = (SFCODE *) sfc;
		if(sp->code == code)
			return(sfc);
		if(sp->code == SF_END)
			break;
		/* Catch possible wrap around on stack from bad header */
		/* or a zero struct size from bad header */
		if(sp->bsize == 0 || sfc + sp->bsize < &sfcodes(hd))
			break;
		else
			sfc += sp->bsize;
	}
	return(NULL);
}

SFCODE endcode = {
	SF_END,
	sizeof(SFCODE)
} ;

putsfcode(hd,ptr,codeptr)
	SFHEADER *hd;
	char *ptr;
	SFCODE *codeptr;
{
	register char *sfc;
	register SFCODE *sp;
	int wasendcode = 0;
	char *hdend = (char *) hd + sizeof(SFHEADER);

	sfc = &sfcodes(hd); 
	while(sfc < hdend) {
		sp = (SFCODE *) sfc;
		if(sp->code == codeptr->code)
			break;
		if(sp->code == SF_END) {
			wasendcode = 1;
			break;
		}
		/* Catch possible wrap around on stack from bad header */
		if(sp->bsize == 0 || sfc + sp->bsize < (char *) hd) 
			sp->code = SF_END; /* Force an end */
		else
			sfc += sp->bsize;
	}
	
	/* No space left */
	if(sfc + codeptr->bsize > hdend)
		return(-1);

	if(!wasendcode)  /* Not a new one */
		if(codeptr->bsize != sp->bsize) /* Size changed */
			return(-1);

	bcopy((char *) codeptr, sfc, sizeof(SFCODE));
	bcopy(ptr, sfc + sizeof(SFCODE), codeptr->bsize - sizeof(SFCODE));

	if(wasendcode) 
		bcopy(&endcode,sfc + codeptr->bsize,sizeof(endcode));

	return(0);
}
