.TH LPC EMS
.SH NAME
anallpc, ptrack, lpconcat, lpdump, lpinfed, lpinfo \- Paul Lansky's software for linear predictive analysis and pitch tracking
.SH SYNOPSIS
.B anallpc 
[flag][option] ... [soundfile]
.br
.B ptrack 
[flag][option] ... [soundfile]
.br
.B lpconcat
.br
.B lpdump 
filename
.br
.B lpinfed 
[-e editor] [-f outfile] filename
.br
.B lpinfo 
filename ...
.SH DESCRIPTION
.PP
.I anallpc 
and
.I ptrack
perform linear predictive and pitch tracking analyses respectively on
a monaural shortsam sound input.
.I lpconcat
combines the outputs of 
.I anallpc
and
.I ptrack
in a manner suitable for use in a 
.I Csound(local)
instrument.
.I lpdump
displays the analysis data of an lpfile in human readable form.
.I lpinfo
and
.I lpinfed
respectively display and edit the contents of an lpfile's header,
which contains various analysis parameters.
.PP
Each command is described in more detail below.
.SH ANALLPC
.PP
.I anallpc
performs linear predictive analysis on a monaural 16bit fixed point (shortsam)
sound sample stream, and can be invoked in two forms.  The first form is:
.sp
.I "anallpc [flag][option] ... [soundfile]"
.sp
Command line options for this form are as follows:
.sp
.nf
.RS .25i
-rSRATE           Sampling rate of sound input.  In the default case,
                    this is read from the soundfile header, unless the
                    -H flag is specified (see below) in which case the
                     default is 20000 Hz.
-pNPOLES          Number of poles for analysis.  Default is 34 poles,
                    which is also the maximum allowed.
-iINTERFRAMEOFSET Offset in samples between analysis frames.  Default 
                    200 samples, maximum is 250 samples.
                    The actual analysis framesize will be twice this number.
-sSKIPTIME        Initial seconds of sound to skip over.  Default 0.0.
-dDURATION        Duration in seconds to analyze.  Default 1.0.
-oOUTPUTFILE      Name for the analysis output file.  If not specified
                    analysis data is written to the stdout stream.
                    Should be of the form lp.n for Csound compatibility.
-CCOMMENT_STRING  Text for the comment field of the lpfile header.
                    In the default case this is left empty.
-H                If present, specifies that no soundfile header is 
                    present.  In this case, SRATE is taken from -r 
                    flag or default (see above).
soundfile         Input mono shortsam soundfile.  The value of the
                    environment variable SFDIR is searched if the
                    soundfile name doesn't begin with '.' or '/'.
                    In the default case, read from the stdin stream.
.RE
.fi
.PP
Note that options must follow their respective flags without any
intervening space, and that 
.B soundfile
must occur last (if at all) on the command line ( see
.I crack(carl)
).
.PP
On systems that do not use an IRCAM-type UNIX soundfile system,
the 
.B -H 
flag is not implemented.
Some systems support remote soundfile access.  Specify 
.B soundfile
in the form:
.B sitename:pathname.
.PP
In the second form of invocation:
.sp
.I "anallpc -q"
.sp
the user is queried for all the relevant options.
There are no default settings in this case (every query requires a
non-empty response) and 
.B OUTPUTFILE
and
.B soundfile
cannot be the stdout or stdin streams.
.SH PTRACK
.PP
.I ptrack
performs a pitch analysis on a monaural shortsam soundfile.
It can also be invoked in either of two forms:
.sp
.I ptrack [flag][option] ... [soundfile]
.sp
with arguments as follows:
.sp
.nf
.RS .25i
-rSRATE           Sampling rate of sound input.  In the default case,
                    this is read from the soundfile header, unless the
                    -H flag is specified (see below) in which case the
                     default is 20000 Hz.
-fFRAMESIZE       Analysis framesize in samples.  Default, maximum 
                    is 350 samples.  Should be able to contain one
                    period of the expected pitch.
-iINTERFRAMEOFSET The offset in samples between successive frames.
                    Default 200.
-hHIGHPITCH       High pitch estimate in cps (default 1000).
-lLOWPITCH        Low pitch estimate in cps (default 100).
                    The better the HIGHPITCH and LOWPITCH estimates are, 
                    the better the quantization will be in the analysis.
-sSKIPTIME        Initial seconds of sound to skip over.  Default 0.0.
-dDURATION        Duration in seconds to analyze.  Default 1.0.
-oOUTPUTFILE      Name for the analysis output file.  If not specified
                    analysis data is written to the stdout stream.
-H                If present, specifies that no soundfile header is 
                    present.  In this case, SRATE is taken from -r 
                    flag or default (see above).
soundfile         Input mono shortsam soundfile.  The value of the
                    environment variable SFDIR is searched if the
                    soundfile name doesn't begin with '.' or '/'.
                    In the default case, read from the stdin stream.
.RE
.fi
.PP
(See the notes above for 
.I anallpc
concerning commandline options and remote soundfile access etc.)
.PP
.PP
In the second form of invocation:
.sp
.I "ptrack -q"
.sp
the user is queried for all the relevant options.
There are no default settings in this case (every query requires a
non-empty response) and 
.B OUTPUTFILE
and
.B soundfile
cannot be the stdout or stdin streams.
.SH LPCONCAT
.PP
.I lpconcat
merges the pitch data obtained from
.I ptrack
into the lpc data file obtained from
.I anallpc,
filling in
the slot left empty for the pitch stuff in the latter file.
.PP
Usage is:
.sp
.I "lpconcat [flag][option] anallpcfile ptrackfile"
.sp
with [flag][option] from among:
.sp
.nf
.RS .25i
-pPFRAMERATE  Frame rate of ptrack analysis. Use SRATE divided by 
                INTERFRAMEOFSET from ptrack analysis run.  The default 
                setting of 100 agrees with the default SRATE and 
                INTERFRAMEOFSET settings.
-bBEGINFRAME  Default 0 (first frame).
-eENDFRAME    Default -1 (last frame).
              These specify the frame numbers within which the pitch data
                will be inserted into the analysis data (0 is the first 
                frame).  An ENDFRAME of -1 means read to the first EOF.
.RE
.fi
.PP
Alternatively:
.sp
.I "lpconcat -q"
.sp
queries the user for all the commandline options.
.SH LPINFO
.PP
Requires an lpc filename on the command line and will print out
useful information about the analysis (sampling rate, frame size, number
of poles, descriptive text about the file, etc.) which is stored in the
header of the lpfile.
.SH LPINFED
.PP
Allows the user to edit the text portion of lpc file headers so that the file
is identifiable by descriptive means rather than info about number of poles
and other cryptic information.  
.I lpinfed 
reads the text portion of the header
into a temporary file ( default is
.I .lpinfed.tmp ) 
and then puts the user in her favorite editor (queries
the environment variable EDITOR).  The default is 
.I /usr/local/emacs.
User can specify
a different editor with the "-e" option.  The "-f" option allows the user to 
write to an output file other than the input file.
Note that, unlike anallpc and ptrack,
lpinfed requires a space between it's commandline flags and
their respective arguments.
.SH LPDUMP
.PP
Also requires a filename on the command line.  This simply dumps out 
an ascii report of all the 
frames in an lpc file.  It is useful for checking that the pitch analysis has
been done to the whole file (one can pipe the through "more" and skip ahead
to the end to see if all the pitch data has been merged).
.SH DIAGNOSTICS
.PP
Unrecognized commandline options to 
.I "anallpc, ptrack,"
and
.I lpconcat
will produce a helpful usage message.
.PP
.I Very useful information:
.sp
Sometimes, one might notice that the pitch analysis is taking quite a long
time, like, a few hours.  If you are unfortunate enough to have this happen
simply apply the very effective cntl-C sequence as ptrack sometimes likes to
stick on the last frame of the pitch analysis.  Also, don't be bothered by the
unsightly message from lpconcat
.B "bad read on pitch file."
It has just hit the
end of the pitch file.  To assure yourself that you indeed did get all of your
pitch data, simply try 
.B "lpdump LPFILENAME | more" 
and jump to the last frame ( see 
.I more(1)
).
.SH AUTHORS
Paul Lansky at Princeton, modified for MIT Experimental Music Studio
(ems.media.mit.edu) by dwf, bv, and dll.


