        sr      =       22050
        kr      =       2205
        ksmps   =       10
        nchnls  =       2

;==============================================================================;
;               Random Amplitude Modulation and Panning                        ;
;                                                                              ;
; Simple oscil instrument which uses randi to control the frequency of an      ;
; LFO which amplitude modulates the signal.  Another randi controls panning.   ;
; The nature of the amplitude modulation depends on the LFOs function and      ;
; the depth factor (0 - 1).  It would be simple to substitute a loscil or      ;
; soundin unit in place of the sine generator used in this example.            ;
;==============================================================================;

        instr   1
iamp    =       p4                              ;amplitude of the oscil
ipitch  =       cpspch(p5)                      ;freq of the oscil
ipanhz  =       p6                              ;freq of the panning randi
irandhz =       p7                              ;freq of the AM randi
iminhz  =       p8                              ;min freq of the LFO
imaxhz  =       p9                              ;max freq of the LFO
idepth  =       p10                             ;AM depth (0 - 1)
igatefn =       p11                             ;gate function (a bell func)
irise   =       p12                             ;overall rise
idecay  =       p13                             ;overall decay
iseed   =       p14                             ;seed used in both randis
ivaramp =       iamp*idepth                     ;portion of amp to modulate
iminamp =       iamp-ivaramp                    ;portion of amp to leave alone
kpanfac randi   .5,ipanhz,iseed                 ;random pan control
kpanfac =       .5+kpanfac                      ;offset to 0-1 range
kvarhz  randi   imaxhz-iminhz,irandhz,iseed     ;random LFO hz
kgate   oscili  idepth,iminhz+kvarhz,igatefn    ;the LFO
kenv    expseg  .01,irise,1,p3-irise-idecay,1,idecay,.001
asig    oscili  (iminamp+ivaramp*kgate)*kenv,ipitch,1
kleft   =       sqrt(kpanfac)
kright  =       sqrt(1-kpanfac)
        outs    asig*kleft,asig*kright
        endin
