#include <stdio.h>

#include <ctype.h>
#include "../PvOrig/pvoc.h"

#define READMODE "rb"
#define WRITEMODE "wb+"
#define PI 3.14159265358979323846
static PVSTRUCT tmphdr;

char *programName = "wrapped";


main(argc,argv)
     int argc;char **argv;
{
     PVSTRUCT *pvh; 
     char *infilnam;
     int  err,fftFrameSize,yourframes, i,j;
     long offset,off;
     char *cp;
     float *fp;
     long *lp;
     float bwidth;
     float p,q,oldp;
     int qq,cond;

     float srOn2pi, binMidFrq, frqPerBin, expectedDphas, eDphIncr;

        fprintf(stdout,"\nThis program displays variables that are used in the process of");
        fprintf(stdout,"\nconverting an imaginary phase value to an approximate frequency value.");

        if (argc != 2) {
                fprintf(stdout,"\n\nUsage: wrapped <analysis.file>\n\n");        
                exit(1);
        }
        infilnam = *++argv;
        
        if ( (err = PVReadFile(infilnam,&pvh)) != 0 ) {
                fprintf(stderr,"error reading was: %d\n",err);
                fprintf(stderr,"-1: couldn't open file\n");
                fprintf(stderr,"-2: not a pvoc.file\n");
                fprintf(stderr,"-3: couldn't allocate memory\n");
                fprintf(stderr,"-4: read error\n");
                exit(1);
        }
        
        fprintf(stdout,"Succesfull read of: %s\n",infilnam);    
        fprintf(stdout,"\n\nDisplaying Headerdata\n");
        fprintf(stdout,"dataBsize: data occupies %ld bytes\n",pvh->dataBsize);
        fprintf(stdout,"dataFormat: %ld\n",pvh->dataFormat);
        fprintf(stdout,"samplingRate of original audio: %6.0f\n",pvh->samplingRate);
        fprintf(stdout,"mono, stereo, quad:   %ld\n",pvh->channels);
        fprintf(stdout,"frameSize: %ld audio samples per frame\n",pvh->frameSize);
        fprintf(stdout,"frameIncr: increasing %ld audio samples per frame\n",pvh->frameIncr);

        fprintf(stdout,"frameBsize: %ld frames in this file\n",pvh->dataBsize/pvh->frameBsize);
        fprintf(stdout,"frameFormat: %ld\n",pvh->frameFormat);
        fprintf(stdout,"minFreq: %6.2f\n",pvh->minFreq);
        fprintf(stdout,"maxFreq: %6.2f\n",pvh->maxFreq);
        fprintf(stdout,"freqFormat, log or lin: %ld\n",pvh->freqFormat);

        /* let fp point to the start of data area */    
        offset=pvh->headBsize;
        cp = (char *)pvh;   /* let cp point to beginning of allocated memory */
        cp = cp + offset;   /* increment pointer by header size bytes */
        fp = (float *)cp;   /* make it a float pointer now */  

        fftFrameSize = pvh->frameSize/2+1;   /* # of complex data locs */
        /* bandwidth of frequency channels, given sr & framesize */
        bwidth = (.5*pvh->samplingRate)/(pvh->frameSize/2); 

        fprintf(stdout,"\n\nHow many frames do you want me to display?\n\n");
        scanf("%d",&yourframes);

        /* following three are constant, due to overall settings */
        srOn2pi = pvh->samplingRate/(2*PI*(float)pvh->frameIncr);
        frqPerBin = pvh->samplingRate/(float)pvh->frameSize;
        eDphIncr = 2.0 * PI * (float)pvh->frameIncr/(float)pvh->frameSize;

        /* These two vary per channel */
        binMidFrq = 0;
        expectedDphas = 0;      
        
        fprintf(stdout,"\n\n**************** Settings ***********************");
        fprintf(stdout,"\nall phase values are scaled by PI");
        fprintf(stdout,"\nsrOn2pi = %5.2f",srOn2pi);
        fprintf(stdout,"\t    eDphIncr = %5.2f",eDphIncr);
        fprintf(stdout,"\tfrqPerBin(+-) = %5.2f\n\n",frqPerBin);

        for (j=0;j<6 /* should be: fftFrameSize */;j++) /* show each channel */
        {       off = fftFrameSize*2;
                oldp = 0;
                
                fprintf(stdout,"channel %d:",j+1);
                fprintf(stdout,"\t\t\t\t %5.2f < ", binMidFrq - frqPerBin);
                fprintf(stdout,"%5.2f < ",binMidFrq);
                fprintf(stdout,"%5.2f \n\n",binMidFrq + frqPerBin);

                fprintf(stdout,"phase\tdiff-p\tcondit\tmasked");
                fprintf(stdout,"\texpDpha\tDiff\tmasked\tlocal-F\tglob-F\n");

                for (i=0;i<yourframes;i++) {
                   
                   p = *(fp+1+off*i+j*2);                   /* p holds phase */
                   fprintf(stdout,"%5.2f",p/PI);
                   
                   p -= oldp;                /* find change since last frame */
                   q = ((1/PI)*p);                          /* scale with PI */
                   fprintf(stdout,"\t%5.2f", q);
                   qq = (int)q; 
                                                     /* masking p: last step */
                   cond = qq+( (qq>=0)?(qq&1):-(qq&1) ); 
                   fprintf(stdout,"\t%d",cond);
                   p -= PI * cond;
                   fprintf(stdout,"\t%5.2f",p/PI);
                   oldp = *(fp+1+off*i+j*2);     /* oldp for next difference */
                   
                   fprintf(stdout,"\t%5.2f",expectedDphas/PI);

                   p -= expectedDphas;
                   fprintf(stdout,"\t%5.2f",p/PI);   /* difference - expDiff */

                   qq = (int)((1/PI)*p);                /* masking technique */
                   cond = qq + ( (qq>=0)?(qq&1):-(qq&1) );
                   p -= PI * cond;                      /* cond: {-2pi,02pi} */
                   fprintf(stdout,"\t%5.2f",p/PI);

                   p *= srOn2pi;
                   fprintf(stdout,"\t%5.2f",p);

                   p += binMidFrq;
                   fprintf(stdout,"\t%5.2f\n",p);
                }
                fprintf(stdout,"\n");   /* NL separates the channels */

                /* this differs per channel */
                expectedDphas += eDphIncr;
                expectedDphas -= 2*PI*(float)((int)(expectedDphas*(1/PI)));
                binMidFrq += frqPerBin;

        }  
        
        fprintf(stdout,"Done: %d frames of file %s\n\n",yourframes,infilnam);
        return(err);
}
