#include <stdio.h>
#include <ctype.h>
#include "../PvOrig/pvoc.h"

#define READMODE "rb"
#define WRITEMODE "wb+"

static PVSTRUCT tmphdr;

char *programName = "frames";

main(argc,argv)
     int argc;char **argv;
{
     PVSTRUCT *pvh; 
     char *infilnam;
     int  err,fftFrameSize,yourframes, i,j;
     long offset,off;
     char *cp;
     float *fp;
     long *lp;
     float bwidth;

	fprintf(stdout,"\nThis program displays FFT data per analysis frame.\n");	

	if (argc != 2) {
	 	fprintf(stderr,"\nUsage: frames <analysis.file>\n\n");	
		exit(1);
	}
	infilnam = *++argv;
	
	if ( (err = PVReadFile(infilnam,&pvh)) != 0 ) {
		fprintf(stderr,"error reading was: %d\n",err);
		fprintf(stderr,"-1: couldn't open file\n");
		fprintf(stderr,"-2: not a pvoc.file\n");
		fprintf(stderr,"-3: couldn't allocate memory\n");
		fprintf(stderr,"-4: read error\n");
		exit(1);
	}
	
 	fprintf(stdout,"Succesfull read of: %s\n",infilnam);	
	fprintf(stdout,"\n\nDisplaying Headerdata\n");
	fprintf(stdout,"dataBsize: data occupies %ld bytes\n",pvh->dataBsize);
	fprintf(stdout,"dataFormat: %ld\n",pvh->dataFormat);
	fprintf(stdout,"samplingRate of original audio: %6.0f\n",pvh->samplingRate);
	fprintf(stdout,"mono, stereo, quad:   %ld\n",pvh->channels);
	fprintf(stdout,"frameSize: %ld audio samples per frame\n",pvh->frameSize);
	fprintf(stdout,"frameIncr: increasing %ld audio samples per frame\n",pvh->frameIncr);
	fprintf(stdout,"frameBsize: %ld frames in this file\n",pvh->dataBsize/pvh->frameBsize);
	fprintf(stdout,"frameFormat: %ld\n",pvh->frameFormat);
	fprintf(stdout,"minFreq: %6.2f\n",pvh->minFreq);
	fprintf(stdout,"maxFreq: %6.2f\n",pvh->maxFreq);
	fprintf(stdout,"freqFormat, log or lin: %ld\n",pvh->freqFormat);

	/* let fp point to the start of data area */	
	offset=pvh->headBsize;
	cp = (char *)pvh;   /* let cp point to beginning of allocated memory */
	cp = cp + offset;   /* increment pointer by header size bytes */
	fp = (float *)cp;   /* make it a float pointer now */  

	fftFrameSize = pvh->frameSize/2+1;   /* # of complex data locs */
	/* bandwidth of frequency channels, given sr & framesize */
	bwidth = (.5*pvh->samplingRate)/(pvh->frameSize/2); 

	fprintf(stdout,"\n\nHow many frames do you want me to display?\n\n");
	scanf("%d",&yourframes);

	fprintf(stdout,"\n\tmagnitude\t\t\tfrequency\n\n");
	for (j=0;j<yourframes;j++) 	
	{	off = j*fftFrameSize*2;
		fprintf(stdout,"fr %d:",j+1);
		for(i=0;i<fftFrameSize;i++) {
	    	   fprintf(stdout,"\t%-5.2f",*(fp+off+i*2));
		   fprintf(stdout,"\t%-5.2f <",bwidth*(i-1));
		   fprintf(stdout," %-5.2f <",(bwidth/2)+bwidth*(i-1));
		   fprintf(stdout," %-5.2f ",bwidth*i);
		   fprintf(stdout,"\t%-5.2f\n",*(fp+off+i*2+1));
		}
		fprintf(stdout,"\n");   /* NL separates the frames */
	}  
	
	fprintf(stdout,"Done: %d frames of file %s\n\n",yourframes,infilnam);
	return(err);
}
