/*
 * Globally accessible information from xgraph
 */

#define MAXKEYS		50
#define MAXATTR 	8
#define MAXSETS		64
#define MAXBUFSIZE 	120
#define MAXLS		11

#define STRDUP(xx)	(strcpy(malloc((unsigned) (strlen(xx)+1)), (xx)))

typedef struct attr_set {
    char lineStyle[MAXLS];
    int lineStyleLen;
    Pixel pixelValue;
    Pixmap markStyle;
} AttrSet;    

extern AttrSet AllAttrs[MAXATTR];

/* Globally accessible values */
extern Display *disp;			/* Open display            */
extern Visual *vis;			/* Standard visual         */
extern Colormap cmap;			/* Standard colormap       */
extern int screen;			/* Screen number           */
extern int depth;			/* Depth of screen         */
extern int install_flag;		/* Install colormaps       */
extern Pixel black_pixel;		/* Actual black pixel      */
extern Pixel white_pixel;		/* Actual white pixel      */
extern Pixel bgPixel;			/* Background color        */
extern int bdrSize;			/* Width of border         */
extern Pixel bdrPixel;			/* Border color            */
extern Pixel zeroPixel;			/* Zero grid color         */
extern int zeroWidth;			/* Width of zero line      */
extern char zeroLS[MAXLS];		/* Line style spec         */
extern int zeroLSLen;			/* Length of zero LS spec  */
extern Pixel normPixel;			/* Norm grid color         */
extern int axisWidth;			/* Width of axis line      */
extern char axisLS[MAXLS];		/* Axis line style spec    */
extern int axisLSLen;			/* Length of axis line style */
extern Pixel echoPix;			/* Echo pixel value        */
extern XFontStruct *axisFont;		/* Font for axis labels    */
extern XFontStruct *titleFont;		/* Font for title          */
extern char titleText[MAXBUFSIZE]; 	/* Plot title              */
extern char XUnits[MAXBUFSIZE];		/* X Unit string           */
extern char YUnits[MAXBUFSIZE];		/* Y Unit string	   */
extern int bwFlag;			/* Black and white flag    */
extern int tickFlag;			/* Don't draw full grid    */
extern int bbFlag;			/* Whether to draw bb      */
extern int noLines;			/* Don't draw lines        */
extern int markFlag;			/* Draw marks at points    */
extern int pixelMarks;			/* Draw pixel markers      */
extern int bigPixel;			/* Draw big pixels         */
extern int colorMark;			/* Normal markers track color */
extern int logXFlag;			/* Logarithmic X axis      */
extern int logYFlag;			/* Logarithmic Y axis      */
extern int barFlag;			/* Draw bar graph          */
extern double barBase, barWidth;	/* Base and width of bars  */
extern int lineWidth;			/* Width of data lines     */
extern char *geoSpec;			/* Geometry specification  */
extern int numFiles;			/* Number of input files   */
extern char *inFileNames[MAXSETS]; 	/* File names              */
extern char *Odevice;			/* Output device   	   */
extern char *Odisp; 			/* Output disposition      */
extern char *OfileDev;			/* Output file or device   */
extern double Odim;			/* Output dimension        */
extern char *Otfam;			/* Output title family     */
extern double Otsize;			/* Output title size       */
extern char *Oafam;			/* Output axis family      */
extern double Oasize;			/* Output axis size        */
extern int debugFlag;			/* Whether debugging is on */

extern unsigned int dot_w, dot_h;	/* Size of a dot marker    */
extern unsigned int mark_w, mark_h;	/* Size of a style marker  */
extern int mark_cx, mark_cy;	/* Center of style marker  */

extern Pixmap dotMap;		/* Large dot bitmap        */

extern void do_hardcopy();	/* Carries out hardcopy    */
extern void ho_dialog();	/* Hardcopy dialog         */
extern void set_X();		/* Initializes X device    */

/* To make lint happy */
extern char *malloc();
extern char *realloc();
extern char *sprintf();
extern char *strcpy();
extern char *strcat();
extern char *rindex();
extern void exit();
extern void free();
