/*
 * Internal definitions for ux11 library
 * Requires inclusion of ux11.h.
 */

#ifndef UX11_INTERNAL
#define UX11_INTERNAL

#ifdef __STDC__
#include "stdarg.h"
#define VARARGS(func, rtn, args)	rtn func args
#define VOID_P	void *
#else
#include <varargs.h>
#define VARARGS(func, rtn, args)	/*VARARGS*/ rtn func(va_alist) va_dcl
#define VOID_P	char *
#endif

/*
 * Some standards not defined in header files
 */

DECLARE(fprintf, int, (FILE *fp, char *format, ...));
DECLARE(abort, void, ());
DECLARE(malloc, char *, (unsigned long));
DECLARE(realloc, char *, (char *ptr, unsigned size));
DECLARE(sprintf, char *, (char *buf, char *fmt, ...));
#endif
