.TH XFED 1 "19 Aug 1988" "X Version 11"
.SH NAME
xfed \- font editor for X Version 11 bdf fontfiles

.SH \fBSYNOPSIS\fP
.B xfed
[
\-options \.\.\.
]
\fB\fIfilename\fR
.SH DESCRIPTION

.I xfed
lets you interactively edit existing bdf-fontfiles.
When run,
.I xfed
opens a window showing a magnified character of the font.
There are four buttons to interact with 
\fIxfed\fP,
two stepping buttons to advance to the previous/next character in the
font, a write-file button and an exit button.
If you leave
.I xfed
without saving a modified font, a dialog window will appear, asking if
you want save changes before quitting.
The write option moves the original fontfile
to a backup file (filename~) and saves the edited font under the original name.

.SH OPTIONS
.PP
\fIxfed\fP accepts the following options:

.TP 8
\fB\-display \fP\fIhost:dpy\fP
the server to be used.  See \fIX(1)\fP for details.
.TP 8
.B \-geometry \fIgeometry\fP
the placement and size of the bitmap window on the
screen.  See \fIX(1)\fP for details.
.TP 8
.B \-psize \fP\fInumber\fP
the pixel magnification factor.
.TP 8
.B \-nogrid
no grid in the edit window (not very useful).
.TP 8
.B \-bw \fP\fInumber\fP
border width in pixels.
.TP 8
.B \-fg \fIcolorname\fP
foreground color.
.TP 8
.B \-bg \fIcolorname\fP
background color.
.TP 8
.B \-bd \fP\fIcolorname\fP
border color.  Note, that this color is also used for the grid.
.TP 8
.B \-font \fP\fIfontname\fP
font used for text in the font editor.
.LP
The window created by
.I xfed
has several subwindows.  At the top, a window displays
the name of the file being edited.  Below this window, two
similar windows display information about the font and the
character being displayed.  Below this window is a direct access
window through which any character in the font can be accessed.
.LP
The direct access window has a vertical bar which represents the relative
position of the displayed character in the font.  The vertical bar can
be "dragged" with any mouse button to access a character.  Alternatively,
you may type the desired character with the pointer in this window
to access a character.
.LP
Below the direct access window is the edit window
which displays the character with pixels magnified by the factor \fBpsize\fP.
The command buttons to step through the font, save the font, or exit the editor
are to the right of the edit window.
Two windows below the command buttons display the character in actual
size using the foreground and background colors.

.SH COMMANDS
.LP
Two arrows point into the edit window on the
top and right sides.  To change the bounding box for
the current character they may be "dragged" with any
mouse button.

.TP 8
.I Button 1
(usually the left button) turns on pixels.
 
.TP 8
.I Button 2
(usually th middle button) inverts pixels.
 
.TP 8
.I Button 3
(usually the right button) turns off pixels.
.LP
Four editing commands which are typed directly from the keyboard
with the pointer within the bounding box of the characte are:r
.IP \fBi\fP
Insert a horizontal line at the pointer position

.IP \fBd\fP
Delete a horizontal line at the pointer position

.IP \fBI\fP
Insert a vertical line at the pointer position

.IP \fBD\fP
Delete a vertical line at the pointer position
.LP
The direct access window (above the edit window):
.LP
Any key pressed in this window will display that character
in the edit window and move the vertical bar to the
corresponding positon in the font.
.LP
Pushing a mouse
button in this window will move the vertical bar to that
position, and thus display the corresponding character in
the edit window.

.SH \fBFILE FORMAT\fP

see X-Doc 'Character Bitmap Distribution Format 2.1'

.SH X DEFAULTS
.PP
.I xfed
uses the routine
.I XGetDefault(3X)
to read defaults.
.PP
.TP 8
.B Geometry
The size and location of the bitmap window.  The default depends on the font.
.PP
.TP 8
.B PixelSize
The initial pixel magnification factor.  The default depends on the font.
.PP
.TP 8
.B NoGrid
.br
No grid will be used in the edit window if true.  The default is false.
.PP
.TP 8
.B BorderWidth
The border width.  The default value is 2.
.PP
.TP 8
.B Foreground
The foreground color.  Bits which are 1 in the bitmap are
displayed in this color.  This option is useful only on color
displays. The default value is ``black''.
.PP
.TP 8
.B Background
The window's background color.  Bits which are 0 in the bitmap are
displayed in this color.  This option is useful only on color
displays.  The default value is ``white''.
.PP
.TP 8
.B BorderColor
The border color.  This option is useful only on color displays.
The default value is ``black''.
.PP
.TP 8
.B BodyFont
The text font.  The default value is ``fixed''.  If \fIxfed\fP is
given variable width font it will not display the current character
while the direct access bar is "dragged".

.SH \fBENVIRONMENT\fP
DISPLAY - the default host and display number.
.br
XENVIRONMENT - the name of the defaults file to use.

.SH \fBSEE ALSO\fP
X(1), BITMAP(1), X-Doc 'Character Bitmap Distribution Format 2.1'

.SH \fBBUGS\fP
.PP
Limited edit features.
.PP
No ``undo'' command.
.PP
Unable to change font characteristics and character properties.
.PP
If you move the pointer too fast while holding a pointer button down,
some squares may be `missed'.  This is caused by limitations in how
frequently the X server can sample the mouse location.
.PP
There is no way to write to a file other than that specified on the
command line.

.SH COPYRIGHT
Copyright 1988, Network Computing Devices, Inc.

.SH \fBAUTHOR\fP
Olaf Brandt
.br
Network Cumputing Devices, Inc.
.br
Palo Alto, CA
.br
.sp 2
Copyright (c) 1988 by Siemens
.br
Claus Gittinger
.br
Software Consultant
.br
Siemens Munich
.br
Dep. D-St-Sp-4
.br
Charles-de-Gaullestr. 2a
.br
8000 Munich/Neuperlach
.br
West Germany
.br
Email: ..!decvax!unido!sinix!claus
