%/* @(#)key_prot.x 1.7 88/02/08 Copyr 1986 Sun Micro */
%
%/* 
% * Compiled from key_prot.x using rpcgen.
% * DO NOT EDIT THIS FILE!
% * This is NOT source code!
% */

/*
 * Key server protocol definition
 * Copyright (C) 1987 Sun Microsystems, Inc.
 *
 * The keyserver is a public key storage/encryption/decryption service
 * The encryption method used is Diffie-Hellman with 128 bit keys.
 *
 * The key server is local to each machine, akin to the portmapper.
 * Only privileged processes may talk to the key server, so
 * user processes must communicate through a privileged dispatcher (such 
 * as the kernel or a set-uid-root process).
 */
program KEY_PROG {
	version KEY_VERS {
		/*
		 * This is my secret key.
	 	 * Store it for me.
		 */
		int 
		KEY_SET(keybuf) = 1;	
	
		/*
		 * I want to talk to X.
		 * Encrypt a conversation key for me.
	 	 */
		cryptkeyres
		KEY_ENCRYPT(cryptkeyarg) = 2;	

		/*
		 * X just sent me a message.
		 * Decrypt the conversation key for me.
		 */
		cryptkeyres
		KEY_DECRYPT(cryptkeyarg) = 3;

		/*
		 * Generate a secure conversation key for me
		 */
		des_block 
		KEY_GEN(void) = 4;

		/*
		 * Get me the uid, gid and group-access-list associated
		 * with this netname (for kernel which cannot use yp)
		 */
		getcredres
		KEY_GETCRED(netnamestr) = 5;
	} = 1;
} = 100029;


/*
 * PROOT and MODULUS define the way the Diffie-Hellman key is generated.
 *
 * MODULUS should be chosen as a prime of the form: MODULUS == 2*p + 1,
 * where p is also prime.
 *
 * PROOT satisfies the following two conditions:
 * (1) (PROOT ** 2) % MODULUS != 1
 * (2) (PROOT ** p) % MODULUS != 1
 *
 */

const PROOT = 3;
const HEXMODULUS = "d4a0ba0250b6fd2ec626e7efd637df76c716e22d0944b88b";

const HEXKEYBYTES = 48;		/* HEXKEYBYTES == strlen(HEXMODULUS) */
const KEYSIZE = 192;		/* KEYSIZE == bit length of key */
const KEYBYTES = 24;		/* byte length of key */

/*
 * The first 16 hex digits of the encrypted secret key are used as
 * a checksum in the database.
 */
const KEYCHECKSUMSIZE = 16;

/*
 * status of operation
 */
enum keystatus {
	KEY_SUCCESS,	/* no problems */
	KEY_NOSECRET,	/* no secret key stored */
	KEY_UNKNOWN,	/* unknown netname */
	KEY_SYSTEMERR 	/* system error (out of memory, encryption failure) */
};

/*
 * The kernel doesn't use keybuf, so we insure that it
 * is ifdef'd out in the output files. The proper way to do
 * this is to #ifndef KERNEL it here, and have the kernel build
 * use rpcgen, but config doesn't understand rpcgen files so
 * it is done this way.
 */
#ifndef RPC_SVC
%#ifndef KERNEL
typedef opaque keybuf[HEXKEYBYTES];	/* store key in hex */
%#endif
#endif

typedef string netnamestr<MAXNETNAMELEN>;

/*
 * Argument to ENCRYPT or DECRYPT 
 */
struct cryptkeyarg {
	netnamestr remotename;
	des_block deskey;
};

/*
 * Result of ENCRYPT or DECRYPT
 */
union cryptkeyres switch (keystatus status) {
case KEY_SUCCESS:
	des_block deskey;
default:
	void;
};

const MAXGIDS  = 16;	/* max number of gids in gid list */

/*
 * Unix credential 
 */	
struct unixcred {
	int uid;
	int gid;
	int gids<MAXGIDS>;	
};

/*
 * Result returned from GETCRED
 */
union getcredres switch (keystatus status) {
case KEY_SUCCESS:
	unixcred cred;
default:
	void;
};
