#include <rpc/rpc.h>
#include "rpcint.h"


bool_t
xdr_fname(xdrs, objp)
	XDR *xdrs;
	fname objp;
{
	if (!xdr_vector(xdrs, (char *)objp, 200, sizeof(char), xdr_char)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_magali_fname(xdrs, objp)
	XDR *xdrs;
	magali_fname *objp;
{
	if (!xdr_vector(xdrs, (char *)objp->rule_name, 40, sizeof(char), xdr_char)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->rule_pointer)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_magali_iarray(xdrs, objp)
	XDR *xdrs;
	magali_iarray *objp;
{
	if (!xdr_vector(xdrs, (char *)objp->name, 40, sizeof(char), xdr_char)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->value)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_patfile(xdrs, objp)
	XDR *xdrs;
	patfile *objp;
{
	if (!xdr_vector(xdrs, (char *)objp->name, 200, sizeof(char), xdr_char)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->index)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_patres(xdrs, objp)
	XDR *xdrs;
	patres *objp;
{
	if (!xdr_vector(xdrs, (char *)objp->width, 2, sizeof(int), xdr_int)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->height, 2, sizeof(int), xdr_int)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_farray(xdrs, objp)
	XDR *xdrs;
	farray *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->farray_val, (u_int *)&objp->farray_len, ~0, sizeof(float), xdr_float)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_iarray(xdrs, objp)
	XDR *xdrs;
	iarray *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->iarray_val, (u_int *)&objp->iarray_len, ~0, sizeof(magali_iarray), xdr_magali_iarray)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_fnarray(xdrs, objp)
	XDR *xdrs;
	fnarray *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->fnarray_val, (u_int *)&objp->fnarray_len, ~0, sizeof(magali_fname), xdr_magali_fname)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_bitweight(xdrs, objp)
	XDR *xdrs;
	bitweight *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->bitweight_val, (u_int *)&objp->bitweight_len, ~0, sizeof(u_int), xdr_u_int)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_wvaluetype(xdrs, objp)
	XDR *xdrs;
	wvaluetype *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->wvaluetype_val, (u_int *)&objp->wvaluetype_len, ~0, sizeof(float), xdr_float)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rec(xdrs, objp)
	XDR *xdrs;
	rec *objp;
{
	if (!xdr_int(xdrs, &objp->errorn)) {
		return (FALSE);
	}
	switch (objp->errorn) {
	case 0:
		if (!xdr_farray(xdrs, &objp->rec_u.sttwgt)) {
			return (FALSE);
		}
		break;
	case 1:
		if (!xdr_fnarray(xdrs, &objp->rec_u.names)) {
			return (FALSE);
		}
		break;
	case 2:
		if (!xdr_iarray(xdrs, &objp->rec_u.dontkno)) {
			return (FALSE);
		}
		break;
	case 3:
		if (!xdr_bitweight(xdrs, &objp->rec_u.bitconnect)) {
			return (FALSE);
		}
		break;
	case 4:
		if (!xdr_wvaluetype(xdrs, &objp->rec_u.wvalue)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}




bool_t
xdr_strctname(xdrs, objp)
	XDR *xdrs;
	strctname *objp;
{
	if (!xdr_vector(xdrs, (char *)objp->indx, 6, sizeof(int), xdr_int)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->namecode)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_twoindx(xdrs, objp)
	XDR *xdrs;
	twoindx *objp;
{
	if (!xdr_vector(xdrs, (char *)objp->fromindx, 4, sizeof(int), xdr_int)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->toindx, 4, sizeof(int), xdr_int)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_roadsize(xdrs, objp)
	XDR *xdrs;
	roadsize *objp;
{
	if (!xdr_vector(xdrs, (char *)objp->fromroad, 4, sizeof(int), xdr_int)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->toroad, 4, sizeof(int), xdr_int)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->size)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rpcneu(xdrs, objp)
	XDR *xdrs;
	rpcneu *objp;
{
	if (!xdr_int(xdrs, &objp->fanin)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rpcclu(xdrs, objp)
	XDR *xdrs;
	rpcclu *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->rpcclu_val, (u_int *)&objp->rpcclu_len, ~0, sizeof(rpcneu), xdr_rpcneu)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rpclay(xdrs, objp)
	XDR *xdrs;
	rpclay *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->rpclay_val, (u_int *)&objp->rpclay_len, ~0, sizeof(rpcclu), xdr_rpcclu)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rpcnet(xdrs, objp)
	XDR *xdrs;
	rpcnet *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->rpcnet_val, (u_int *)&objp->rpcnet_len, ~0, sizeof(rpclay), xdr_rpclay)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rpcsys(xdrs, objp)
	XDR *xdrs;
	rpcsys *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->rpcsys_val, (u_int *)&objp->rpcsys_len, ~0, sizeof(rpcnet), xdr_rpcnet)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_rpcsyslist(xdrs, objp)
	XDR *xdrs;
	rpcsyslist *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(rpcsys), xdr_rpcsys)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_confres(xdrs, objp)
	XDR *xdrs;
	confres *objp;
{
	if (!xdr_int(xdrs, &objp->errorn)) {
		return (FALSE);
	}
	switch (objp->errorn) {
	case 0:
		if (!xdr_rpcsyslist(xdrs, &objp->confres_u.sys)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}




bool_t
xdr_patlist(xdrs, objp)
	XDR *xdrs;
	patlist *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct patnode), xdr_patnode)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_patnode(xdrs, objp)
	XDR *xdrs;
	patnode *objp;
{
	if (!xdr_patlist(xdrs, &objp->next_ptr)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->filename, ~0)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->score)) {
		return (FALSE);
	}
	return (TRUE);
}


