#include <stdio.h>
#include <rpc/rpc.h>
#include "rpcint.h"

static void cmdlibprog_1();

main()
{
	SVCXPRT *transp;

	(void)pmap_unset(CMDLIBPROG, CMDLIBVERS);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		(void)fprintf(stderr, "cannot create udp service.\n");
		exit(1);
	}
	if (!svc_register(transp, CMDLIBPROG, CMDLIBVERS, cmdlibprog_1, IPPROTO_UDP)) {
		(void)fprintf(stderr, "unable to register (CMDLIBPROG, CMDLIBVERS, udp).\n");
		exit(1);
	}

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		(void)fprintf(stderr, "cannot create tcp service.\n");
		exit(1);
	}
	if (!svc_register(transp, CMDLIBPROG, CMDLIBVERS, cmdlibprog_1, IPPROTO_TCP)) {
		(void)fprintf(stderr, "unable to register (CMDLIBPROG, CMDLIBVERS, tcp).\n");
		exit(1);
	}
	svc_run();
	(void)fprintf(stderr, "svc_run returned\n");
	exit(1);
}

static void
cmdlibprog_1(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union {
		fname rinit_1_arg;
		fname rsave_1_arg;
		fname rload_1_arg;
		fname rsysconf_1_arg;
		strctname rnetstat_1_arg;
		int rexecute_1_arg;
		patfile rreadinp_1_arg;
		patfile rreadall_1_arg;
		char rrandweight_1_arg;
		twoindx rgetanyweight_1_arg;
		twoindx rgetbitweight_1_arg;
		roadsize rgetsparse_1_arg;
		int rterminateserv_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void)svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case RINIT:
		xdr_argument = xdr_fname;
		xdr_result = xdr_int;
		local = (char *(*)()) rinit_1;
		break;

	case RSAVE:
		xdr_argument = xdr_fname;
		xdr_result = xdr_int;
		local = (char *(*)()) rsave_1;
		break;

	case RLOAD:
		xdr_argument = xdr_fname;
		xdr_result = xdr_int;
		local = (char *(*)()) rload_1;
		break;

	case RSYSCONF:
		xdr_argument = xdr_fname;
		xdr_result = xdr_confres;
		local = (char *(*)()) rsysconf_1;
		break;

	case RNETSTAT:
		xdr_argument = xdr_strctname;
		xdr_result = xdr_rec;
		local = (char *(*)()) rnetstat_1;
		break;

	case REXECUTE:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) rexecute_1;
		break;

	case RREADINP:
		xdr_argument = xdr_patfile;
		xdr_result = xdr_patres;
		local = (char *(*)()) rreadinp_1;
		break;

	case RREADALL:
		xdr_argument = xdr_patfile;
		xdr_result = xdr_patres;
		local = (char *(*)()) rreadall_1;
		break;

	case RRANDWEIGHT:
		xdr_argument = xdr_char;
		xdr_result = xdr_int;
		local = (char *(*)()) rrandweight_1;
		break;

	case RGETANYWEIGHT:
		xdr_argument = xdr_twoindx;
		xdr_result = xdr_rec;
		local = (char *(*)()) rgetanyweight_1;
		break;

	case RGETBITWEIGHT:
		xdr_argument = xdr_twoindx;
		xdr_result = xdr_rec;
		local = (char *(*)()) rgetbitweight_1;
		break;

	case RGETSPARSE:
		xdr_argument = xdr_roadsize;
		xdr_result = xdr_rec;
		local = (char *(*)()) rgetsparse_1;
		break;

	case RTERMINATESERV:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) rterminateserv_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		(void)fprintf(stderr, "unable to free arguments\n");
		exit(1);
	}
}

