/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * mab, cjw
 *
 * rpcint.c
 ******************************************************************************/

#include "pygmalion.h"
#include "sysdef.h"
#include "rpcdef.h"


extern int *config ;
/* 15 January changes to accomodate new nC version */
extern system_type *sys;

/* Global variables */

char filename[ FILESIZE ];

char sys_filename[ FILESIZE ];

int result;
 
int howmanybits ;

int session ;

/*-----------------------------------*/
/* PROCEDURE WICH SET THE BIT ARRAY */
 void SetBitmap()
 {

  if (!session)
	{
	 session = 1 ;
 	 howmanybits = sizeof(int) * 8 ;
/*printf(" how many bits in an int ? %i\n" , howmanybits) ;*/
	} ;

 } ; 

/*----------------------------------------------*/
/* INT RINIT( FNAME )				*/
/* Initialise the system structure 		*/
/*    => call connect and build-rules		*/

int*
rinit_1(name)
fname name;
{
  srandom(0xd5a4793c);
  srand48(random());
 
  SetBitmap() ;
 
     printf("start of rinit");
  if (!name[0]) {
     *sys_filename = '\000';
     if (result = connect(&config))
	return(&result);;
     result = build_rules();
  }
  else {
     strcpy(sys_filename, name);
     printf("calling sys_load");
     result = sys_load(sys_filename);
  }
printf("end of rinit\n") ;
  return(&result);
}


/*----------------------------------------------*/
/* INT RSAVE( FNAME )				*/
/* Save a neural network system 		*/
/* 	=> config, states, weights, parameters, patterns learnt */

int*
rsave_1(filename)
fname filename;
{
  if (filename[0])
     result = sys_save(filename);
  return(&result);
}

/* for construct[(config_filename)] */
/* int RLOAD(fname) */

/*----------------------------------------------*/
/* INT RLOAD( FNAME )				*/
int*
rload_1(filename)
fname filename;
{
  if (filename[0])
     result = sys_load(filename);
  else
     result = FAIL;
  return(&result);
}

/*----------------------------------------------*/
/* CONFRES RSYSCONF( FNAME )			*/
/*    get the configuration of the system 	*/

confres *
rsysconf_1(name)
fname name;
{
  static confres res;
  rpcsyslist *lsysp;
  rpcsyslist lsys;
  int i, nets;

  extern void netconf();

  xdr_free(xdr_confres, &res);

  if (!sys) {
     res.errorn = SYSEMPTY;
     return(&res);
  }

  lsysp = &res.confres_u.sys;
  lsys = *lsysp = (rpcsys *) calloc(sizeof(rpcsys), 1);

  lsys->rpcsys_len = nets = sys->nets;
  if (nets <= 0)
     return(&res);
  lsys->rpcsys_val = (rpcnet *) calloc(sizeof(rpcnet), nets);
  for (i=0; i<nets; i++)
     netconf(&lsys->rpcsys_val[i], i);
  res.errorn = 0;
  return(&res);
}

/*----------------------------------------------*/
/* HELP FOR RSYSCONF RPC			*/
void
netconf(lnetp, n)
rpcnet *lnetp;
int n;
{
  int i, lays;

  extern void layconf();

  lnetp->rpcnet_len = lays = sys->net[n]->layers;
  if (lays <= 0)
     return;
  lnetp->rpcnet_val = (rpclay *) calloc(sizeof(rpclay), lays);
  for (i=0; i<lays; i++)
     layconf(&lnetp->rpcnet_val[i], n, i);

}

/*----------------------------------------------*/
/* HELP FOR RSYSCONF RPC			*/
void
layconf(llayp, n, l)
rpclay *llayp;
int n, l;
{
  int i, clus;

  extern void cluconf();

  llayp->rpclay_len = clus = sys->net[n]->layer[l]->clusters;
  if (clus <= 0)
     return;
  llayp->rpclay_val = (rpcclu *) calloc(sizeof(rpcclu), clus);
  for (i=0; i<clus; i++)
     cluconf(&llayp->rpclay_val[i], n, l, i);
}

/*----------------------------------------------*/
/* HELP FOR RSYSCONF RPC			*/
void
cluconf(lclup, n, l, c)
rpcclu *lclup;
int n, l, c;
{
  int i, neus;

  lclup->rpcclu_len = neus = sys->net[n]->layer[l]->cluster[c]->neurons;
  if (neus <= 0)
     return;
  lclup->rpcclu_val = (rpcneu *) calloc(sizeof(rpcneu), neus);
  for (i=0; i<neus; i++)
     lclup->rpcclu_val[i].fanin =
     		sys->net[n]->layer[l]->cluster[c]->neuron[i]->fanin;
}

/*----------------------------------------------*/
/* REC RNETSTAT ( STRCTNAME )			*/
/*  According to strctname level and code gives */
/*		N_RULE => nbe of rules, names and int for execution */
/*		N_PARA => nbe of params, name and value */
/*		N_STATE => value state, target or error */
rec *
rnetstat_1(para)
strctname *para;
{
  static rec res;
  int i, level = -1;
  int *indx;

  extern rec *get_rule();
  extern rec *get_para();
  extern rec *get_data();

  xdr_free(xdr_rec, &res);
  for (i=0; i<=SYN; i++)
     if (para->indx[i] != -1)
	level++;
     else
	break;


/* MAGALI Comments Be aware of the stange logic of a Case statement in C */ 
/*      => like falling fom a building (you go through each floor ) */
  indx = para->indx;
  switch (level) {
     case SYS :	
     case NET :  
     case LAY:	if ((para->namecode != N_RULE) &&
		    (para->namecode != N_PARA)) {
		   res.errorn = -1;
		   return(&res);
		}
     case CLU:	if (para->namecode == N_WEIGHT) {
		   res.errorn = -1;
		   return(&res);
		}
		if (para->namecode == N_RULE)
		   return(get_rule(para->indx, level));
		if (para->namecode == N_PARA)
		   return(get_para(para->indx, level));
		return(get_data(para->indx, para->namecode));
     case NEU:	switch (para->namecode) {
		   case N_STATE:
		   case N_TARGET:
		   case N_ERR:
				res.errorn = 0;
				res.rec_u.sttwgt.farray_len = 1;
				res.rec_u.sttwgt.farray_val =
					(float *) malloc(sizeof(float));
				res.rec_u.sttwgt.farray_val[0] =
					sys[indx[0]].net[indx[1]]->layer[indx[2]]->cluster[indx[3]]->neuron[indx[4]]->state[para->namecode].value.f;
				return(&res);
		   case N_RULE:	return(get_rule(para->indx, level));
		   case N_PARA:	return(get_para(para->indx, level));
		   default:	res.errorn = -1;
				return(&res);
		}
     case SYN:	switch (para->namecode) {
		   case N_RULE:	return(get_rule(para->indx, level));
		   case N_PARA:	return(get_para(para->indx, level));
		   case N_WEIGHT: res.rec_u.sttwgt.farray_len = 1;
				res.rec_u.sttwgt.farray_val = (float *)
						malloc(sizeof(float));
				res.rec_u.sttwgt.farray_val[0] =
					sys[indx[0]].net[indx[1]]->layer[indx[2]]->cluster[indx[3]]->neuron[indx[4]]->synapse[indx[5]]->weight.value.f ;
				res.errorn = 0;
				return(&res);
		   default:	res.errorn = -1;
				return(&res);
		}
     default:	res.errorn = -1;
		return(&res);
  }
}

/*----------------------------------------------*/
/* REC 	GET RULES 				*/
/* 	PART OF RNETSTAT ( STRCTNAME )		*/

rec *
get_rule(indx, level)
int *indx, level;
{
  static rec res;
/* Changes for fnlist type due to changes to RPC-rule */
  magali_fname *fnlist;

/* NEW MAGALI Changes all change in this procedure */
  system_type *mysystem ;
  net_type *mynet ;
  layer_type *mylayer ;
  cluster_type *mycluster ;
  neuron_type *myneuron ;
  int number  ;
  int i , starting  ;

/* No difference at the moment between META and GROUND rules */
/* Cause I just take their name and pointer => do not access para_list */
/* CHANGES 15 JANUARY NEW RULE STRUCTURE */
  res.errorn = 1;
  switch (level) 
  {

/* SYSTEM   */
  case 0:
       mysystem = &sys[indx[0]] ;
       number = mysystem->n_rules ;
/* if no rules */
      if (!number)
      {
         res.rec_u.names.fnarray_len = 0;
         res.rec_u.names.fnarray_val = NULL;
         return(&res);
      } ;
/* allocate space needed for rules */
      res.rec_u.names.fnarray_len = number ;
      res.rec_u.names.fnarray_val = fnlist =
          (magali_fname *) calloc(sizeof(magali_fname), number );
      i = 0 ; while ( i < number )
            {
            strcpy(fnlist[i].rule_name, mysystem->rules[i].name) ;
            fnlist[i].rule_pointer = (int)  &mysystem->rules[i] ;
	    i++ ;
            } ; 
       return(&res);
       break ;

/* NET  */
  case 1:
       mynet = sys[indx[0]].net[indx[1]]  ;
       number = mynet->n_rules  ;
/* if no rules */
      if (!number)
      {
         res.rec_u.names.fnarray_len = 0;
         res.rec_u.names.fnarray_val = NULL;
         return(&res);
      }
/* allocate space needed for rules */
      res.rec_u.names.fnarray_len = number ;
      res.rec_u.names.fnarray_val = fnlist =
          (magali_fname *) calloc(sizeof(magali_fname), number );
      i = 0 ; while( i < number )
            {
            strcpy(fnlist[i].rule_name, mynet->rules[i].name) ;
            fnlist[i].rule_pointer = (int)  &mynet->rules[i] ;
	    i++ ;
            } ; 
       return(&res);
       break ;

/* LAYER  */
  case 2 :
       mylayer = sys[indx[0]].net[indx[1]]->layer[indx[2]]  ;
       number = mylayer->n_rules ;
/*       printf("number of layer rule %i \n" , number  ) ;*/
/* if no rules */
      if (!number)
      {
         res.rec_u.names.fnarray_len = 0;
         res.rec_u.names.fnarray_val = NULL;
         return(&res);
      }
/* allocate space needed for rules */
      res.rec_u.names.fnarray_len = number ;
      res.rec_u.names.fnarray_val = fnlist =
          (magali_fname *) calloc(sizeof(magali_fname), number );
      i = 0 ; while( i < number )
            {
            strcpy(fnlist[i].rule_name, mylayer->rules[i].name) ;
            fnlist[i].rule_pointer = (int)  &mylayer->rules[i] ;
	    i++ ;
            } ; 
       return(&res);
       break ;

/* CLUSTER */
  case 3 :
       mycluster = sys[indx[0]].net[indx[1]]->layer[indx[2]]->cluster[indx[3]]  ;
       number = mycluster->n_rules  ;
/* if no rules */
      if (!number)
      {
         res.rec_u.names.fnarray_len = 0;
         res.rec_u.names.fnarray_val = NULL;
         return(&res);
      }
/* allocate space needed for rules */
      res.rec_u.names.fnarray_len = number ;
      res.rec_u.names.fnarray_val = fnlist =
          (magali_fname *) calloc(sizeof(magali_fname), number );
	i = 0 ; while( i < number )
            {
            strcpy(fnlist[i].rule_name, mycluster->rules[i].name) ;
            fnlist[i].rule_pointer = (int)  &mycluster->rules[i] ;
	    i++ ;
            } ; 
       return(&res);
       break ;

/* NEURON */
  case 4 :
    myneuron = 
     sys[indx[0]].net[indx[1]]->layer[indx[2]]->cluster[indx[3]]->neuron[indx[4]];

       number = myneuron->n_rules  ;

/* if no rules */
      if (!number)
      {
         res.rec_u.names.fnarray_len = 0;
         res.rec_u.names.fnarray_val = NULL;
         return(&res);
      }
/* allocate space needed for rules */
      res.rec_u.names.fnarray_len = number ;
      res.rec_u.names.fnarray_val = fnlist =
          (magali_fname *) calloc(sizeof(magali_fname), number );
     i = 0 ; while( i < number ) 
            {
            strcpy(fnlist[i].rule_name, myneuron->rules[i].name) ;
/*printf("IN NEURON RULE RPC NAME GROUND %s\n" , fnlist[i].rule_name) ;*/
            fnlist[i].rule_pointer = (int)  &myneuron->rules[i] ;
	    i++ ;
            } ; 
       return(&res);
       break ;
   }
}

/* Bloody crash of ron */
/* This procedure has no interest  because of the Ruusioan approach taken */
/* 
 * void *
 * x_strct(indx, level)
 * int *indx, level;
 * {
 *   void *ptr;
 * 
 *   switch (level) {
 *      case 0:	ptr = (void *) sys;
 * 		break;
 *      case 1:	ptr = (void *) &sys->net[indx[1]];
 * 		break;
 *      case 2:	ptr = (void *) &sys->net[indx[1]].layer[indx[2]];
 * 		break;
 *      case 3:	ptr = (void *) &sys->net[indx[1]].layer[indx[2]].cluster[indx[3]];
 * 		break;
 *      case 4:	ptr = (void *) &sys->net[indx[1]].layer[indx[2]].cluster[indx[3]].neuron[indx[4]];
 * 		break;
 *      case 5:	ptr = (void *) &sys->net[indx[1]].layer[indx[2]].cluster[indx[3]].neuron[indx[4]].synapse[indx[5]];
 * 		break;
 * 
 *      default:	return(NULL);
 *   }
 *   return(ptr);
 * }
 */ 
/*----------------------------------------------*/
/* REC 	GET PARAMS 				*/
/* 	PART OF RNETSTAT ( STRCTNAME )		*/
rec *
get_para(indx, level)
int *indx, level;
{
  static rec res;
  magali_iarray *param_pointer ;
  system_type *mysystem ;
  net_type *mynet ;
  layer_type *mylayer ;
  cluster_type *mycluster ;
  neuron_type *myneuron ;
  int number ;
  int i ;
  void *thepointer ; /* Can not make it work as rule_type */

/* ie not able to declare a (void) pointer and then assign it according */
/* to the level => take the "Russian" approach = repeat same code !!!*/

  xdr_free(xdr_rec, &res);

  res.errorn = 1;
   switch (level) {

/* SYSTEM   */
     case 0:
       mysystem = &sys[indx[0]] ;
       number = mysystem->n_parameters ;
/* if no parameters */
  if (!number)
  {
     res.rec_u.dontkno.iarray_len = 0;
     res.rec_u.dontkno.iarray_val = NULL;
     return(&res);
  }
/* allocate space needed for parameters */
  res.rec_u.dontkno.iarray_len = number;
  res.rec_u.dontkno.iarray_val = param_pointer = 
    (magali_iarray *) calloc(sizeof(magali_iarray) , number) ;
  for (i = 0 ; i < number ; i++)
     {
      strcpy(param_pointer[i].name, mysystem->parameters[i].name);
      param_pointer[i].value = mysystem->parameters[i].parameter.value.f ; 
     } ; 
   return(&res);
       break ;       

/*NET     */
     case 1 :
       mynet = sys[indx[0]].net[indx[1]]  ;
       number = mynet->n_parameters ;
/* if no parameters */
  if (!number)
  {
     res.rec_u.dontkno.iarray_len = 0;
     res.rec_u.dontkno.iarray_val = NULL;
     return(&res);
  }
/* allocate space needed for parameters */
  res.rec_u.dontkno.iarray_len = number;
  res.rec_u.dontkno.iarray_val = param_pointer = 
    (magali_iarray *) calloc(sizeof(magali_iarray) , number) ;
  for (i = 0 ; i < number ; i++)
     {
      strcpy(param_pointer[i].name, mynet->parameters[i].name);
      param_pointer[i].value = mynet->parameters[i].parameter.value.f ; 
     } ; 
   return(&res);
       break ;       

/* LAYER */
     case 2 :
       mylayer = sys[indx[0]].net[indx[1]]->layer[indx[2]] ;
       number = mylayer->n_parameters ;
/* if no parameters */
  if (!number)
  {
     res.rec_u.dontkno.iarray_len = 0;
     res.rec_u.dontkno.iarray_val = NULL;
     return(&res);
  }
/* allocate space needed for parameters */
  res.rec_u.dontkno.iarray_len = number;
  res.rec_u.dontkno.iarray_val = param_pointer = 
    (magali_iarray *) calloc(sizeof(magali_iarray) , number) ;
  for (i = 0 ; i < number ; i++)
     {
      strcpy(param_pointer[i].name, mylayer->parameters[i].name);
      param_pointer[i].value = mylayer->parameters[i].parameter.value.f ; 
     } ; 
   return(&res);
       break ;       

/* CLUSTER */
     case 3 :
       mycluster = sys[indx[0]].net[indx[1]]->layer[indx[2]]->cluster[indx[3]]  ;
       number = mycluster->n_parameters ;
/* if no parameters */
  if (!number)
  {
     res.rec_u.dontkno.iarray_len = 0;
     res.rec_u.dontkno.iarray_val = NULL;
     return(&res);
  }
/* allocate space needed for parameters */
  res.rec_u.dontkno.iarray_len = number;
  res.rec_u.dontkno.iarray_val = param_pointer = 
    (magali_iarray *) calloc(sizeof(magali_iarray) , number) ;
  for (i = 0 ; i < number ; i++)
     {
      strcpy(param_pointer[i].name, mycluster->parameters[i].name);
      param_pointer[i].value = mycluster->parameters[i].parameter.value.f ; 
     } ; 
   return(&res);
       break ;       

/* NEURON */
     case 4 :
      myneuron = 
     sys[indx[0]].net[indx[1]]->layer[indx[2]]->cluster[indx[3]]->neuron[indx[4]];
       number = myneuron->n_parameters ;
/* if no parameters */
  if (!number)
  {
     res.rec_u.dontkno.iarray_len = 0;
     res.rec_u.dontkno.iarray_val = NULL;
     return(&res);
  }
/* allocate space needed for parameters */
  res.rec_u.dontkno.iarray_len = number;
  res.rec_u.dontkno.iarray_val = param_pointer = 
    (magali_iarray *) calloc(sizeof(magali_iarray) , number) ;
  for (i = 0 ; i < number ; i++)
     {
      strcpy(param_pointer[i].name, myneuron->parameters[i].name);
      param_pointer[i].value = myneuron->parameters[i].parameter.value.f ; 
     } ; 
   return(&res);
       break ;       

     default:   
       res.errorn = -1;
       return(&res);
       break;
  }

}

/*----------------------------------------------*/
/* REC 	GET STATE OF NEURONS			*/
/* 	PART OF RNETSTAT ( STRCTNAME )		*/
rec *
get_data(indx, code)
int *indx;
int code;
{
  static rec res;
  int i, size;
  cluster_type *clu;
  neuron_type **neu;
  float *fptr;

  xdr_free(xdr_rec, &res);

  if (code >3) {	/* exceeding the capacity of neuron states */
     res.errorn = -1;
     return(&res);
  }

  clu = sys[indx[0]].net[indx[1]]->layer[indx[2]]->cluster[indx[3]];
  size = clu->neurons;

  neu = clu->neuron;
  res.errorn = 0;
  res.rec_u.sttwgt.farray_len = size;
  res.rec_u.sttwgt.farray_val = fptr = (float *) calloc(sizeof(float), size);
  for (i=0; i<size; i++) 
   {
     *fptr++ = (*neu)->state[code].value.f ;
     neu++;
   }
  return(&res) ;
}

/*----------------------------------------------*/
/* PATRES  RREADINP/ALL ( PATFILE ) 		*/
/*  => Read an input or input and target pattern according to a filename   */
/* 		+ index within this descriptor 	*/
/*  => gives back matrix dim for input an output*/

patres *
rreadinp_1(info)
patfile  *info;
{
int display_purpose[4] ;
static patres patresult ;
int fedup ;

/* read input only */ 
  display_purpose[0] = NOTOK ;

  if(
   read_pattern(info->name , info->index , display_purpose )
	!= OK 
    )
   patresult.width[0] = -400  ;

  else 
   {
   patresult.width[0]  = display_purpose[0] ;
   patresult.height[0]  = display_purpose[1] ;
   patresult.width[1]  = display_purpose[2] ;
   patresult.height[1]  = display_purpose[3] ;
 printf("after calling readpattern width %i\n" , display_purpose[0]) ; 
 printf("hieght %i\n" , display_purpose[1]) ; 
  } ;
   return(&patresult);
}

patres *
rreadall_1(info)
patfile  *info;
{
int display_purpose[4] ;
static patres patresult ;
int fedup ;
 
/* read input AND target only */ 
  display_purpose[0] = OK ;

fedup = 
read_pattern(info->name , info->index , display_purpose ) ;

  if(fedup != OK )
    {
     patresult.width[0] = fedup;
    }

  else 
   {
   patresult.width[0]  = display_purpose[0] ;
   patresult.height[0]  = display_purpose[1] ;
   patresult.width[1]  = display_purpose[2] ;
   patresult.height[1]  = display_purpose[3] ;
 printf("after calling readpattern width %i\n" , display_purpose[0]) ; 
 printf("hieght %i\n" , display_purpose[1]) ; 
  } ;
   return(&patresult);
}

/*----------------------------------------------*/
/* INT  REEXECUTE ( INT* ) 			*/
/*   => Execute a rule 				*/
int *
rexecute_1(pointer)
int *pointer ;
{

  result = -1;
/*printf("In RPC The pointer is %i\n" , *pointer) ;*/

  result = EXEC(*pointer) ;

  return(&result) ;
}


/*----------------------------------------------*/
/* INT  RRANDWEIGHT( USELESS ) 			*/
int *
rrandweight_1(useless)
char *useless ;
{

  result = -1;
  result = rand_weight() ;

  return(&result) ;
}


/*----------------------------------------------*/
/* REC RGETANYWEIGHT( TWOINDX ) 		*/
/*  => giving two indexes (from path and to path */
/*     gives back the connectivity matrix AS FLOAT ARRAY SHOULD CHANGE */
rec *
rgetanyweight_1(rpcparameter) 
twoindx *rpcparameter ;
{
/* CONVENTION Assignment of 1 000 000 to show NO CONNECTION */

 static rec weightresult ;
 int i , j , t , size ; 
 int from[4] ;  /* path showing from where at CLUSTER LEVEL*/
 int to[4] ;    /* neuron path showing to where */
 int fromclusters ;
 neuron_type *theneuron ;
 synapse_type **synapses ;
 float *pointeur ;

  xdr_free(xdr_rec, &weightresult);

 for( i = 0 ; i < 4 ; i++)
  {
   from[i] = rpcparameter->fromindx[i] ;
   to[i] = rpcparameter->toindx[i] ;
  } ;
  from[3] = 0 ; /* first neuron of that cluster */

/* assign theneuron to point to the correct one */

/* fromclusters is the number of neurons of the FROM cluster */
  fromclusters = 
       sys[0].net[from[0]]->layer[from[1]]->cluster[from[2]]->neurons ;

/* pointer to the neuron TO */
  theneuron = sys[0].net[to[0]]->layer[to[1]]->cluster[to[2]]->neuron[to[3]];

/* number of input neuron associated with neuron TO */
  size = theneuron->fanin ;

/* pointer to the neuron TO */
  synapses = theneuron->synapse ;

  weightresult.errorn = 0;
  weightresult.rec_u.sttwgt.farray_len = fromclusters ;
  weightresult.rec_u.sttwgt.farray_val = pointeur = 
    			(float *) calloc(sizeof(float), fromclusters);


/* for all the neuron in the FROM cluster */
  for ( j = 0 ;  j < fromclusters ; j++)
   { 
	pointeur[j] = 1000000 ;
   } ;

/* for all the inputneuron of the neuron TO */
    i = 0 ;
    while ( i< size)
      {
      if (
/* if the input neuron has the path equal to the FROM path CLUSTER */
           (theneuron->input_neuron[i]->route[0] == from[0])
           &&
           (theneuron->input_neuron[i]->route[1] == from[1])
           &&
           (theneuron->input_neuron[i]->route[2] == from[2])
          )
	 {
         pointeur[theneuron->input_neuron[i]->route[3]]
    		 = (*synapses)->weight.value.f ;
	 } ;
      synapses++ ;
      i++ ;
      } ;

return(&weightresult) ;
}

/*----------------------------------------------*/
/* REC RGETSPARSE( TWOINDXanSIZE ) 		*/
/*  => giving two indexes (from path and to path */
/*            the number of existing connection (where there is a value) */
/*     gives back the MINIMUM connectivity matrix AS FLOAT ARRAY CHANGE */
/* AT THE MOMENT LAYER LEVEL ONLY */
rec *
rgetsparse_1(rpcparameter) 
roadsize *rpcparameter ;
{

 static rec valueresult ;
 int i , j , t , size ; 
 int from[4] ;  /* path showing from where at CLUSTER LEVEL*/
 int to[4] ;    /* neuron path showing to where */
 int toclu , toneu , toclusters , toneurons ;
 int fromclu , fromneu , fromneurons , fromclusters ;
 int starting ;
 neuron_type *theneuron ;
 synapse_type **synapses ;
 float *pointeur ;

   fromclusters = fromneurons = fromclu = fromneu = 0  ;
   toclusters = toneurons = toclu = toneu  = 0 ;

  xdr_free(xdr_rec, &valueresult);

/* from an to path are LAYER AT THE MOMENT */
 for( i = 0 ; i < 4 ; i++)
  {
   from[i] = rpcparameter->fromroad[i] ;
   to[i] = rpcparameter->toroad[i] ;
  } ;

/* we know how many float value we need */
  valueresult.errorn = 4 ;
  valueresult.rec_u.wvalue.wvaluetype_len =  rpcparameter->size ; 
  valueresult.rec_u.wvalue.wvaluetype_val = pointeur = 
    		(float *) calloc(sizeof(float), rpcparameter->size);

/* start to fill the array at 0 */
  starting = 0 ;

switch (to[2]) 
  {
case -1 : 

/* LAYER CASE */
/* set number of clusters in layer TO and FROM */
 toclusters =  sys[0].net[to[0]]->layer[to[1]]->clusters ;
 fromclusters =  sys[0].net[from[0]]->layer[from[1]]->clusters ;

/* for all the neurons of layer TO look at the connection with */
/* 	neurons of layer FROM */

/* for all the clusters in layer TO */
/* toneuron is the number of neurons of the toclusters */

 while(toclu < toclusters )
  {
  toneurons = sys[0].net[to[0]]->layer[to[1]]->cluster[toclu]->neurons;

/* proceed for all the neurons in that cluster */
  while(toneu < toneurons )
  {
  theneuron = sys[0].net[to[0]]->layer[to[1]]->cluster[toclu]->neuron[toneu] ;

/* printf("TO neuron investigated is %i , %i , %i , %i\n" , theneuron->route[0]  */
/* , theneuron->route[1]  , theneuron->route[2]  , theneuron->route[3]) ; */

/* pointer to the neuron TO */
  synapses = theneuron->synapse ;

/* set */
fromneu = fromclu = 0 ;
/* number of neurons in the first FROM cluster */
fromneurons =  sys[0].net[from[0]]->layer[from[1]]->cluster[fromclu]->neurons ;

/* for all the inputneuron of that neuron TO */
    t = 0 ; 
    while ( t < theneuron->fanin && fromclu < fromclusters)
      {
/* if statement */         
      if (
/* if the input neuron has the path equal to the FROM path CLUSTER */
           (theneuron->input_neuron[t]->route[0] == from[0])
           &&
           (theneuron->input_neuron[t]->route[1] == from[1])
           &&
           (theneuron->input_neuron[t]->route[2] == fromclu )
           &&
           (theneuron->input_neuron[t]->route[3] == t)
          )
	 {
         pointeur[starting] = (*synapses)->weight.value.f ;
         starting++ ;
	 } ;
/* printf("FROM neuron investigated is %i , %i , %i , %i\n" , from[0] , */
/*          from[1] , fromclu , t) ; */
      synapses++ ;
      t++ ;
      fromneu++ ;
/* if end of the current fromclu go to the next one */
        if (fromneu >= fromneurons)
                {
                fromclu++ ; /* next cluster */
                if (fromclu < fromclusters)
                  {
                  fromneurons =
                   sys[0].net[from[0]]->layer[from[1]]->cluster[fromclu]->neurons;
                  fromneu = 0 ;
                  } ;
                } ;
    } ;
    toneu++ ;
  } ;
  toclu++ ;
 } ;

  return(&valueresult) ;
  break ;
/* end LAYER CASE */

  default :

/* CLUSTER CASE */
  toneurons = sys[0].net[to[0]]->layer[to[1]]->cluster[to[2]]->neurons;
  fromneurons =  sys[0].net[from[0]]->layer[from[1]]->cluster[from[2]]->neurons ;

/* proceed for all the neurons in that cluster */
  while(toneu < toneurons )
  {
  theneuron = sys[0].net[to[0]]->layer[to[1]]->cluster[toclu]->neuron[toneu] ;

/*printf("TO neuron investigated is %i , %i , %i , %i\n" , theneuron->route[0] 
	 , theneuron->route[1]  , theneuron->route[2]  , theneuron->route[3]) ;*/

/* pointer to the neuron TO */
  synapses = theneuron->synapse ;

/* for all the inputneuron of that neuron TO */
    t = 0 ; 
    while ( t < theneuron->fanin )
      {
/* if statement */         
      if (
/* if the input neuron has the path equal to the FROM path CLUSTER */
           (theneuron->input_neuron[t]->route[0] == from[0])
           &&
           (theneuron->input_neuron[t]->route[1] == from[1])
           &&
           (theneuron->input_neuron[t]->route[2] == from[2] )
           &&
           (theneuron->input_neuron[t]->route[3] == t)
          )
	 {
         pointeur[starting] = (*synapses)->weight.value.f ;
         starting++ ;
	 } ;
/*printf("FROM neuron investigated is %i , %i , %i , %i\n" , from[0] ,
         from[1] , fromclu , t) ;*/
      synapses++ ;
      t++ ;
    } ;
    toneu++ ;
 } ;


  return(&valueresult) ;
  break ;

  } ;
/* END CASE */

}

/*----------------------------------------------*/
/* REC RGETBITWEIGHT( TWOINDX )                 */
/*  => giving two indexes (from path and to path */
/*     gives back the connectivity matrix AS BIT ARRAY */
rec *
rgetbitweight_1(rpcparameter)
twoindx *rpcparameter ;
{

 static rec bitresult ;
 int i , j , t , location ; 
 int from[4] ;  /* path showing from where at CLUSTER LEVEL*/
 int to[4] ;    /* neuron path showing to where */
 int toclu , toneu , toclusters , toneurons ;
 int fromclu , fromneu , fromneurons , fromclusters ;
 int total , tototalneurons , fromtotalneurons ;
 int manyint ;
 neuron_type *theneuron ;
 unsigned *pointeur ;

 toneu = toclu = toclusters = toneurons = 0 ;
 fromneu = fromclu = fromclusters = fromneurons = 0 ;
 total = tototalneurons = fromtotalneurons = 0 ;


  xdr_free(xdr_rec, &bitresult);

/* from an to path are LAYER AT THE MOMENT */
 for( i = 0 ; i < 4 ; i++)
  {
   from[i] = rpcparameter->fromindx[i] ;
   to[i] = rpcparameter->toindx[i] ;
  } ;

/* Declare and allocate the bit array */
  bitresult.errorn = 3;

/* find the total number of neurons to get the number of bits needed */
   switch (to[2])
     {
     case -1 : 
/* Connection between LAYERS */
 toclusters =  sys[0].net[to[0]]->layer[to[1]]->clusters ;
 for (i = 0 ; i < toclusters ; i++)
  {
  tototalneurons = sys[0].net[to[0]]->layer[to[1]]->cluster[i]->neurons 
			+ tototalneurons ;
  } ;
 fromclusters =  sys[0].net[from[0]]->layer[from[1]]->clusters ;
 for (i = 0 ; i < fromclusters ; i++)
  {
  fromtotalneurons = 
	sys[0].net[from[0]]->layer[from[1]]->cluster[i]->neurons 
			+ fromtotalneurons ;
  } ;
 total = tototalneurons * fromtotalneurons ;
/* end case LAYER */
      break ;

/* Connection between CLUSTERS */
     default :
  tototalneurons = sys[0].net[to[0]]->layer[to[1]]->cluster[i]->neurons ;
	  fromtotalneurons = 
		sys[0].net[from[0]]->layer[from[1]]->cluster[i]->neurons  ;
  total = tototalneurons * fromtotalneurons ;
/* end case CLUSTER */
      break ;

      } ;
/* end CASE */

/* Allocation of the bit array */
/*printf("how many neurons ie bits to have ? %i\n" , total ) ;
printf("how many bits in an int ? %i\n" , howmanybits) ;*/

/* how many int for "total" bits */
  manyint = total / howmanybits + 1 ;
/*	printf(" how many int to code all bits %i\n" , manyint ) ;*/

  bitresult.rec_u.bitconnect.bitweight_len = manyint ;
  bitresult.rec_u.bitconnect.bitweight_val = pointeur =
                        (unsigned *)
                        calloc(sizeof(unsigned), manyint);

/* for all the neuron-BIT */
/* assign bit value 0 => no connection */
  for ( j = 0 ;  j < manyint; j++)
   {
        pointeur[j] = 0 ;
   } ;

   switch (to[2])
     {
     case -1 : 
/* Connection between LAYERS */
/* for all the neurons of layer TO look at the connection with */
/* 	neurons of layer FROM */
/* for all the clusters in layer TO */
/* toneuron is the number of neurons of the toclusters */

 while (toclu < toclusters) 
  {
  toneurons = sys[0].net[to[0]]->layer[to[1]]->cluster[toclu]->neurons;

/* proceed for all the neurons in that cluster */
  while (toneu < toneurons )
  {
  theneuron = sys[0].net[to[0]]->layer[to[1]]->cluster[toclu]->neuron[toneu] ;

/*printf("To neuron investigated is %i  %i  %i %i\n" , theneuron->route[0] ,
        theneuron->route[1] ,  theneuron->route[2] ,  theneuron->route[3] ) ;*/
 
/* set */
 fromclu = 0 ; /* first cluster */
 fromneu = 0 ; /* first neuron */
 fromneurons = sys[0].net[from[0]]->layer[from[1]]->cluster[fromclu]->neurons ;
 		/* number of neurons of the first cluster */
 t = 0 ; 

/* printf("how many input for that TO neuron %i \n" , theneuron->fanin) ;*/

/* for all the inputneuron of that neuron TO */
    while ( t < theneuron->fanin && fromclu < fromclusters )
      {
/* if statement */         
      if (
/* if the input neuron has the path equal to the FROM path CLUSTER */
           (theneuron->input_neuron[t]->route[0] == from[0])
           &&
           (theneuron->input_neuron[t]->route[1] == from[1])
           &&
           (theneuron->input_neuron[t]->route[2] == fromclu )
           &&
           (theneuron->input_neuron[t]->route[3] == t )
          )
	 {
/* there is a connection for the route theneuron->input_neuron[i]->route[3] */
/* assign the bit at that position to be 1 */

/* which int contains that bit */
        location =  (t+ (toneu * fromtotalneurons)) / howmanybits ;
/*printf("location is %i  " , location) ;*/
/* assign  1 to the correct bit */
        pointeur[location] |= 1 << 
	   (t+ (toneu * fromtotalneurons)) % howmanybits ;

/*printf("BIT location %i  " ,
	(t + (toneu * fromtotalneurons)) % howmanybits  ) ;*/
	 } ;
/*printf("FROM neuron investigated is %i %i %i %i \n" , from[0] , from[1] ,
		fromclu , t ) ;*/

/*end of  if statement */         
         t++ ;
   	fromneu++ ;
/* if end of the current fromclu go to the next one */
	if (fromneu >= fromneurons)
		{
		fromclu++ ; /* next cluster */
                if (fromclu < fromclusters)
		  {
		  fromneurons = 
		   sys[0].net[from[0]]->layer[from[1]]->cluster[fromclu]->neurons;
		  fromneu = 0 ;
 		  } ;
		} ; 
    } ;
    toneu++ ;
   } ;
   toclu++ ;
  } ;

  return(&bitresult) ;
  break ;
/* end LAYER connection */

  default :
/* Connection CLUSTERS */
/* proceed for all the neurons in that cluster */
  toneu = 0 ; 
  toneurons =  sys[0].net[to[0]]->layer[to[1]]->cluster[to[2]]->neurons;
  fromneurons =  sys[0].net[from[0]]->layer[from[1]]->cluster[from[2]]->neurons;
  
  while (toneu < toneurons )
  {
  theneuron = sys[0].net[to[0]]->layer[to[1]]->cluster[toclu]->neuron[toneu] ;

/*printf("To neuron investigated is %i  %i  %i %i\n" , theneuron->route[0] ,
        theneuron->route[1] ,  theneuron->route[2] ,  theneuron->route[3] ) ;*/

 t = 0 ;

/* printf("how many input for that TO neuron %i \n" , theneuron->fanin) ;*/
/* for all the inputneuron of that neuron TO */
  while ( t < theneuron->fanin )
      {
/* if statement */
      if (
/* if the input neuron has the path equal to the FROM path CLUSTER */
           (theneuron->input_neuron[t]->route[0] == from[0])
           &&
           (theneuron->input_neuron[t]->route[1] == from[1])
           &&
           (theneuron->input_neuron[t]->route[2] == from[2] )
           &&
           (theneuron->input_neuron[t]->route[3] == t )
          )
         {
/* there is a connection for the route theneuron->input_neuron[i]->route[3] */
/* assign the bit at that position to be 1 */
/* which int contains that bit */
        location =  (t+ (toneu * fromneurons)) / howmanybits ;
/*printf("location is %i  " , location) ;*/
/* assign  1 to the correct bit */
        pointeur[location] |= 1 <<
           (t+ (toneu * fromneurons)) % howmanybits ;

/*printf("BIT location %i  " ,
        (t + (toneu * fromneurons)) % howmanybits  ) ;*/
         } ;
/*	printf("FROM neuron investigated is %i %i %i %i \n" , from[0] , from[1] 
			, from[2] , t ) ;*/

/*end of  if statement */
         t++ ;
         } ;
      toneu++ ;
     } ;

  return(&bitresult) ;
	} ;
/* End CASE */

}


/*----------------------------------------------*/
/* INT RTERMINATESERV(  )			*/
/* 	Terminate the server 			*/

int*
rterminateserv_1(needed)
int needed ;
{
  exit(1) ;
 }
