/******************************************************************************/
/**									     **/
/**		      Copyright 1989 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name of The Department of Computer Science,  **/
/** University College London not be used in advsrtising or publicity of the **/
/** software without specific, written prior permission.		     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.0 24/11/89 mjh
 *
 * pgm system level graphic drawing
 *
 * system_level.c
 ******************************************************************************/

#include "mike_display.h"
#include "everything.h"


extern confres *conf;


/* function that draws the system level in the graphic window.  Takes 
 * the full area, unless a connection matrix being shown, in which case,
 * the horizontal shrinks to a half the window width. i.e. if connection
 * matrix needs to be shown pass this function area_width which is half
 * xwa.width, rather than the the whole.  Mostly only ever have one net, 
 * but as this is supposed to be a greneral tool, then we have to 
 * provide for more than one.
 */


void draw_system(w, gc, cmap, mikepath, area_width, win_height, sys_low_color, sys_high_color)
Widget w;
GC gc;
Colormap cmap;
int mikepath[4];
int area_width;
int win_height;
char sys_low_color;
char sys_high_color;
{
	float temp;
	int number_horizontal, number_vertical;
	int net_width, net_height;
	int number_nets, nets_drawn;
	int i,j;
	rpcsys *rpcconf;
	char textlabel[512];
	float *first_attribute;
	float neuron_color_scale[2];
	float neuron_color_multiply;

	int number_of_shades = 20;
	
	rpcconf = conf->confres_u.sys;

	number_nets = GiveNumber(mikepath);
	
	first_attribute = (float *) calloc(sizeof(float), number_nets);

/* the following loop just gives the nets a 0.0 color - we do not show state 
 * or the weight etc of the total net
 */
 	for(i=0; i<number_nets; i++)
	{
		first_attribute[i] = 0.0;
	}
	

/* deal with error case, and none standard cases first. That is, if called 
 * with zero nets, or with one to three nets - easier to draw in the
 * last case
 */

	if(number_nets == 0)
	{
		/* no nets to display! - should never get called! */
		Error(18);
		return;
	}
	else if((number_nets == 1) || (number_nets == 2) || (number_nets == 3))
	     {
		for(i=0; i<number_nets; i++)
		{	
			
			set_color(w, mikepath, gc, cmap, sys_low_color, sys_high_color, first_attribute[0]);
			XSetForeground(dpy, gc, my_fg.pixel);
			XDrawRectangle(dpy, gra_win, gc, (area_width/5)-2, ((win_height/5)*(i+1))-2, ((3*area_width)/5)+4, (win_height/6)+4);
			XSetForeground(dpy, gc, my_drawing_color.pixel);
			XFillRectangle(dpy, gra_win, gc, (area_width/5), ((win_height/5)*(i+1)), ((3*area_width)/5), (win_height/6));
			XSetForeground(dpy, gc, my_fg.pixel);
			sprintf(textlabel, "%i", i+1);
			XDrawImageString(dpy, gra_win, gc, (area_width/5)+20, ((win_height/5)*(i+1))-5, textlabel, strlen(textlabel));
			
		}
	     }
	     else if(number_nets > 3)
	     	  {

/* find out the size of rectangular area to fit nets in.
		   * the box may of course not be completely full, but it
		   * will hold all
		   */
		  	temp = sqrt((double) number_nets);
			number_horizontal = temp;
			number_vertical = number_horizontal+1;
			
		/* for the next lines, borders are equivalent to one net width/height each */

			net_width = area_width / (number_horizontal+2);
			if(net_width < 2)
			{	
				/* window too narrow to draw anything useful */
				Error(15);
			}
			net_height = (win_height-60) / (number_vertical+2);
			if(net_height < 2)
			{	
				/* window is too short to draw anyhting useful */
				Error(16);
			}

		        XSetForeground(dpy, gc, my_fg2.pixel);
		        XClearArea(dpy, gra_win, 0, win_height-19, area_width, 18, False);
		        XDrawImageString(dpy, gra_win, gc,  5, win_height -5, "wait...", strlen("wait..."));

			

		/* now we've got the size of a net, draw them */

			XSetForeground(dpy, gc, my_fg.pixel);
			for(i=0, nets_drawn=0; i< number_horizontal; i++)
				{
					for(j=0; j<number_vertical && nets_drawn<number_nets; j++, nets_drawn++)
					{
						XFillRectangle(dpy, gra_win, gc, (net_width*(i+1)), (net_height*(j+1)), ((9*net_width)/10), ((9*net_height)/10));
						XDrawRectangle(dpy, gra_win, gc, (net_width*(i+1))-2, (net_height*(j+1))-2, ((9*net_width)/10)+4, ((9*net_height)/10)+4);
						
						if((net_height > 16) && (net_width >16))
						{
							set_color(w, mikepath, gc, cmap, sys_low_color, sys_high_color, first_attribute[nets_drawn]);
							XSetForeground(dpy, gc, my_drawing_color.pixel);
							sprintf(textlabel, "%i", nets_drawn+1);
							XDrawImageString(dpy, gra_win, gc, (net_width*(i+1))+20, (net_height*(j+1)), textlabel, strlen(textlabel));
						}
					}
				}
		  }
/* box around nets */
               	XSetForeground(dpy, gc, my_fg.pixel);
		XDrawRectangle(dpy, gra_win, gc, net_width-2, net_height-2, (number_horizontal+1)*net_width+3, (number_vertical+1)*net_height+3);

	shade_scale(w, mikepath, area_width, win_height, sys_low_color, sys_high_color, number_of_shades);
	XSetForeground(dpy, gc, my_fg.pixel);
        XClearArea(dpy, gra_win, 0, win_height-19, area_width, 18, False);
	sprintf(textlabel, "%c ->  %c  Shading", sys_low_color, sys_high_color);
	XDrawImageString(dpy, gra_win, gc, 5, win_height -5, textlabel, strlen(textlabel));

	free(first_attribute);
	return;
}



/* function that draws a matrix of the connection and weights of aforementioned 
 * between the output neurons of one net and the input neurons of another.  The 
 * two nets are selected by widget stuff.  If this function is called then
 * the above function, draw_system must be called also, with a win_width half that
 * of the actual window.  Then the system will be drawn, scaled horizontally to fit
 * in the left half of the window
 */




void draw_system_connection(w, gc, cmap, mikepath, connpath1, connpath2, area_width, win_height, sys_low_color, sys_high_color)
Widget w;
GC gc;
Colormap cmap;
int mikepath[4];
int connpath1[4];
int connpath2[4];
int area_width;
int win_height;
char sys_low_color;
char sys_high_color;
{

	int neuron_width, neuron_height;
	int neuron_drawing_width, neuron_drawing_height;
	int neurons_in_layer_netA, neurons_in_layer_netB;
	int neurons_netA, neurons_netB;
	int total_neurons_A, total_neurons_B;
	int number_clusters_netA, number_clusters_netB;
	int number_clusters_in_layer_netA, number_clusters_in_layer_netB;
	int number_layers_netA, number_layers_netB;
	int shift;		
	int i, j;
	rpcsys *rpcconf;
	char textlabel[512];
	float *first_attribute;
	float *second_attribute;
	float *weight_attribute;
	float neuron_color_scale[2];
	float weight_color_scale[2];
	float neuron_color_multiply;
	float weight_color_multiply;
	int normalize[2];

	int label_increment = 10;
	int number_of_shades = 20;
	rpcconf = conf->confres_u.sys;

	if((connpath2[0] - connpath1[0]) != 1)
	{
		/* nets are not connected so produce an error */
		Error(17);
		return;
	}
	else 
	{
		shift = area_width/2;
		
		/* want to divide the two areas, so draw aline on the left of this area */
	
		XSetForeground(dpy, gc, my_fg.pixel);
		XSetLineAttributes(dpy, gc, 0, LineSolid, CapRound, JoinMiter);
		XDrawLine(dpy, gra_win, gc, shift, 0, shift, win_height);

		number_layers_netA = GiveNumber(connpath1);

		/* next line assumes the output from netA is the last layer */

		number_clusters_in_layer_netA = rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[number_layers_netA - 1].rpclay_len;
		for(i=0, neurons_in_layer_netA=0; i< number_clusters_in_layer_netA; i++)
		{
			neurons_in_layer_netA += rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[number_layers_netA - 1].rpclay_val[i].rpcclu_len;
		}

		
		/* the next lines assume theinput of netB is it's first layer ie layer 0 */
		
		number_clusters_in_layer_netB = rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[0].rpclay_len;
		for(j=0, neurons_in_layer_netB=0; j<number_clusters_in_layer_netB; j++)
		{	
			neurons_in_layer_netB += rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[0].rpclay_val[j].rpcclu_len;
		}

/* need to calculate the total number of neurons in a net, not just in the layer so can use SetToState call*/
		neurons_netA = GiveTotal(GiveLevel(connpath1), connpath1);
		neurons_netB = GiveTotal(GiveLevel(connpath2), connpath2);

		first_attribute = (float *) calloc(sizeof(float), neurons_netA);
		second_attribute = (float *) calloc(sizeof(float), neurons_netB);
	/* make the assumption of full connectivity here! */
		weight_attribute = (float *) calloc(sizeof(float), (neurons_netA*neurons_netB));

/* want to get the state information for the two layers - the next lines get the states of all the neurons in a  layer */

		SetToState(connpath1, first_attribute);
		SetToState(connpath2, second_attribute);
		SetToWeight(connpath1, connpath2, weight_attribute);

		GiveNeuronScaleFamily(mikepath, neuron_color_scale);
		GiveWeightScaleFamily(mikepath, weight_color_scale);

		
		neuron_color_multiply = 1/(neuron_color_scale[1]-neuron_color_scale[0]);
		weight_color_multiply = 1/(weight_color_scale[1]-neuron_color_scale[0]);

		neuron_width = ((shift)-50) / (neurons_in_layer_netB+2) ;
		if(neuron_width < 2)
		{	
			/* window too narrow to draw correctly */
			Error(15);
		}

		neuron_height = (win_height-60) / (neurons_in_layer_netA+2);
		if(neuron_height < 2)
		{	
			/* window too short */
			Error(16);
		}

		neuron_drawing_height = ((9*neuron_height)/10);
		neuron_drawing_width = ((9*neuron_width)/10);
		
/* the first layer is easy, as all the states are at the beginning of first_attribute*/

		XSetForeground(dpy, gc, my_fg.pixel);
		sprintf(textlabel, "Net %i", connpath2[0]+1);
		XDrawImageString(dpy, gra_win, gc, (area_width-50), neuron_height, textlabel, strlen(textlabel));
		
		for(i=0; i< neurons_in_layer_netB; i+=label_increment)
		{
			XDrawLine(dpy, gra_win, gc, (((2+i)*neuron_width)+shift+50), 14, (((2+i)*neuron_width)+shift+50), 30);
			sprintf(textlabel, "%i", i+1);
			XDrawImageString(dpy, gra_win, gc, (((2+i)*neuron_width)+shift+50), 12, textlabel, strlen(textlabel));
		}

		for(i=0; i<neurons_in_layer_netB; i++)
		{
			set_color(w, mikepath, gc, cmap, sys_low_color, sys_high_color, ((first_attribute[neurons_netB - neurons_in_layer_netB +i]-neuron_color_scale[0])*neuron_color_multiply));
			XSetForeground(dpy, gc, my_drawing_color.pixel);
			XFillRectangle(dpy, gra_win, gc, (((2+i)*neuron_width)+shift+50), (30+neuron_height), neuron_drawing_width, neuron_drawing_height);
		}

		free(first_attribute);

/* horizontal bar done now the vertical one */

		XSetForeground(dpy, gc, my_fg.pixel);
		sprintf(textlabel, "Net %i", connpath1[0]+1);
		XDrawImageString(dpy, gra_win, gc, (neuron_width+shift), (win_height-20),  textlabel, strlen(textlabel));
		
		for(j=0; j<neurons_in_layer_netA; j+= label_increment)
		{
			 XDrawLine(dpy, gra_win, gc, (30+shift), ((2+j)*neuron_height)+40, (50+shift), ((2+j)*neuron_height)+40);
			 sprintf(textlabel, "%i", j+1);
			 XDrawImageString(dpy, gra_win, gc, (5+shift), ((2+j)*neuron_height)+40, textlabel, strlen(textlabel));
		}

		for(j=0; j<neurons_in_layer_netA; j++)
		{
			set_color(w, mikepath, gc, cmap, sys_low_color, sys_high_color, (second_attribute[j]-neuron_color_scale[0])*neuron_color_multiply);
			XSetForeground(dpy, gc, my_drawing_color.pixel);
			XFillRectangle(dpy, gra_win, gc, (shift+50), ((2+j)*neuron_height)+40, neuron_drawing_width, neuron_drawing_height);
		}
		free(second_attribute);


		for(i=0; i<neurons_in_layer_netB; i++)
		{
			for(j=0; j<neurons_in_layer_netA; j++)
			{
				set_color(w, mikepath, gc, cmap, sys_low_color, sys_high_color, (weight_attribute[(i*neurons_in_layer_netA)+j]-weight_color_scale[0])*weight_color_multiply);
				XSetForeground(dpy, gc, my_drawing_color.pixel);
				XFillRectangle(dpy, gra_win, gc, (((2+i)*neuron_width)+shift+50), ((2+j)*neuron_height)+40, neuron_drawing_width, neuron_drawing_height);
			}
		}
	}
	free(weight_attribute);

	XSetForeground(dpy, gc, my_fg.pixel);
	shade_scale(w, mikepath, area_width, win_height, sys_low_color, sys_high_color, number_of_shades);
	sprintf(textlabel, "Weight (%f,%f)", weight_color_scale[0], weight_color_scale[1]);
	XDrawImageString(dpy, gra_win, gc, (shift +5),	win_height -5, textlabel, strlen(textlabel));


	return ;
}

