/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * the nC specific's HLL window
 ******************************************************************************/

#include "everything.h"
#include "myheader.h"
#include "mymonitor.h"
#include "mike_display.h"

/* top widget, form widget (nCtop)
 * First children = Command area, form widget (nCcommand) :
 *   Title, label widget  (nCtitle)
 *   algorithm, command widget (nCalgo) CREATED in file nCalgo_control.c
 *   config, command widget (nCconfig) 
 *   quit , command widget (nCquit) 
 *   editor, command widget (nCedit) 
 *   nCgenill, command widget (nClint) 
 * Second children = Parameters area, form widget (nCparam)
 *   algo text, asciiString widget (algo_text) 
 *   algo file , label widget (algo_param) 
 *   config text, asciiString widget (config_text) 
 *   config file , label widget (config_param) 
*/
/* Global => has to be known by AddInformation */
Widget nCfakespec,
		  algo_text,  algo_param ,
		  config_text , config_param ;

Widget  nCtop ,
	  nCcommand,
		nCtitle,
		nCalgo , nCconfig , nCquit ,
		nCedit , nCgenill ;

extern Widget lload;
extern Arg lload_arg[];

/*-----------------------------------------------------*/
/* CALLBACK FOR nClint 					*/
/*-----------------------------------------------------*/
void nCgenill_callback(w, client_data, call_data)
Widget w;
caddr_t client_data;  /* not used */
caddr_t call_data;    /* not used */
{
  printf("nCgenill called\n") ;
}

/* callback for widget */
	static XtCallbackRec nCgenillcallback[] = {
		{nCgenill_callback, NULL},
		{NULL, NULL},
	};

/* Args for pause widget */
	static Arg nCgenill_arg[] = {
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNfromVert, (XtArgVal)NULL},
		{XtNcallback, (XtArgVal)nCgenillcallback},
		{XtNhighlightThickness, (XtArgVal)3},
		{XtNhorizDistance, (XtArgVal)DISTANCE_HORIZ},
		{XtNvertDistance, (XtArgVal)2},
		{XtNwidth, (XtArgVal)BUTTON_WIDTH+40}, 
		{XtNheight, (XtArgVal)BUTTON_HEIGHT}, 
		{XtNsensitive, (XtArgVal) False},
	};

/*-----------------------------------------------------*/
/* CALLBACK FOR  nCedit					*/
/*-----------------------------------------------------*/
void nCedit_callback(w, client_data, call_data)
Widget w;
caddr_t client_data;  /* not used */
caddr_t call_data;    /* not used */
 {

  Take_input(w,7) ;
 }

/* callback for widget */
  static XtCallbackRec nCeditcallback[] = 
	{
		{nCedit_callback, NULL},
		{NULL, NULL},
	};

/* Args for nCedit widget */
	static Arg nCedit_arg[] = 
	{
		{XtNfromVert, (XtArgVal)NULL},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNcallback, (XtArgVal)nCeditcallback},
		{XtNhighlightThickness, (XtArgVal)3},
		{XtNhorizDistance, (XtArgVal)DISTANCE_HORIZ},
		{XtNvertDistance, (XtArgVal)2},
		{XtNwidth, (XtArgVal)BUTTON_WIDTH+40}, 
		{XtNheight, (XtArgVal)BUTTON_HEIGHT}, 
	};

/*-----------------------------------------------------*/
/* CALLBACK FOR  nCquit 				*/
/*-----------------------------------------------------*/
void nCquit_callback(w, client_data, call_data)
Widget w;
Widget client_data;  /* nC top level window */
caddr_t call_data;    /* not used */
 {
/* no more HLL langage choosen */
 strcpy(hlang , "was nC") ;
 Add_information(0,hlang) ;
/* pop down the nC top level window */
 XtPopdown(client_data) ;

 }

/* the callback as argument is defined after the initialisation of the */
/* widgets => I pop them down */

/* Args for nCquit widget */
	static Arg nCquit_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNcallback, (XtArgVal)NULL},
		{XtNhighlightThickness, (XtArgVal)3},
		{XtNhorizDistance, (XtArgVal)DISTANCE_HORIZ},
		{XtNvertDistance, (XtArgVal)2},
		{XtNwidth, (XtArgVal)BUTTON_WIDTH+40}, 
		{XtNheight, (XtArgVal)BUTTON_HEIGHT}, 
	};

/*-----------------------------------------------------*/
/* CALLBACK FOR  nCconfig				*/
/*-----------------------------------------------------*/
void nCconfig_callback(w, client_data, call_data)
Widget w;
caddr_t client_data;  /* not used */
caddr_t call_data;    /* not used */
 {

 if (!my_algorithm)  Error(4)  ;
 else
   Take_input(w,2) ;
 }

/* callback for widget */
	static XtCallbackRec nCconfigcallback[] = {
		{nCconfig_callback, NULL},
		{NULL, NULL},
	};

/* Args for nCconfig widget */
	Arg nCconfig_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNcallback, (XtArgVal)nCconfigcallback},
		{XtNhighlightThickness, (XtArgVal)3},
		{XtNhorizDistance, (XtArgVal)DISTANCE_HORIZ},
		{XtNvertDistance, (XtArgVal)2},
		{XtNwidth, (XtArgVal)BUTTON_WIDTH+40}, 
		{XtNheight, (XtArgVal)BUTTON_HEIGHT}, 
                {XtNsensitive, (XtArgVal)False},

	};

/*-----------------------------------------------------*/
/* CALLBACK FOR  nCalgorithm				*/
/*-----------------------------------------------------*/
void nCalgo_callback(w, client_data, call_data)
Widget w;
caddr_t client_data;  /* not used */
caddr_t call_data;    /* not used */
 {
/* Initialise the set of algorithm available */
  SetAlgorithm() ;

/* Display the set of "files" to select */
  SelectAlgo(w) ;
 
 }

/* callback for widget */
	static XtCallbackRec nCalgocallback[] = {
		{nCalgo_callback, NULL},
		{NULL, NULL},
	};

/* CAUTION = Those arguments are used within AddInformation.c */
/*	case 5 */
/* Args for nCalgo widget */
	static Arg nCalgo_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNcallback, (XtArgVal)nCalgocallback},
		{XtNhighlightThickness, (XtArgVal)3},
		{XtNhorizDistance, (XtArgVal)DISTANCE_HORIZ},
  		{XtNvertDistance, (XtArgVal)2},
		{XtNwidth, (XtArgVal)BUTTON_WIDTH+40}, 
		{XtNheight, (XtArgVal)BUTTON_HEIGHT}, 
	};

/*----------------------------------------------------*/
/* ARGUMENT FOR THE PARAM FALSE COMMAND WIDGET 		*/
/*-----------------------------------------------------*/
/* CAUTION CAUTION  CAUTION CAUTION  CAUTION CAUTION  */
/*-----------------------------------------------------*/
/* The following parameters are used within the file 
/* AddInformation.c to change the XtNlabel param*/
/* Furthermore if you change the size you have to change */
/* it in the the AdddInformationfile */
/* MOREOVER these arguments are no more STATIC !!!!!!! */

/* Args for algo_text widget */
	static Arg algotext_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
 	        {XtNlabel, (XtArgVal)"Algorithm :   "},
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyRight}, 
	};
/* Args for algo_param widget */
	 Arg algoparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)"None Selected" },
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)(2*INFO_WIDTH)}, 
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNresize, (XtArgVal)False}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyLeft}, 
	};
 
/* Args for config_text widget */
	static Arg configtext_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
 	        {XtNlabel, (XtArgVal)"Configuration:   "},
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyRight}, 
	};

/* Args for config_param widget */
	 Arg configparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)"None Loaded " },
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)(2*INFO_WIDTH)}, 
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNresize, (XtArgVal)False}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyLeft}, 
	};

/*----------------------------------------------------*/
/*  		THE nC TOP WINDOW PROCEDURE		*/
/*----------------------------------------------------*/
void nCtop_proc(parent)
Widget parent ;
{

/*                nCfakespec,
 *		  algo_text,  algo_param 
 *		  config_text   config_param 
 */
/* Args for nCtitle widget */
	static Arg nCtitle_arg[] = {
		{XtNlabel, (XtArgVal)"HLL : nC Specifics "},
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNresizable, (XtArgVal)True}, 
		{XtNheight, (XtArgVal)TITLE_HEIGHT}, 
		{XtNwidth, (XtArgVal)TITLE_WIDTH}, 
		{XtNborderWidth, (XtArgVal) 3},
	};


/*----------------------------------------------------*/
/* ARGUMENT FOR THE nCtop and nCcommand WIDGET		*/ 
/*----------------------------------------------------*/

static Arg nCtop_arg[] = {
/* Rubbish arg */
                {XtNdestroyCallback, (XtArgVal)NULL},
	} ;

static Arg nCcommand_arg[] = {
/* Rubbish arg */
                {XtNdestroyCallback, (XtArgVal)NULL},
	} ;

static Arg nCfakespec_arg[] = {
 	        {XtNfromVert, (XtArgVal)NULL},
 	        {XtNfromHoriz, (XtArgVal)NULL},
 	        {XtNvertDistance, (XtArgVal)1},
 	        {XtNhorizDistance, (XtArgVal)1},
		{XtNresizable, (XtArgVal)True}, 
		{XtNwidth, (XtArgVal)TITLE_WIDTH}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
	} ;
/*----------------------------------------------------*/
/* ARGUMENT FOR THE TOP LEVEL WIDGET			*/ 
/*----------------------------------------------------*/
/*
 * ie colours 
 */
static Arg toplevel_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
	} ;

/*-----------------------------------
 * TRY MENU POP UP AS A NEW TRANSLATION TABLE
 * ASSOCIATED WITH CREATE
 */
/*Declaration of the new translation table */
static String new_trans = "<Btn1Up>:notify()" ;

/* Declaration of the new COMPILED translation table */
XtTranslations new_compiled ;


	nCtop = XtCreatePopupShell("PGM: nC",
				shellWidgetClass,
				parent,
				nCtop_arg,
				XtNumber(nCtop_arg));
 

	nCcommand= XtCreateManagedWidget("simulation",
				formWidgetClass,
				nCtop,
				nCcommand_arg,
				XtNumber(nCcommand_arg));


	    nCtitle= XtCreateManagedWidget("title",
				labelWidgetClass,
				nCcommand,
				nCtitle_arg,
				XtNumber(nCtitle_arg));


 XtSetArg(nCalgo_arg[1],XtNfromHoriz, NULL) ; 
 XtSetArg(nCalgo_arg[0],XtNfromVert, nCtitle) ; 

	nCalgo = XtCreateManagedWidget(" Algorithm ",
				commandWidgetClass,
				nCcommand,
				nCalgo_arg,
				XtNumber(nCalgo_arg));


 XtSetArg(nCconfig_arg[1],XtNfromHoriz, nCalgo) ; 
 XtSetArg(nCconfig_arg[0],XtNfromVert, nCtitle) ; 

       nCconfig	 = XtCreateManagedWidget(" Configuration ",
				commandWidgetClass,
				nCcommand,
				nCconfig_arg,
				XtNumber(nCconfig_arg));

 XtSetArg(nCquit_arg[1],XtNfromHoriz, nCconfig) ; 
 XtSetArg(nCquit_arg[0],XtNfromVert, nCtitle) ; 

       nCquit  = XtCreateManagedWidget(" Quit nC ",
				commandWidgetClass,
				nCcommand,
				nCquit_arg,
				XtNumber(nCquit_arg));

  XtAddCallback(nCquit, XtNcallback,
                nCquit_callback, (caddr_t)nCtop) ;

 XtSetArg(nCedit_arg[1],XtNfromHoriz, NULL) ; 
 XtSetArg(nCedit_arg[0],XtNfromVert, nCalgo) ; 

	 nCedit= XtCreateManagedWidget(" Editor ",
				commandWidgetClass,
				nCcommand,
				nCedit_arg,
				XtNumber(nCedit_arg));

 XtSetArg(nCgenill_arg[1],XtNfromHoriz, nCedit) ; 
 XtSetArg(nCgenill_arg[0],XtNfromVert, nCconfig) ; 

	 nCgenill= XtCreateManagedWidget(" Generate ILL ",
				commandWidgetClass,
				nCcommand,
				nCgenill_arg,
				XtNumber(nCgenill_arg));


 XtSetArg(nCfakespec_arg[1],XtNfromHoriz, NULL) ; 
 XtSetArg(nCfakespec_arg[0],XtNfromVert, nCedit) ; 

	nCfakespec = XtCreateManagedWidget("textual stuff",
				formWidgetClass,
				nCcommand,
				nCfakespec_arg,
				XtNumber(nCfakespec_arg));

                algo_text = XtCreateManagedWidget("",
                                labelWidgetClass,
                                nCfakespec,
                                algotext_arg,
                                XtNumber(algotext_arg));

XtSetArg(algoparam_arg[2],XtNfromHoriz, algo_text) ;

                algo_param = XtCreateManagedWidget("",
                                labelWidgetClass,
                                nCfakespec,
                                algoparam_arg,
                                XtNumber(algoparam_arg));

XtSetArg(configtext_arg[0],XtNfromVert, algo_text) ;

                config_text = XtCreateManagedWidget("",
                                labelWidgetClass,
                                nCfakespec,
                                configtext_arg,
                                XtNumber(configtext_arg));

XtSetArg(configparam_arg[2],XtNfromHoriz, config_text) ;
XtSetArg(configparam_arg[0],XtNfromVert, algo_text) ;

                config_param = XtCreateManagedWidget("",
                                labelWidgetClass,
                                nCfakespec,
                                configparam_arg,
                                XtNumber(configparam_arg));





/* Realise */
  XtPopup(nCtop , XtGrabNone) ;

  
}

