/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 30/1/90
 *
 * initialisation and instantiation
 *
 * main.c	mjh/mab
 ******************************************************************************/
 
#include "everything.h"
#include "myheader.h"
#include "mike_display.h"
#include "mymonitor.h"
#include <signal.h>

/* SHOULD BE IN MY HEADER.H */
Bool end_application ;
Bool just_pause ;
char application_filename[200]  ;

/* GLOBAL VARIABLE FOR DESTRYING EVERYTHING BEFORE TOPLEVEL */

char server[200]; /* SHOULD BE DECLARED IN MYHEADER.H */
int editorid;

/* Main widget, form widget (overall)
 * First children = Simulation area, form widget (simulation) :
 *   Title, label widget  (title_simulation)
 *
 *   highlevel, command widget (highlevel) CREATED in file Highlevel_control.c
 *   target, command widget (pgmtarget) CREATED in file Pgmtarget_control.c
 *   patset, command widget (patset) CREATED in file Patset_control.c
 *
 * only one of the following two are mapped 
 *   batch, command widget (batch)  
 *				CREATED in file BatchInteract_control.c
 *   interact, command widget (interact)  
 *				CREATED in file BatchInteract_control.c

 * only two of the following two are mapped 
 *   pgmrun, command widget (pgmrun) CREATED IN FILE Run_control.c
 *   pause, command widget (pause)
 *OR step, command widget (step) CREATED IN FILE StepCont_control.c
 *OR continuous, command widget (continuous) CREATED IN FILE StepCont_control.c
 *
 *   init, command widget (init) CREATED IN FILE Init_control.c
 *   load, command widget (lload) CREATED IN FILE LoadSave_control.c
 *   save, command widget (ssave) CREATED IN FILE LoadSave_control.c
 *   Exit command Widget (quit)
 *
 * Second children = Parameters area, form widget (status_simulation)
 *   hll text, asciiString widget (model_text) 
 *   hll file , label widget (model_param) 
 *   target text, asciiString widget (target_text) 
 *   target file , label widget (target_param) 
 *   stimuli text, asciiString widget (stimuli_text) 
 *   stimuli file , label widget (stimuli_param)
 *   init text, asciiString widget (init_text) 
 *   weights and states init, label widget (init_param)
 *   state simulation text, asciiString widget (state_simu_text) 
 *   state simulation , label widget (state_simu_param)
 *   application text, asciiString widget (appli_text) 
 *   application, label widget (appli_param)
 *    
 * Third Children = N or nC specification area, asciiDisk widget 
 * 			(spec_simulation) 
 * Fourth Children = cuurent application statement being executed 
 * 			(appli_statement_text ) 
 * 			(appli_statement_param ) 
 *    
*/



/* to give a visual idea of the widget hierarchy here. */
	Widget toplevel,
		overall,
			simulation,
	   	   		title_simulation,
				highlevel, pgmtarget,
				patset, batchmode ,interactmode ,
				pgmrun, pause, step , continuous ,
				lload, ssave, 
				init , quit ,
	   	   	status_simulation ,
			     model_text ,  target_text ,
                             stimuli_text , init_text, 
			   	   state_simu_text ,
				 appli_text ,
			     model_param , target_param ,
                             stimuli_param , init_param,
			 	   state_simu_param ,
				 appli_param ,
			spec_simulation ,
			  appli_statement_text ,
			  appli_statement_param ;

/* Args for title_simulation widget */
	Arg titlesimulation_arg[] = {
		{XtNlabel, (XtArgVal)TITLE_SIM},
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNresizable, (XtArgVal)True}, 
		{XtNheight, (XtArgVal)TITLE_HEIGHT}, 
		{XtNwidth, (XtArgVal)TITLE_WIDTH}, 
	};

float global_threshold = 0.5;

/*-----------------------------------------------------*/
/* CAUTION CAUTION  CAUTION CAUTION  CAUTION CAUTION  */
/*-----------------------------------------------------*/
/* The number of parameters of <any>param widget are used */
/* within the file AddInformation.c to change the XtNlabel param*/
/* NEWS = CAN NOT PASS THEM AS EXTERN (as Widget)		*/
/*-----------------------------------------------------*/


/* the following function is used to Pop windows up where the mouse pointer is,
 * as the toolkit stuff doen't get informed of any movements of windows after 
 * creation - so you can get menu's poppingup all over the place, which is not very good
 */

void PopUp(w, w_arg, arg1, arg2)
Widget w;
Arg w_arg[];
int arg1, arg2;
{
	Window junk_win;
	int x_root, y_root, garbage;
	unsigned int garbage_mask;

	XtRealizeWidget(w);
	XQueryPointer(XtDisplay(w), XtWindow(w), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
	XtSetArg(w_arg[arg1],XtNx, x_root-20) ;
	XtSetArg(w_arg[arg2],XtNy, y_root-20) ;
	XtSetValues(w, w_arg, XtNumber(w_arg));
	XtMapWidget(w);

	return;
}


/* normally after calling PopUp, you wil just want to unmap the widget, but for dynamic menus etc, you 
 * want to unrealise it too, so that it will be able to change the next time round if it needs to 
 */

void PopDown(w)
Widget w;
{
	XtUnmapWidget(w);
/*	XtUnrealizeWidget(w);*/
}



/*-----------------------------------------------------*/
/* CALLBACK FOR QUIT . KILLL THE SERVER		       */
/*-----------------------------------------------------*/
/*
 * callback function for the usual "quit" widget 
 * used in the root widget 
 */
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data;  /* not used */
caddr_t call_data;    /* not used */
{
/* CHANGES ACCORDING TO MIKE */
        Display *thedpy;
        Window thewin;
        Colormap pgm_cmap;
        thedpy = XtDisplay(toplevel);
        thewin = XtWindow(toplevel);
        XGetWindowAttributes(thedpy, thewin, &xwa);
        pgm_cmap = xwa.colormap;

/* Kill any existing nc_server on the machine specified */
/* 1- RPC terminate if there was one server running */
/* 2- REXEC ps grep to check that everything will go right */

       if ( !TerminateRpc() )
            {
                Error(62) ;
                return ;
             } ;

	kill(editorid, SIGKILL);
        XUninstallColormap(thedpy, pgm_cmap);
        XtDestroyWidget(toplevel) ;

	/* If i do XSync() ; the core dumped */
	XtDestroyWidget(toplevel) ;
	rc_update();
	exit(0);
}

/* callback for quit widget */
	static XtCallbackRec quitcallback[] = {
		{Quit, NULL},
		{NULL, NULL},
	};

/* Args for quit widget */
	static Arg quit_arg[] = {
		{XtNcallback, (XtArgVal)quitcallback},
		{XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNhorizDistance, (XtArgVal)4},
		{XtNfromVert, (XtArgVal)NULL},
		{XtNvertDistance, (XtArgVal)1},
		{XtNwidth, (XtArgVal)BUTTON_WIDTH}, 
		{XtNheight, (XtArgVal)BUTTON_HEIGHT}, 
	};

/*----------------------------------------------------*/
/* ARGUMENT FOR THE PARAM FALSE COMMAND WIDGET 		*/
/*   Children of status_simulation			*/
/*-----------------------------------------------------*/
/* CAUTION CAUTION  CAUTION CAUTION  CAUTION CAUTION  */
/*-----------------------------------------------------*/
/* The following parameters are used within the file 
/* AddInformation.c to change the XtNlabel param*/
/* Furthermore if you change the size you have to change */
/* it in the the AdddInformationfile */
/* MOREOVER these arguments are no more STATIC !!!!!!! */

/* Args for model_text widget */
	static Arg modeltext_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
 	        {XtNlabel, (XtArgVal)"HLL = "},
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyRight}, 
	};
/* Args for model_param widget */
	 Arg modelparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)" nC " },
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNresize, (XtArgVal)False}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyLeft}, 
	};
 
/* Args for target_text widget */
	static Arg targettext_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
 	        {XtNlabel, (XtArgVal)"Target = "},
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyRight}, 
	};

/* Args for target_param widget */
	 Arg targetparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)NULL},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNresize, (XtArgVal)False}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyLeft}, 
	};

/* Args for stimuli_text widget */
	static Arg stimulitext_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
 	        {XtNlabel, (XtArgVal)"Training Set ="},
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyRight}, 
	};

/* Args for stimuli_param widget */
	Arg stimuliparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)"None"},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNresize, (XtArgVal)False}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyLeft}, 
	};


/* Args for state_simu_text widget */
	static Arg statesimutext_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNfromHoriz, (XtArgVal)NULL},
 	        {XtNlabel, (XtArgVal)"Simulation ? "},
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
                {XtNheight, (XtArgVal)INFO_HEIGHT},
                {XtNwidth, (XtArgVal)INFO_WIDTH},
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyRight}, 

	};

/* Args for state_simu_param widget */
	Arg statesimuparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)" Not Started "},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNresize, (XtArgVal)False}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyLeft}, 
	};

/* Args for init_text widget */
	static Arg inittext_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
 	        {XtNlabel, (XtArgVal)"Weights & States ?"},
		{XtNfromHoriz, (XtArgVal)NULL},
 	        {XtNvertDistance, (XtArgVal)1},
 	        {XtNhorizDistance, (XtArgVal)1},
                {XtNheight, (XtArgVal)INFO_HEIGHT},
                {XtNwidth, (XtArgVal)INFO_WIDTH},
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyRight}, 
	};

/* Args for init_param widget */
	 Arg initparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)" = RANDOM & 0"},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNresize, (XtArgVal)False}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyLeft}, 
	};

/* Args for appli_text widget */
	static Arg applitext_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
 	        {XtNlabel, (XtArgVal)"Batch Appli = "},
		{XtNfromHoriz, (XtArgVal)NULL},
 	        {XtNvertDistance, (XtArgVal)1},
 	        {XtNhorizDistance, (XtArgVal)1},
                {XtNheight, (XtArgVal)INFO_HEIGHT},
                {XtNwidth, (XtArgVal)INFO_WIDTH},
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyRight}, 
	};

/* Args for appli_param widget */
	 Arg appliparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)" None"},
		{XtNfromHoriz, (XtArgVal)NULL},
		{XtNheight, (XtArgVal)INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)INFO_WIDTH}, 
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNresize, (XtArgVal)False}, 
		{XtNborderWidth, (XtArgVal)NULL}, 
		{XtNjustify, (XtArgVal)XtJustifyLeft}, 
	};


/* Args for applistatement_text widget */
	static Arg applistatementtext_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
 	        {XtNlabel, (XtArgVal)"Current application statement :"},
		{XtNfromHoriz, (XtArgVal)NULL},
                {XtNmappedWhenManaged, (XtArgVal)False},
 	        {XtNvertDistance, (XtArgVal)1},
 	        {XtNhorizDistance, (XtArgVal)1},
	};

/* Args for applistatementparam widget */
	 Arg applistatementparam_arg[] = {
		{XtNfromVert, (XtArgVal)NULL},
		{XtNlabel, (XtArgVal)"No current instructions       "},
		{XtNfromHoriz, (XtArgVal)NULL},
                {XtNmappedWhenManaged, (XtArgVal)False},
		{XtNvertDistance, (XtArgVal)1},
		{XtNhorizDistance, (XtArgVal)1},
		{XtNresize, (XtArgVal)False}, 
	};
/*----------------------------------------------------*/
/*----------------------------------------------------*/
/*----------------------------------------------------*/
/*----------------------------------------------------*/
/*----------------------------------------------------*/
/*----------------------------------------------------*/
/*----------------------------------------------------*/
/*  		THE MAIN 				*/
/*----------------------------------------------------*/
/* 
 * main 
 */
void main(argc, argv)
int argc;
char **argv;
{
/*----------------------------------------------------*/
/* ARGUMENT FOR THE CHILDREN OF OVERALL WIDGET */
/*      NB except all the command widget (see callback) */
/*      				and files _control */
/*----------------------------------------------------*/


extern Arg titlesimulation_arg[5];
extern Arg pause_arg[10];


static Arg toplevel_arg[] = {
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNborderWidth, (XtArgVal) 3},
	} ;

static Arg overall_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
	} ;
/* Args for the simulation widget 
 * ie colours 
 */
static Arg simulation_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
		{XtNborderWidth, (XtArgVal) NULL},
	} ;

/* Args for status_simulation widget */
	static Arg statussimulation_arg[] = {
 	        {XtNvertDistance, (XtArgVal)1},
		{XtNfromVert, (XtArgVal)NULL},
	/*	{XtNtextOptions, (XtArgVal)scrollVertical}, */
	/*	{XtNeditType, (XtArgVal)XttextAppend}, */
	/*	{XtNresizable, (XtArgVal)True},  */
		{XtNheight, (XtArgVal)SIM_INFO_HEIGHT}, 
		{XtNwidth, (XtArgVal)SIMULATION_WIDTH}, 
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
	};


/* Args for spec_simulation widget */
/* it takes the text to display within a file set before */
/* the XtCreate... */
	static Arg specsimulation_arg[] = {
 	        {XtNvertDistance, (XtArgVal)1},
 	        {XtNfile, (XtArgVal)NULL},
		{XtNfromVert, (XtArgVal)NULL},
		{XtNtextOptions, (XtArgVal)scrollVertical},
		{XtNeditType, (XtArgVal)XttextRead},
		{XtNresizable, (XtArgVal)True}, 
		{XtNheight, (XtArgVal)TEXTE_DISPLAY_HEIGHT},   
		{XtNwidth, (XtArgVal)SIMULATION_WIDTH}, 
	};


/*----------------------------------------------------*/
/* ARGUMENT FOR THE OVERALL WIDGET			*/ 
/*----------------------------------------------------*/


/*----------------------------------------------------*/
/* ARGUMENT FOR THE TOP LEVEL WIDGET			*/ 
/*----------------------------------------------------*/
/*
 * ie colours 
 */
char inverse_buf[3];
char buf[200] , buffy[50] ;
/*-----------------------------------
 * TRY MENU POP UP AS A NEW TRANSLATION TABLE
 * ASSOCIATED WITH CREATE
 */
/*Declaration of the new translation table */
static String new_trans = "<Btn1Up>:notify()" ;


/* Declaration of the new COMPILED translation table */
XtTranslations new_compiled ;
system("clear");
printf("\nInitialising Beta Release Pygmalion Environment...\n\n");
rc_read();

sprintf(inverse_buf, "%s", "on");



/*----------------------------------------------------*/
/* 		INITIALISE 				*/
/*----------------------------------------------------*/
/* INIT THE GLOBAL VARIABLES 
 * the mode is unknown
 * no file have been loaded
 */
mode = 'U' ; loadinput = 0 ; 
overallstatus = 'E' ; monochrome = False ;
strcpy(server , rc[RC_remote_host]) ;
/* application , algorithm , configuration */
my_application = False ; my_algorithm = False ; my_configuration = False ;

/* end of the execution of the application program */
  end_application = False ;
  just_pause = False ;


/* all the families */
connect_session = 0 ; assoc_session = 0 ; param_session = 0 ;

/* weight and state initialisation DEFAULT = init to 0  */
/* 1=> weight or states set to 1 */
/* 2=> weight or states set to Random  */
load_weight = 0 ; load_state = 0 ;

/* no high level langage choosen */
  strcpy(hlang , "none") ;


/* unknown by Xlib Xdebug = 1; */
	toplevel = XtInitialize("main" , "Weasel", NULL, 0, &argc, argv);


	overall = XtCreateManagedWidget("overall",
				formWidgetClass,
				toplevel,
				overall_arg,
				XtNumber(overall_arg));
 

	simulation = XtCreateManagedWidget("simulation",
				formWidgetClass,
				overall,
				simulation_arg,
				XtNumber(simulation_arg));


	    title_simulation = XtCreateManagedWidget("title",
				labelWidgetClass,
				simulation,
				titlesimulation_arg,
				XtNumber(titlesimulation_arg));

/*--------------------------------------------------*/
/* Creation of the highlevel command widget         */
/* 		menu popup 			    */
Highlevel() ;

/*--------------------------------------------------*/
/* Creation of the target command widget         */
Target() ;

/*--------------------------------------------------*/
/* Creation of the patset command widget         */
Patset() ;

/*--------------------------------------------------*/
/* Creation of the batch/Interactive command widget         */
  BatchInteract() ; 


/*--------------------------------------------------*/
/* Creation of pgmrun and pause AND Step Continuous , command widget 			*/
/*			no call back; Menupopup instead */ 
Pgmrun() ;
StepCont() ;


/*--------------------------------------------------*/
/* Creation of llaod AND ssave command widget 			*/

Lload() ;
Ssave() ;

/*--------------------------------------------------*/
/* Creation of init, command widget 			*/
/*			no call back; Menupopup instead */ 
Init() ;


 XtSetArg(quit_arg[5],XtNfromVert, init ) ; 
 XtSetArg(quit_arg[3],XtNfromHoriz, ssave) ; 

	quit = XtCreateManagedWidget("Quit",
				commandWidgetClass,
				simulation,
				quit_arg,
				XtNumber(quit_arg));



 XtSetArg(statussimulation_arg[1],XtNfromVert, simulation) ; 

	   status_simulation = XtCreateManagedWidget("title",
				formWidgetClass,
				overall,
				statussimulation_arg,
				XtNumber(statussimulation_arg));

/* APPLICATION */ 
		model_text = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				modeltext_arg,
				XtNumber(modeltext_arg));

XtSetArg(modelparam_arg[2],XtNfromHoriz, model_text) ; 
	
		model_param = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				modelparam_arg,
				XtNumber(modelparam_arg));

/* ALGORITHM */ 
XtSetArg(targettext_arg[0],XtNfromVert, model_text) ; 
		target_text = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				targettext_arg,
				XtNumber(targettext_arg));

XtSetArg(targetparam_arg[1],XtNlabel, server) ; 
XtSetArg(targetparam_arg[2],XtNfromHoriz, target_text) ; 
XtSetArg(targetparam_arg[0],XtNfromVert, model_text) ; 
		target_param = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
			        targetparam_arg,
				XtNumber(targetparam_arg));

/* SIMULATION STATE */ 
XtSetArg(statesimutext_arg[0],XtNfromVert, NULL) ; 
XtSetArg(statesimutext_arg[1],XtNfromHoriz, model_param) ; 
		state_simu_text = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				statesimutext_arg,
				XtNumber(statesimutext_arg));

XtSetArg(statesimuparam_arg[2],XtNfromHoriz, state_simu_text) ; 
		state_simu_param = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				statesimuparam_arg,
				XtNumber(statesimuparam_arg));

/* WEIGHTS AND STATES */ 
XtSetArg(inittext_arg[0],XtNfromVert, state_simu_text) ; 
XtSetArg(inittext_arg[2],XtNfromHoriz, target_param) ; 
		init_text = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				inittext_arg,
				XtNumber(inittext_arg));

XtSetArg(initparam_arg[0],XtNfromVert, state_simu_text) ; 
XtSetArg(initparam_arg[2],XtNfromHoriz, init_text) ; 
		init_param = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				initparam_arg,
				XtNumber(initparam_arg));

/* APPLICATION */ 
XtSetArg(applitext_arg[0],XtNfromVert, init_text) ; 
XtSetArg(applitext_arg[2],XtNfromHoriz, target_param) ; 
		appli_text = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				applitext_arg,
				XtNumber(applitext_arg));

XtSetArg(appliparam_arg[0],XtNfromVert, init_text) ; 
XtSetArg(appliparam_arg[2],XtNfromHoriz, appli_text) ; 
		appli_param = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				appliparam_arg,
				XtNumber(appliparam_arg));

/* INPUT */ 
XtSetArg(stimulitext_arg[0],XtNfromVert, target_text) ; 
		stimuli_text = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				stimulitext_arg,
				XtNumber(stimulitext_arg));

XtSetArg(stimuliparam_arg[0],XtNfromVert, target_text) ; 
XtSetArg(stimuliparam_arg[2],XtNfromHoriz, stimuli_text) ; 
		stimuli_param = XtCreateManagedWidget("",
				labelWidgetClass,
				status_simulation,
				stimuliparam_arg,
				XtNumber(stimuliparam_arg));
 
/* creation of application statement stuff */
 XtSetArg(applistatementtext_arg[0],XtNfromVert, status_simulation ) ; 
 XtSetArg(applistatementtext_arg[2],XtNfromHoriz, NULL) ; 

   appli_statement_text = XtCreateManagedWidget("applistatementtext",
				labelWidgetClass,
				overall,
				applistatementtext_arg,
				XtNumber(applistatementtext_arg));
 

 XtSetArg(applistatementparam_arg[0],XtNfromVert, status_simulation ) ; 
 XtSetArg(applistatementparam_arg[2],XtNfromHoriz, appli_statement_text) ; 

   appli_statement_param = XtCreateManagedWidget("appli_statement_param",
				labelWidgetClass,
				overall,
				applistatementparam_arg,
				XtNumber(applistatementparam_arg));


/* At the moment just a simulation of an edition of a file */
 strcpy(buffy, "empty.nC" ) ;
 sprintf(buf, "%s/%s" , rc[RC_error_message_directory], buffy) ;
 XtSetArg(specsimulation_arg[1],XtNfile,buf) ; 

 XtSetArg(specsimulation_arg[2],XtNfromVert, appli_statement_text) ; 

	   spec_simulation = XtCreateManagedWidget("spec",
				asciiDiskWidgetClass,
				overall,
				specsimulation_arg,
				XtNumber(specsimulation_arg));

/*
 * use toplevel args to set the back ground colour only
 * NB if you set the size than you can set the size
 * of the children 
 * The idea is, when you use a form Widget to set
 * the size of only the bottom children
 */
XtSetValues(toplevel, toplevel_arg, XtNumber(toplevel_arg)) ;

/*
 * realize them and go ...
 */
	XtRealizeWidget(toplevel);


/* CHANGES ACCORDING TO MIKE */
        topdpy = XtDisplay(toplevel);
       topwin = XtWindow(toplevel);

       gc = XCreateGC(topdpy, topwin, 0, 0);
/* Mike's stuff to get if monochrome or not */
	if(DisplayCells(topdpy,  DefaultScreen(topdpy)) == 2)
	{
  		monochrome = True ;
		
/*		if(strcmp(INVBUF, rc[RC_inverse_display]))
		{
			XSetBackground(topdpy, gc, WhitePixel(topdpy, DefaultScreen(topdpy)));
			XSetForeground(topdpy, gc, BlackPixel(topdpy, DefaultScreen(topdpy)));
			XSetWindowBackground(topdpy, topwin, WhitePixel(topdpy, DefaultScreen(topdpy)));
	        }
		else
		{
			XSetBackground(topdpy, gc, BlackPixel(topdpy, DefaultScreen(topdpy)));
			XSetForeground(topdpy, gc, WhitePixel(topdpy, DefaultScreen(topdpy)));
			XSetWindowBackground(topdpy, topwin, BlackPixel(topdpy, DefaultScreen(topdpy)));
	        }
*/		
		init_color_scales(topdpy, topwin, gc, xwa.colormap);
	}
	else
	{

		pgm_cmap =  XCreateColormap(topdpy, topwin, XDefaultVisual(topdpy, DefaultScreen(topdpy)), AllocAll);

/*		pgm_cmap =  XCreateColormap(topdpy, topwin, XDefaultVisual(topdpy, DefaultScreen(topdpy)), AllocAll);*/
/*	        XSetWindowColormap(topdpy, topwin, pgm_cmap);*/
		XSetWindowColormap(topdpy, topwin, pgm_cmap);

		init_color_scales(topdpy, topwin, gc, pgm_cmap);


/*	        XInstallColormap(topdpy, pgm_cmap); */

/*fflush(stdout);*/
	}


       XGetWindowAttributes(topdpy, topwin, &xwa);
        display_logo(topdpy, topwin, gc, pgm_cmap);

/* Map the BATCH , RUN , PAUSE button boxes */
XtMapWidget(batchmode) ;
XtMapWidget(pgmrun) ;
XtMapWidget(pause) ;

        XtMainLoop() ;
  
}
