/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 30/1/90
 *
 * file contains pixmap/image drawing functions for initial logo and credits
 *
 * logo.c
 ******************************************************************************/

#include "mike_display.h"
#include "pgm_logo.bm"
#include "pgm_logo_inv.bm"
#include "pgm_credits.bm"


Pixmap MakeCenteredPixmap(dpy, w, gc, width, height, pixmap_depth, data, pwidth, pheight)
Display *dpy;
Drawable w;
GC gc;
unsigned int width, height;
unsigned int pixmap_depth;
char *data;
int pwidth, pheight;
{
    XImage ximage;
    Pixmap pid;
    int dx, dy;

    pid = XCreatePixmap(dpy, w, width, height, pixmap_depth);

    ximage.height = pheight;
    ximage.width = pwidth;
    ximage.xoffset = 0;
    ximage.format = XYBitmap;
    ximage.data = (char *) data;
    ximage.byte_order = LSBFirst;
    ximage.bitmap_unit = 8;
    ximage.bitmap_bit_order = LSBFirst;
    ximage.bitmap_pad = 8;
    ximage.bytes_per_line = (pwidth + 7) >> 3;
    ximage.depth = 1;

    dx = (width - pwidth) / 2;
    dy = (height - pheight) / 2;

if(DisplayCells(dpy, DefaultScreen(dpy)) > 2)
{
	XSetForeground(dpy, gc, my_yellow.pixel);
}
else
{
	XSetForeground(dpy, gc, my_bg.pixel);
}
   	XPutImage(dpy, pid, gc, &ximage, 0, 0, dx, dy, pwidth, pheight);

    return (pid);
}


void display_logo(dpy, win, gc, cmap)
Display *dpy;
Window win;
GC gc;
Colormap cmap;
{
XEvent current;
XEvent ahead;
char textlabel[512];

	XGetGeometry(dpy, win, &parent_root, &parent_x, &parent_y, &parent_width, &parent_height, &parent_border, &parent_depth);

if(DisplayCells(dpy, DefaultScreen(dpy)) > 2)
{
	my_bg.red = 16000; my_bg.green = 16000; my_bg.blue = 53000;
	my_bg.flags = DoRed|DoGreen|DoBlue;
	my_bg.pixel = 0;
	XStoreColor(dpy, cmap, &my_bg);
}

/* want to override the wm as it's just a temp window, and don't want the user to be prompted to
 * open it - it can cause lots of timing problems
 */
	xswa.override_redirect = True;
	logo_win = XCreateWindow(dpy, win,parent_x-100, parent_y-100,parent_width+200, parent_height+200, 0, DefaultDepth(dpy, DefaultScreen(dpy)), InputOutput, CopyFromParent, CWOverrideRedirect|CWBackPixmap, &xswa);

	XSync(dpy, 0);	
	XSelectInput(dpy, logo_win, ExposureMask|ButtonPressMask);


if(DisplayCells(dpy, DefaultScreen(dpy)) > 2)
{
        XSetWindowBackground(dpy, logo_win, my_bg.pixel);
	XSetBackground(topdpy, gc, my_bg.pixel);
        XSetForeground(topdpy, gc, my_yellow.pixel);
}
else 
{
	XSetWindowBackground(dpy, logo_win, my_fg.pixel);
	XSetBackground(topdpy, gc, my_fg.pixel);
        XSetForeground(topdpy, gc, my_bg.pixel);	
}

	XSync(dpy, 0);
	xswa.background_pixmap = MakeCenteredPixmap(dpy, win, gc, parent_width+200, parent_height+200, DefaultDepth(dpy, DefaultScreen(dpy)), pgm_logo_bits, pgm_logo_width, pgm_logo_height);
	xswa.backing_store = Always;
	XChangeWindowAttributes(dpy, logo_win, CWBackPixmap|CWBackingStore, &xswa);

/* need the following for drawing text etc.  DOES NOT ALWAYS work, as sometimes the wm 
 * interferes with the placement and it messes up - no time to make it 
 * work 100% though - watch for the next release!
 */
 
	XGetGeometry(dpy, logo_win, &parent_root, &logo_x, &logo_y, &logo_width, &logo_height, &logo_win_border, &logo_win_depth);
	
	
	XMapRaised(dpy, logo_win);
	XNextEvent(dpy, &current);

/* the next loop is for while the logo is displayed - to start 
 * the main prog the user just clicks in the window
 */

sprintf(textlabel, "%s", rc[RC_large_font]);
	my_big_font = XLoadQueryFont(dpy, textlabel);
sprintf(textlabel, "%s", rc[RC_small_font]);
	my_little_font = XLoadQueryFont(dpy, textlabel);
sprintf(textlabel, "%s", rc[RC_fixed_font]);
	my_norm_font = XLoadQueryFont(dpy, textlabel);


			XSetFont(dpy, gc, my_big_font->fid);

			string_width = XTextWidth(my_big_font, PROG_NAME, strlen(PROG_NAME));
			XDrawImageString(dpy, logo_win, gc, logo_x+100+((logo_width-string_width)/2), 150, PROG_NAME, strlen(PROG_NAME));
		

			string_width = XTextWidth(my_big_font, PROG_NAME1, strlen(PROG_NAME1));
			XDrawImageString(dpy, logo_win, gc, logo_x+100+((logo_width-string_width)/2), 180, PROG_NAME1, strlen(PROG_NAME1));

			string_width = XTextWidth(my_big_font, PROG_NAME2, strlen(PROG_NAME2));
			XDrawImageString(dpy, logo_win, gc, logo_x+100+((logo_width-string_width)/2), 210, PROG_NAME2, strlen(PROG_NAME2));

			XSetFont(dpy, gc, my_norm_font->fid);


			string_width = XTextWidth(my_norm_font, COPYRIGHT, strlen(COPYRIGHT));
			XDrawImageString(dpy, logo_win, gc, logo_x+100+((logo_width-string_width)/2), logo_y-100+logo_height-25, COPYRIGHT, strlen(COPYRIGHT));

			string_width = XTextWidth(my_norm_font, VERSION, strlen(VERSION));
			XDrawImageString(dpy, logo_win, gc, logo_x+100+((logo_width-string_width)/2), logo_y-100+logo_height-50, VERSION, strlen(VERSION));
			
if(DisplayCells(dpy, DefaultScreen(dpy)) > 2)
{
	XSetForeground(dpy, gc, my_red.pixel);
}
else
{
	XSetForeground(dpy, gc, my_bg.pixel);
}
			string_width = XTextWidth(my_big_font, "OK", strlen("OK"));
			XDrawRectangle(dpy, logo_win, gc, logo_x+logo_width-20-(2*string_width), logo_y+logo_height-50, (2*string_width), 30);
			XSetLineAttributes(dpy, gc, 2, LineSolid, CapRound, JoinMiter);
if(DisplayCells(dpy, DefaultScreen(dpy)) > 2)
{
	XSetForeground(dpy, gc, my_yellow.pixel);
}
else
{
	XSetForeground(dpy, gc, my_bg.pixel);
}
			XDrawRectangle(dpy, logo_win, gc, logo_x+logo_width-17-(2*string_width), logo_y+logo_height-47, (2*string_width)-5, 25);
			XDrawString(dpy, logo_win, gc, logo_x+logo_width-10-((3*string_width)/2), logo_y+logo_height-30, "OK", strlen("OK"));
			


			XSetFont(dpy, gc, my_little_font->fid);
			
			string_width = XTextWidth(my_little_font, PART_INTRO, strlen(PART_INTRO));
			XDrawImageString(dpy, logo_win, gc, logo_x+100+((logo_width-string_width)/2), logo_y+logo_height-50, PART_INTRO, strlen(PART_INTRO));
			string_width = XTextWidth(my_little_font, PARTNERS, strlen(PARTNERS));
			XDrawImageString(dpy, logo_win, gc, logo_x+100+((logo_width-string_width)/2), logo_y+logo_height-25, PARTNERS, strlen(PARTNERS));
	while(1)
	{
		if(current.type == ButtonPress)
		{
			xswa.background_pixmap = MakeCenteredPixmap(dpy, win, gc, parent_width+200, parent_height+200, DefaultDepth(dpy, DefaultScreen(dpy)), pgm_credits_bits, pgm_credits_width, pgm_credits_height);
			XChangeWindowAttributes(dpy, logo_win, CWBackPixmap, &xswa);
			XClearWindow(dpy, logo_win);
			XSync(dpy, 0);
			system("sleep 1");
			break;
		}
/*		if(current.type == Expose)
		{
			while(XEventsQueued(current.xexpose.display, QueuedAfterReading) > 0)
			{
				XPeekEvent(current.xexpose.display, &ahead);
				if(ahead.type != Expose) break;
				if(ahead.xexpose.window != current.xexpose.window) break;
				XNextEvent(current.xexpose.display, &current);
			}
			
		}
*/
		XNextEvent(dpy, &current);
	}

	XUnmapWindow(dpy, logo_win);
	XMapRaised(dpy, win);
if(DisplayCells(dpy, DefaultScreen(dpy)) > 2)
{
	my_bg.red = atoi(rc[RC_main_background_red]); my_bg.green = atoi(rc[RC_main_background_green]); my_bg.blue = atoi(rc[RC_main_background_blue]);
	my_bg.flags = DoRed|DoGreen|DoBlue;
	my_bg.pixel = 0;
	XStoreColor(dpy, cmap, &my_bg);
}
	return;
}
