/******************************************************************************/
/**									     **/
/**		      Copyright 1989 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission     **/
/** of Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.0 24/11/89 mjh
 *
 * pgm cluster level graphic drawing
 *
 * cluster_level.c
 ******************************************************************************/
 
#include "mike_display.h"
#include "everything.h"


extern confres *conf;


/* function that draws an individual layer in the graphic window.  Takes 
 * the full area, unless a connection matrix being shown, in which case 
 * the horizontal shrinks to half the window width. - needs to be passed
 * an area_width which is half that of xwa.width
 */

void draw_cluster(w, gc, cmap, mikepath, area_width, win_height, cluster_low_color, cluster_high_color)
Widget w;
GC gc;
Colormap cmap;
int mikepath[4];
int area_width;
int win_height;
char cluster_low_color;
char cluster_high_color;
{

/* for drawing the clusters proportionally sized in a grid */

	double temp;
	int neuron_drawing_width, neuron_drawing_height;
	int neuron_width, neuron_height;
	int number_horizontal, number_vertical;
	int i,j;
	int neurons_drawn;
	int number_cluster_neurons;
	rpcsys *rpcconf;
	float *first_attribute;
	char textlabel[512];	
	float neuron_color_scale[2];
	float neuron_color_multiply;
	int number_of_shades = 20;

	rpcconf = conf->confres_u.sys;
	number_cluster_neurons = rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[mikepath[1]].rpclay_val[mikepath[2]].rpcclu_len;
	first_attribute = (float *) calloc(sizeof(float), number_cluster_neurons);
	SetToState(mikepath, first_attribute);
	GiveNeuronScaleFamily(mikepath, neuron_color_scale);
	neuron_color_multiply = 1/(neuron_color_scale[1]-neuron_color_scale[0]);
	

/* deal with the error case first.  ie if cluster has no neurons.  Then
 * do the special cases ie 1 to 3 neurons.  Finally go throught the 
 * general case of calculating where to display the neurons if greater
 * than three in the cluster
 */

	if(number_cluster_neurons == 0)
	{	
		/* no neurons! - should never get called */
		Error(18);
		return;
	}
	else if(number_cluster_neurons < 4)
		{
/******************
 * ERROR - THIS WILL NOT WORK AS NOT DEFINED
 **************/
			neuron_drawing_width = ((9*neuron_width)/10);
			neuron_drawing_height = ((9*neuron_height)/10);

			for(i=0; i<number_cluster_neurons; i++)
			{
				set_color(w, mikepath, gc, cmap, cluster_low_color, cluster_high_color, ((first_attribute[i]-neuron_color_scale[0])*neuron_color_multiply));
				XSetForeground(dpy, gc, my_drawing_color.pixel);
				XFillRectangle(dpy, gra_win, gc, ((area_width/5)*(i+1)), (win_height/5), (area_width/6), ((3*win_height)/5));
				if(neuron_height < 16)
				{
					XSetForeground(dpy, gc, my_fg.pixel);
					sprintf(textlabel, "%i", i+1);
					XDrawImageString(dpy, gra_win, gc, ((area_width/5)*(i+1)), (win_height/5), textlabel, strlen(textlabel));
				}
			}
		}
		else 
		{
			neuron_height = (win_height-60)/3;
			neuron_width = area_width/(number_cluster_neurons+4);
			if(neuron_width < 2) 
			{
				/* window too narrow */
				Error(15);
				return;
			}
			if(neuron_height < 2) 
			{
				/* window too short */
				Error(16);
				return;
			}

	neuron_drawing_width = ((9*neuron_width)/10);
	neuron_drawing_height = ((9*neuron_height)/10);


		/* now that the size of a neuron is calculated, draw them */

			for(i=0; i<number_cluster_neurons; i++)
			{
				set_color(w, mikepath, gc, cmap, cluster_low_color, cluster_high_color, ((first_attribute[i]-neuron_color_scale[0])*neuron_color_multiply));
				XSetForeground(dpy, gc, my_drawing_color.pixel);
				XFillRectangle(dpy, gra_win, gc, ((2+i)*neuron_width), neuron_height, neuron_width, neuron_drawing_height);
				if(neuron_height < 16)
				{
					XSetForeground(dpy, gc, my_fg.pixel);
					sprintf(textlabel, "%i", i+1);
					XDrawImageString(dpy, gra_win, gc,((2+i)*neuron_width)-2, (neuron_height*2), textlabel, strlen(textlabel));
				}
			}
			/* draw box around */
			XSetForeground(dpy, gc, my_fg.pixel);
			XDrawRectangle(dpy, gra_win, gc, (2*neuron_width)-2, neuron_height-2, (number_cluster_neurons*neuron_width)+4, neuron_drawing_height+4);
		}

	
	shade_scale(w, mikepath, area_width, win_height, cluster_low_color, cluster_high_color, number_of_shades);
	XSetForeground(dpy, gc, my_fg.pixel);
	sprintf(textlabel, "%c ->  %c  Shading (%f,%f)", cluster_low_color, cluster_high_color, neuron_color_scale[0], neuron_color_scale[1]);
	XDrawImageString(dpy, gra_win, gc, 5, win_height -5, textlabel, strlen(textlabel));

	free(first_attribute);
	return;
}



/* function that draws a matrix of the connection and weights of aforementioned 
 * between the output of one neurons and the input of another.  The 
 * two neurons are selected by widget stuff.  If this function is called then
 * the above function, draw_cluster must be called also, with a win_width half that
 * of the actual window.  Then the system will be drawn, scaled horizontally to fit
 * in the left half of the window
 */




void draw_cluster_connection(w, gc, cmap, mikepath, connpath1, connpath2, area_width, win_height, cluster_low_color, cluster_high_color)
Widget w;
GC gc;
Colormap cmap;
int mikepath[4];
int connpath1[4];
int connpath2[4];
int area_width;
int win_height;
char cluster_low_color;
char cluster_high_color;
{

int neuron_width;
int neuron_height;
int shift;		/* right shift for the coords, as this function only uses */
int neuronA;
int neuronB;
rpcsys *rpcconf;
char textlabel[512];
float *first_attribute;
float *second_attribute;
float *weight_attribute;
int label_increment;
float neuron_color_scale[2];
float neuron_color_multiply;
float weight_color_scale[2];
float weight_color_multiply;
int normalize[2];
rpcconf = conf->confres_u.sys;



	shift = area_width/2;
	XSetForeground(dpy, gc, my_fg.pixel);
	XSetLineAttributes(dpy, gc, 0, LineSolid, CapRound, JoinMiter);
	XDrawLine(dpy, gra_win, gc, shift, 0, shift, win_height);

	first_attribute = (float *)calloc(sizeof(float), 1);
	second_attribute = (float *)calloc(sizeof(float), 1);
	weight_attribute = (float *)calloc(sizeof(float), 1);

	SetToState(connpath1, first_attribute);
	SetToState(connpath2, second_attribute);
	SetToWeight(connpath1, connpath2, weight_attribute);


	
	GiveNeuronScaleFamily(mikepath, neuron_color_scale);
	GiveWeightScaleFamily(mikepath, weight_color_scale);

	neuron_color_multiply = 1/(neuron_color_scale[1]-neuron_color_scale[0]);
	weight_color_multiply = 1/(weight_color_scale[1]-weight_color_scale[0]);

/* should be dynamic but not yet! */
	label_increment = 10;
	
	neuron_width = shift/7;
	if(neuron_width < 2) 
	{
		/* window too narrow */
		Error(15);
		return;
	}
		
	neuron_height = (win_height-20) / 7;
	if(neuron_height < 2) 
	{
		/* window too short */
		Error(16);
		return;
	}

/* just put up three neuron shapes - one each for the two selected, 
 * and one in the middle to show the synapse
 */

	set_color(w, mikepath, gc, cmap, cluster_low_color, cluster_high_color, ((first_attribute[0]-neuron_color_scale[0])*neuron_color_multiply));
	XSetForeground(dpy, gc, my_drawing_color.pixel);
	XFillRectangle(dpy, gra_win, gc, (shift+(3*neuron_width)), ((9*neuron_height)/5), ((9*neuron_width)/10), ((9*neuron_height)/10));
	XSetForeground(dpy, gc, my_fg.pixel);
	XDrawRectangle(dpy, gra_win, gc, (shift+(3*neuron_width))-2, ((9*neuron_height)/5)-2, ((9*neuron_width)/10)+4, ((9*neuron_height)/10)+4);
	sprintf(textlabel, "Neuron %i", connpath1[2]+1);
	XDrawImageString(dpy, gra_win, gc, (shift+(3*neuron_width)), ((9*neuron_height)/5)-1, textlabel, strlen(textlabel));
	free(first_attribute);
	
	set_color(w, mikepath, gc, cmap, cluster_low_color, cluster_high_color, ((second_attribute[0]-neuron_color_scale[0])*neuron_color_multiply));
	XSetForeground(dpy, gc, my_drawing_color.pixel);
	XFillRectangle(dpy, gra_win, gc, (shift+((9*neuron_width)/5)), (3*neuron_height), ((9*neuron_width)/10), ((9*neuron_height)/10));
	XSetForeground(dpy, gc, my_fg.pixel);
	XDrawRectangle(dpy, gra_win, gc, (shift+((9*neuron_width)/5))-2, (3*neuron_height)-2, ((9*neuron_width)/10)+4, ((9*neuron_height)/10)+4);
	sprintf(textlabel, "Neuron %i", connpath1[2]+1);
	XDrawImageString(dpy, gra_win, gc, (shift+((9*neuron_width)/5)), (3*neuron_height)-1, textlabel, strlen(textlabel));
	free(second_attribute);

	if(weight_attribute[0] != 1000000.000000)
	{
		set_color(w, mikepath, gc, cmap, cluster_low_color, cluster_high_color, ((weight_attribute[0]-weight_color_scale[0])*weight_color_multiply));

	}
	else
	{
		my_drawing_color.pixel = my_bg.pixel;
	}
	XSetForeground(dpy, gc, my_drawing_color.pixel);
	XFillRectangle(dpy, gra_win, gc, (shift+(3*neuron_width)), (3*neuron_height), ((9*neuron_width)/10), ((9*neuron_height)/10));
	XSetForeground(dpy, gc, my_fg.pixel);
	XDrawRectangle(dpy, gra_win, gc, (shift+(3*neuron_width))-2, (3*neuron_height)-2, ((9*neuron_width)/10)+4, ((9*neuron_height)/10)+4);
	free(weight_attribute);


	XSetForeground(dpy, gc, my_fg.pixel);
        sprintf(textlabel, "Weight (%f, %f)", weight_color_scale[0], weight_color_scale[1]);
        XDrawImageString(dpy, gra_win, gc, shift +5, win_height -5, textlabel, strlen(textlabel));
			
	
	return;
}
