/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * SetInput.c
 ******************************************************************************/

#include "myheader.h"


/*----------------------------------------------------*/
/* THESES PROC TAKE CARE THE FAMILY OF INPUT PATTERNS */
/* DURING THE EXECUTION                        */
/* 0- GetInputCorrect() => seet the name of the input patterns only */
/* 1- SetInput() => Set the number of input patterns specified */
/* 			and set the index of the currently loaded  to 1 */
/* 2- TotalPattern() => Gives back the total nbe of patterns	*/ 
/* 3- LoadPatViaInput() => Call MagaliPattern( 0) for input only       	*/ 
/* 4- LoadPatViaAll() => Call MagaliPattern(1) for input AND target    	*/ 
/* 5- NeedRead()     => Tells you if there is a need to read a pat or not*/
/* 5- LoadAppliInput() => Call MagaliPattern(index 0) for input only     	*/ 
/* 6- LoadAppliTarget() => Call MagaliPattern(index 1) for input AND target    	*/ 
/* => should change in next version to load only the target */
/*----------------------------------------------------*/
#define LIMIT 100 

 typedef char  one_name[100] ;
 
 typedef struct {
		int number_patterns ;
		int index ;
		char current_filename[200] ;
	        one_name patname[200] ; 
	        one_name inputname[200] ; 
		}  InputFamily ;

 InputFamily theinput ;


/* LATER TO CHANGE IN ORDER TO HAVE ONLY THE LAST PART OF A PATTERN NAME */
/*----------------------------------------*/
/* try to put in theinput.inputname[i] just the input pattern name */

  void GetInputCorrect() 
  {
  int i , split , count  , j ;
  char *temp ;
  Bool bdfending , otherending ;
 
  count = 0 ; split = 0 ;
/* just for all */
 for (count = 0 ; count < theinput.number_patterns ; count ++)
 {

/* set the format of patterns to false */
   bdfending = False  ; otherending = False ; 

/* read all characters until finding .bdf */
  i = 0 ;
  while (i < 200 )
  {
   if ( (theinput.inputname[count][i] == 'b' &&
         theinput.inputname[count][i+1] == 'd' &&
         theinput.inputname[count][i+2] == 'f'  )
       ||
         theinput.inputname[count][i] == ' ' && i!= 0 
      )
     {
     split = i+ 3;
     bdfending = True ; 
     i = 200 ;
     } ;
  
/* in case of no xxx file */ 
    if ( theinput.inputname[count][i] == 'x'  &&  
          theinput.inputname[count][i+1] == 'x' && 
          theinput.inputname[count][i+2] == 'x'  )
     {
     split = i + 3 ;
     i = 200 ;
     otherending = True ; 
     } ;
/* in case of no float file */ 
    if ( theinput.inputname[count][i] == 'f'  &&  
          theinput.inputname[count][i+1] == 'l' && 
          theinput.inputname[count][i+2] == 'o' && 
          theinput.inputname[count][i+3] == 'a' && 
          theinput.inputname[count][i+4] == 't'  )
     {
     split = i + 5 ;
     i = 200 ;
     otherending = True ; 
     } ;

/* in case of no float file */ 
    if ( theinput.inputname[count][i] == 'i'  &&  
          theinput.inputname[count][i+1] == 'n' && 
          theinput.inputname[count][i+2] == 't' )
     {
     split = i + 3 ;
     i = 200 ;
     otherending = True ; 
     } ;
 
   i = i + 1 ;
  } ;

/* in case of bdf take the number after .bdf  */
/*   otherwise no number  DO LATER */
/* skip all characters until finding something else than space and tab */
   j = split ;
   while ( j < 200 && bdfending )
	{
       if( theinput.inputname[count][j] == ' ' ||
           theinput.inputname[count][j] == '\t' 
         )
         j = j + 1  ;
       else
         { split = j ; j = 200 ; } ;
	} ;

/* now in split I have the lenght of the one I want - one char */
/* so try to put it */
  temp =  (char *) calloc(sizeof(char), 100) ;

  for ( i = 0 ; i < split+1 ; i++)
    temp[i] = theinput.inputname[count][i] ;

/* And then finally put that back in .inputname */
     strcpy(theinput.inputname[count] , temp) ;

  free(temp) ;

/* end of the count for loop */
  };
 }

/* LATER TO CHANGE IN ORDER TO HAVE ONLY THE LAST PART OF A PATTERN NAME */
/*----------------------------------------*/
/* Set the family at the beginning of the session */
/*     assign the total number of patterns           */
/*     assign each name according to the position    */
/*     assign the current one to be 1                */
  void SetInput(afilename) 
  char *afilename ;
  {
  FILE *ftry ;
  one_name one_line ;
  char *index() ;
  int count ;


   theinput.number_patterns  = 0 ; 
   theinput.index = 0  ;
   strcpy(theinput.current_filename , afilename ) ;
  if ( !(ftry = fopen(afilename, "r") ) )
      {
      Error(13) ;
      return ;
      }  ;
  count = 0 ;
/* here should test if it is a comment */
  while( fgets(one_line, LIMIT , ftry) != NULL  && !feof(ftry) )
     { 
      if (one_line[0] != '\n' && one_line[0] != '#')  
	 {
          theinput.number_patterns = theinput.number_patterns +1 ;
          *index(one_line , '\n') = '\0' ;
          strcpy(theinput.patname[count] , one_line ) ;
          strcpy(theinput.inputname[count] , one_line ) ;
          count++ ; 
	 } ; 
       } ;

/* read input AND target AND fill the dimension of the matrix */
     MagaliPattern(theinput.current_filename , theinput.index, 2) ;

   GetInputCorrect() ;
  }

/*----------------------------------------*/
  int TotalPattern() 
  {
   return(theinput.number_patterns) ;
  }



/*----------------------------------------*/
/* Load Input only */
  void LoadPatViaInput()
  {

  MagaliPattern(theinput.current_filename , theinput.index, 0) ;
  }
/*----------------------------------------*/
/* Load Input AND Target */
  void LoadPatViaAll()
  {

  MagaliPattern(theinput.current_filename , theinput.index, 1) ;
  }


/*----------------------------------------*/
/* Load RANK  Inputonly */
  void LoadAppliInput(rank)
  int rank ;
  {

  MagaliPattern(theinput.current_filename , rank, 0) ;
  }
/*----------------------------------------*/
/* Load RANK Input AND Target */
  void LoadAppliTarget(rank)
  int rank ;
  {

  MagaliPattern(theinput.current_filename , rank, 1) ;
  }


/*----------------------------------------*/
/* According to an index it gives the name of input AND target pats */
  void GivePatName(which, result )
  int which ;
  char **result ;
  {
  int i ;
  
   for ( i= 0 ; i < theinput.number_patterns ; i++)
      {
      if (i == which )
         {
         *result = theinput.patname[i] ;
         } ;
      } ;
  
  }

/*----------------------------------------*/
/* According to an index it gives the name of the INPUT only pat */
  void GiveInpName(which, result )
  int which ;
  char **result ;
  {
  int i ;
  
   for ( i= 0 ; i < theinput.number_patterns ; i++)
      {
      if (i == which )
         {
         *result = theinput.inputname[i] ;
         } ;
      } ;
  
  }
/*----------------------------------------*/
/* According to an index 		*/
/* it returns 0 if index = current      */
/*            1 else + update thefiled current */
  int NeedRead(which)
  int which ;
  {
  int i;
 
  if (which == theinput.index)
     return(0) ;
    
  theinput.index= which ;
  return(1) ; 
  
  }

